/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.directory;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.http.directory.HttpDirectoryServiceHandler;
import org.kaazing.gateway.service.http.directory.cachecontrol.ConflictResolverUtils;
import org.kaazing.gateway.service.http.directory.cachecontrol.PatternCacheControl;
import org.kaazing.gateway.service.http.directory.cachecontrol.PatternMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDirectoryService
implements Service {
    private static final Comparator<PatternCacheControl> PATTERN_CACHE_CONTROL_COMPARATOR = new Comparator<PatternCacheControl>(){

        @Override
        public int compare(PatternCacheControl first, PatternCacheControl second) {
            return Integer.valueOf(first.getMatchingPatternCount()).compareTo(second.getMatchingPatternCount());
        }
    };
    private final Logger logger = LoggerFactory.getLogger((String)"service.directory");
    private HttpDirectoryServiceHandler handler;
    private ServiceContext serviceContext;

    public String getType() {
        return "directory";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        String pathSeparator;
        this.serviceContext = serviceContext;
        this.handler = new HttpDirectoryServiceHandler();
        File webDir = serviceContext.getWebDirectory();
        ServiceProperties properties = serviceContext.getProperties();
        Collection accepts = serviceContext.getAccepts();
        HashSet<String> failedAccepts = new HashSet<String>();
        for (String accept : accepts) {
            String path = URIUtils.getPath((String)accept);
            if (path != null && !path.isEmpty()) continue;
            failedAccepts.add(accept);
        }
        if (!failedAccepts.isEmpty()) {
            throw new IllegalArgumentException("The following directory service accept elements are missing the URL path. You may need to add a trailing slash): " + failedAccepts);
        }
        String directory = properties.get("directory");
        if (directory == null) {
            throw new IllegalArgumentException("Missing required property: directory");
        }
        File directoryFile = this.toFile(webDir, directory);
        String welcomeFile = properties.get("welcome-file");
        if (welcomeFile != null && welcomeFile.contains(pathSeparator = File.pathSeparator)) {
            throw new IllegalArgumentException("Unexpected character \"" + pathSeparator + "\" in welcome file: " + welcomeFile);
        }
        File errorPagesDir = this.toFile(webDir.getParentFile(), properties.get("error-pages-directory"));
        File clientAccessPolicyXml = new File(directoryFile, "/clientaccesspolicy.xml");
        if (clientAccessPolicyXml.exists()) {
            for (String accept : accepts) {
                this.logger.warn("Ignoring user-defined file contents for {}clientaccesspolicy.xml, please modify configuration instead", (Object)accept);
            }
        }
        this.handler.setServiceContext(serviceContext);
        this.handler.setBaseDir(directoryFile);
        this.handler.setWelcomeFile(welcomeFile);
        this.handler.setErrorPagesDir(errorPagesDir);
        this.handler.setPatterns(this.buildPatternsList(properties));
        String indexes = properties.get("options");
        if (indexes != null && "indexes".equalsIgnoreCase(indexes)) {
            this.handler.setIndexes(true);
        }
    }

    private List<PatternCacheControl> buildPatternsList(ServiceProperties properties) {
        LinkedHashMap<String, PatternCacheControl> patterns = new LinkedHashMap<String, PatternCacheControl>();
        List locationsList = properties.getNested("location");
        if (locationsList != null && locationsList.size() != 0) {
            for (ServiceProperties location : locationsList) {
                String[] patternList;
                String directiveList = location.get("cache-control");
                for (String pattern : patternList = location.get("patterns").split("\\s+")) {
                    patterns.put(pattern, new PatternCacheControl(pattern, directiveList));
                }
            }
            this.resolvePatternSpecificity(patterns);
            return this.sortByMatchingPatternCount(patterns);
        }
        return new ArrayList<PatternCacheControl>(patterns.values());
    }

    private void resolvePatternSpecificity(Map<String, PatternCacheControl> patterns) {
        ArrayList<String> patternList = new ArrayList<String>();
        patternList.addAll(patterns.keySet());
        int patternCount = patternList.size();
        for (int i = 0; i < patternCount - 1; ++i) {
            String specificPattern = (String)patternList.get(i);
            for (int j = i + 1; j < patternCount; ++j) {
                String generalPattern = (String)patternList.get(j);
                this.checkPatternMatching(patterns, specificPattern, generalPattern);
                this.checkPatternMatching(patterns, generalPattern, specificPattern);
            }
        }
    }

    private void checkPatternMatching(Map<String, PatternCacheControl> patterns, String specificPattern, String generalPattern) {
        if (PatternMatcherUtils.caseInsensitiveMatch(specificPattern, generalPattern)) {
            PatternCacheControl specificPatternDirective = patterns.get(specificPattern);
            PatternCacheControl generalPatternDirective = patterns.get(generalPattern);
            generalPatternDirective.incrementMatchingPatternCount();
            ConflictResolverUtils.resolveConflicts(specificPatternDirective, generalPatternDirective);
        }
    }

    private List<PatternCacheControl> sortByMatchingPatternCount(Map<String, PatternCacheControl> unsortedMap) {
        ArrayList<PatternCacheControl> list = new ArrayList<PatternCacheControl>(unsortedMap.values());
        Collections.sort(list, PATTERN_CACHE_CONTROL_COMPARATOR);
        return list;
    }

    private File toFile(File rootDir, String location) {
        File locationFile = null;
        if (location != null) {
            URI locationURI = URI.create(location);
            locationFile = new File(locationURI.getPath());
            if (locationURI.getScheme() == null) {
                if (location.charAt(0) == '/') {
                    location = location.substring(1);
                    locationFile = new File(rootDir, location);
                }
            } else if (!"file".equals(locationURI.getScheme())) {
                throw new IllegalArgumentException("Unexpected resources directory: " + location);
            }
        }
        return locationFile;
    }

    public void start() throws Exception {
        this.serviceContext.bind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
    }

    public void stop() throws Exception {
        this.quiesce();
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
        if (this.handler != null) {
            this.handler.emptyUrlCacheControlMap();
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
        }
    }

    public void destroy() throws Exception {
    }
}

