/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.directory;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.service.http.directory.HttpDirectoryServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDirectoryService
implements Service {
    private final Logger logger = LoggerFactory.getLogger((String)"service.directory");
    private HttpDirectoryServiceHandler handler;
    private ServiceContext serviceContext;

    public String getType() {
        return "directory";
    }

    public void init(ServiceContext serviceContext) throws Exception {
        String pathSeparator;
        this.serviceContext = serviceContext;
        this.handler = new HttpDirectoryServiceHandler();
        File webDir = serviceContext.getWebDirectory();
        ServiceProperties properties = serviceContext.getProperties();
        Collection accepts = serviceContext.getAccepts();
        HashSet<URI> failedAccepts = new HashSet<URI>();
        for (URI accept : accepts) {
            String path = accept.getPath();
            if (path != null && !path.isEmpty()) continue;
            failedAccepts.add(accept);
        }
        if (!failedAccepts.isEmpty()) {
            throw new IllegalArgumentException("The following directory service accept elements are missing the URL path. You may need to add a trailing slash): " + failedAccepts);
        }
        String directory = properties.get("directory");
        if (directory == null) {
            throw new IllegalArgumentException("Missing required property: directory");
        }
        File directoryFile = this.toFile(webDir, directory);
        String welcomeFile = properties.get("welcome-file");
        if (welcomeFile != null && welcomeFile.indexOf(pathSeparator = File.pathSeparator) != -1) {
            throw new IllegalArgumentException("Unexpected character \"" + pathSeparator + "\" in welcome file: " + welcomeFile);
        }
        File errorPagesDir = this.toFile(webDir.getParentFile(), properties.get("error-pages-directory"));
        File clientAccessPolicyXml = new File(directoryFile, "/clientaccesspolicy.xml");
        if (clientAccessPolicyXml.exists()) {
            for (URI accept : accepts) {
                this.logger.warn("Ignoring user-defined file contents for {}clientaccesspolicy.xml, please modify configuration instead", (Object)accept);
            }
        }
        this.handler.setServiceContext(serviceContext);
        this.handler.setBaseDir(directoryFile);
        this.handler.setWelcomeFile(welcomeFile);
        this.handler.setErrorPagesDir(errorPagesDir);
        String indexes = properties.get("options");
        if (indexes != null && "indexes".equalsIgnoreCase(indexes)) {
            this.handler.setIndexes(true);
        }
    }

    private File toFile(File rootDir, String location) {
        File locationFile = null;
        if (location != null) {
            URI locationURI = URI.create(location);
            locationFile = new File(locationURI.getPath());
            if (locationURI.getScheme() == null) {
                if (location.charAt(0) == '/') {
                    location = location.substring(1);
                    locationFile = new File(rootDir, location);
                }
            } else if (!"file".equals(locationURI.getScheme())) {
                throw new IllegalArgumentException("Unexpected resources directory: " + location);
            }
        }
        return locationFile;
    }

    public void start() throws Exception {
        this.serviceContext.bind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
    }

    public void stop() throws Exception {
        this.quiesce();
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(this.serviceContext.getAccepts(), (IoHandler)this.handler);
        }
    }

    public void destroy() throws Exception {
    }
}

