/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.Protocol;
import org.kaazing.gateway.resource.address.URLUtils;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.http.balancer.WsebBalancerServiceHandler;
import org.kaazing.gateway.service.http.balancer.WsnBalancerServiceHandler;
import org.kaazing.gateway.transport.BridgeSessionInitializer;
import org.kaazing.gateway.transport.BridgeSessionInitializerAdapter;
import org.kaazing.gateway.transport.TransportFactory;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpAcceptor;
import org.kaazing.gateway.transport.http.HttpProtocol;
import org.kaazing.gateway.transport.sse.SseProtocol;
import org.kaazing.gateway.transport.ws.WsProtocol;
import org.kaazing.gateway.transport.wsn.WsnSession;
import org.kaazing.gateway.util.GL;
import org.kaazing.mina.core.session.IoSessionEx;

public class HttpBalancerService
implements Service {
    public static final String BALANCER_MAP_NAME = "balancerMap";
    public static final String MEMBERID_BALANCER_MAP_NAME = "memberIdBalancerMap";
    private WsebBalancerServiceHandler wsebHandler;
    private WsnBalancerServiceHandler wsnHandler;
    private ServiceContext serviceContext;
    private ClusterContext clusterContext;
    private TransportFactory transportFactory;
    private static List<String> HTTP_TRANSPORTS = Arrays.asList("https", "http", "httpxe+ssl", "httpxe");

    public String getType() {
        return "balancer";
    }

    @Resource(name="clusterContext")
    public void setConnectionCapabilities(ClusterContext clusterContext) {
        this.clusterContext = clusterContext;
    }

    @Resource(name="transportFactory")
    public void setTransportFactory(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    public void init(ServiceContext serviceContext) throws Exception {
        this.serviceContext = serviceContext;
        this.wsebHandler = new WsebBalancerServiceHandler();
        this.wsebHandler.setAccepts(serviceContext.getAccepts());
        this.wsebHandler.setClusterContext(this.clusterContext);
        this.wsnHandler = new WsnBalancerServiceHandler();
        this.wsebHandler.setTransportFactory(this.transportFactory);
        GL.info((String)"ha", (String)"Finished  HttpBalancerService.init()", (Object[])new Object[0]);
        this.clusterContext.logClusterStateAtInfoLevel();
    }

    public void start() throws Exception {
        BridgeSessionInitializerAdapter<ConnectFuture> wsBalancerSessionInitializer = new BridgeSessionInitializerAdapter<ConnectFuture>(){
            private final BridgeSessionInitializer<ConnectFuture> preUpgradeHttpSessionInitializer = new BridgeSessionInitializerAdapter<ConnectFuture>(){

                public void initializeSession(IoSession session, ConnectFuture future) {
                    List selectedBalanceeURIs;
                    HttpAcceptSession httpSession = (HttpAcceptSession)session;
                    List<String> availableBalanceeURIs = HttpBalancerService.this.wsebHandler.getBalanceeURIs(httpSession.isSecure());
                    if (availableBalanceeURIs.isEmpty()) {
                        selectedBalanceeURIs = Collections.emptyList();
                    } else {
                        String selectedBalanceeURI = availableBalanceeURIs.get((int)(Math.random() * (double)availableBalanceeURIs.size()));
                        selectedBalanceeURIs = new ArrayList(1);
                        selectedBalanceeURIs.add(selectedBalanceeURI);
                        GL.debug((String)"ha", (String)"HttpBalancerService initializeSession Selected Balancee URI: {}", (Object[])new Object[]{selectedBalanceeURI});
                    }
                    IoSessionEx parent = httpSession.getParent();
                    parent.setAttribute((Object)HttpAcceptor.BALANCEES_KEY, selectedBalanceeURIs);
                }
            };

            public void initializeSession(IoSession session, ConnectFuture future) {
                WsnSession wsnSession = (WsnSession)session;
                if (wsnSession.isBalanceSupported()) {
                    IoSessionEx parent = wsnSession.getParent();
                    List selectedBalanceeURIs = (List)parent.getAttribute((Object)HttpAcceptor.BALANCEES_KEY);
                    wsnSession.setBalanceeURIs((Collection)selectedBalanceeURIs);
                }
            }

            public BridgeSessionInitializer<ConnectFuture> getParentInitializer(Protocol protocol) {
                return HttpProtocol.HTTP.equals((Object)protocol) ? this.preUpgradeHttpSessionInitializer : null;
            }
        };
        this.serviceContext.bind(HttpBalancerService.toWsBalancerURIs(this.serviceContext.getAccepts(), this.serviceContext.getAcceptOptionsContext(), this.transportFactory), (IoHandler)this.wsnHandler, (BridgeSessionInitializer)wsBalancerSessionInitializer);
        this.serviceContext.bind(HttpBalancerService.toHttpBalancerURIs(this.serviceContext.getAccepts(), this.serviceContext.getAcceptOptionsContext(), this.transportFactory), (IoHandler)this.wsebHandler);
    }

    public void stop() throws Exception {
        this.quiesce();
        if (this.serviceContext != null) {
            for (IoSession session : this.serviceContext.getActiveSessions()) {
                session.close(true);
            }
        }
    }

    public void quiesce() throws Exception {
        if (this.serviceContext != null) {
            this.serviceContext.unbind(HttpBalancerService.toHttpBalancerURIs(this.serviceContext.getAccepts(), this.serviceContext.getAcceptOptionsContext(), this.transportFactory), (IoHandler)this.wsebHandler);
            this.serviceContext.unbind(HttpBalancerService.toWsBalancerURIs(this.serviceContext.getAccepts(), this.serviceContext.getAcceptOptionsContext(), this.transportFactory), (IoHandler)this.wsnHandler);
        }
    }

    public void destroy() throws Exception {
    }

    private static Collection<String> toWsBalancerURIs(Collection<String> uris, AcceptOptionsContext acceptOptionsCtx, TransportFactory transportFactory) throws Exception {
        ArrayList<String> httpURIs = new ArrayList<String>(uris.size());
        for (String uri : uris) {
            String schemeFromAcceptURI = uri.substring(0, uri.indexOf(58));
            Protocol protocol = transportFactory.getProtocol(schemeFromAcceptURI);
            if (!WsProtocol.WS.equals((Object)protocol) && !WsProtocol.WSS.equals((Object)protocol)) continue;
            for (String scheme : Arrays.asList("wsn", "wsx")) {
                boolean secure = protocol.isSecure();
                String wsBalancerUriScheme = secure ? scheme + "+ssl" : scheme;
                String httpAuthority = URIUtils.getAuthority((String)uri);
                String httpPath = URIUtils.getPath((String)uri);
                String httpQuery = URIUtils.getQuery((String)uri);
                httpURIs.add(URIUtils.buildURIAsString((String)wsBalancerUriScheme, (String)httpAuthority, (String)httpPath, (String)httpQuery, null));
                String internalURI = acceptOptionsCtx.getInternalURI(uri);
                if (internalURI == null || internalURI.equals(uri)) continue;
                String authority = URIUtils.getAuthority((String)internalURI);
                acceptOptionsCtx.addBind(wsBalancerUriScheme, authority);
            }
        }
        return httpURIs;
    }

    private static Collection<String> toHttpBalancerURIs(Collection<String> uris, AcceptOptionsContext acceptOptionsCtx, TransportFactory transportFactory) throws Exception {
        ArrayList<String> httpURIs = new ArrayList<String>(uris.size());
        for (String uri : uris) {
            Protocol protocol = transportFactory.getProtocol(URIUtils.getScheme((String)uri));
            boolean secure = protocol.isSecure();
            for (int i = 0; i < HTTP_TRANSPORTS.size(); i += 2) {
                String httpScheme = secure ? HTTP_TRANSPORTS.get(i) : HTTP_TRANSPORTS.get(i + 1);
                String httpAuthority = URIUtils.getAuthority((String)uri);
                String httpPath = URIUtils.getPath((String)uri);
                String httpQuery = URIUtils.getQuery((String)uri);
                if (WsProtocol.WS.equals((Object)protocol) || WsProtocol.WSS.equals((Object)protocol)) {
                    httpURIs.add(URIUtils.buildURIAsString((String)httpScheme, (String)httpAuthority, (String)URLUtils.replaceMultipleSlashesWithSingleSlash((String)(httpPath + "/;e")), (String)httpQuery, null));
                    String internalURI = acceptOptionsCtx.getInternalURI(uri);
                    if (internalURI == null || internalURI.equals(uri)) continue;
                    String authority = URIUtils.getAuthority((String)internalURI);
                    acceptOptionsCtx.addBind(httpScheme, authority);
                    continue;
                }
                if (SseProtocol.SSE.equals((Object)protocol) || SseProtocol.SSE_SSL.equals((Object)protocol) || HttpProtocol.HTTP.equals((Object)protocol) || HttpProtocol.HTTPS.equals((Object)protocol)) {
                    httpURIs.add(URIUtils.buildURIAsString((String)httpScheme, (String)httpAuthority, (String)httpPath, (String)httpQuery, null));
                    continue;
                }
                throw new IllegalArgumentException("Invalid protocol in the balancer: " + uri);
            }
        }
        return httpURIs;
    }
}

