/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.http.balancer;

import com.hazelcast.core.IMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.kaazing.gateway.resource.address.Protocol;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.messaging.collections.CollectionsFactory;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.TransportFactory;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.util.GL;

class WsebBalancerServiceHandler
extends IoHandlerAdapter<HttpAcceptSession> {
    private Collection<URI> accepts;
    private ClusterContext clusterContext;
    private TransportFactory transportFactory;

    WsebBalancerServiceHandler() {
    }

    Collection<URI> getAccepts() {
        return this.accepts;
    }

    void setAccepts(Collection<URI> accepts) {
        this.accepts = new ArrayList<URI>(accepts);
    }

    ClusterContext getClusterContext() {
        return this.clusterContext;
    }

    void setClusterContext(ClusterContext clusterContext) {
        this.clusterContext = clusterContext;
    }

    public void setTransportFactory(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    protected void doExceptionCaught(HttpAcceptSession session, Throwable cause) throws Exception {
        session.close(true);
    }

    protected void doSessionOpened(HttpAcceptSession session) throws Exception {
        List<URI> availableBalanceeURIs = this.getBalanceeURIs(session.isSecure());
        if (availableBalanceeURIs.isEmpty()) {
            GL.warn((String)"ha", (String)"Rejected {} request for URI \"{}\" on session {}: no available balancee URI was found", (Object[])new Object[]{session.getMethod(), session.getRequestURI(), session});
            session.setStatus(HttpStatus.CLIENT_NOT_FOUND);
        } else {
            int emIndex;
            URI selectedBalanceeURI = availableBalanceeURIs.get((int)(Math.random() * (double)availableBalanceeURIs.size()));
            GL.debug((String)"ha", (String)"WsebBalancerServiceHandler doSessionOpen Selected Balancee URI: {}", (Object[])new Object[]{selectedBalanceeURI});
            URI requestURI = session.getRequestURI();
            String balanceeScheme = selectedBalanceeURI.getScheme();
            balanceeScheme = balanceeScheme.equals("sse") ? "http" : (balanceeScheme.equals("sse+ssl") ? "https" : selectedBalanceeURI.getScheme().replaceFirst("^ws", "http"));
            String balanceePath = selectedBalanceeURI.getPath();
            String requestPath = requestURI.getPath();
            int n = emIndex = requestPath != null ? requestPath.indexOf("/;e") : -1;
            if (emIndex != -1 && !requestPath.contains("/;e/cookies")) {
                balanceePath = balanceePath + requestPath.substring(emIndex);
            }
            String balanceeQuery = requestURI.getQuery();
            selectedBalanceeURI = new URI(balanceeScheme, selectedBalanceeURI.getAuthority(), balanceePath, balanceeQuery, null);
            session.setStatus(HttpStatus.REDIRECT_FOUND);
            session.setWriteHeader("Location", selectedBalanceeURI.toString());
        }
        session.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<URI> getBalanceeURIs(boolean secure) {
        ArrayList<URI> balanceeURIs = new ArrayList<URI>();
        CollectionsFactory collectionsFactory = null;
        if (this.clusterContext != null) {
            collectionsFactory = this.clusterContext.getCollectionsFactory();
        }
        if (this.accepts != null && collectionsFactory != null) {
            Lock mapLock = this.getLock("balancerMap");
            try {
                mapLock.lock();
                IMap balancers = collectionsFactory.getMap("balancerMap");
                for (URI balancerAccept : this.accepts) {
                    Collection balanceesForAccept = (Collection)balancers.get(balancerAccept);
                    GL.debug((String)"ha", (String)String.format("Found balancee URIs %s for accept URI %s", balanceesForAccept, balancerAccept), (Object[])new Object[0]);
                    if (balanceesForAccept == null) continue;
                    for (URI balanceeURI : balanceesForAccept) {
                        Protocol protocol = this.transportFactory.getProtocol(balanceeURI);
                        if (secure != protocol.isSecure()) continue;
                        balanceeURIs.add(balanceeURI);
                    }
                }
            }
            finally {
                mapLock.unlock();
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Returning empty balancee URIs list: ");
            if (this.accepts == null) {
                sb.append("accepts are null, ");
            }
            if (this.clusterContext.getCollectionsFactory() == null) {
                sb.append("cluster context collections factory is null");
            }
            GL.debug((String)"CLUSTER_LOGGER_NAME", (String)sb.toString(), (Object[])new Object[0]);
        }
        GL.debug((String)"ha", (String)"Exit WsebBalancerService.getBalanceeURIs", (Object[])new Object[0]);
        this.clusterContext.logClusterState();
        return balanceeURIs;
    }

    public Lock getLock(Object obj) {
        return this.clusterContext.getLock(obj);
    }
}

