/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.broadcast;

import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Collections;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.util.ConcurrentHashSet;
import org.kaazing.gateway.service.broadcast.BroadcastListenHandler;
import org.kaazing.gateway.service.broadcast.BroadcastService;
import org.kaazing.gateway.transport.LoggingUtils;
import org.kaazing.gateway.transport.io.filter.IoMessageCodecFilter;
import org.slf4j.Logger;

class BroadcastServiceHandler
extends IoHandlerAdapter {
    private final IoFilter codec;
    private final Collection<IoSession> clients;
    private final IoHandler handler;
    private final Logger logger;
    private IoSession connectSession;
    private final BroadcastService.OnClientMessage onClientMessage;

    BroadcastServiceHandler(boolean disconnectClientsOnReconnect, long maximumScheduledWriteBytes, BroadcastService.OnClientMessage onClientMessage, Logger logger) throws Exception {
        this.onClientMessage = onClientMessage;
        this.clients = new ConcurrentHashSet();
        this.handler = new BroadcastListenHandler(Collections.unmodifiableCollection(this.clients), disconnectClientsOnReconnect, maximumScheduledWriteBytes, logger);
        this.codec = new IoMessageCodecFilter();
        this.logger = logger;
    }

    IoSession getConnectSession() {
        return this.connectSession;
    }

    void setConnectSession(IoSession connectSession) {
        this.connectSession = connectSession;
    }

    IoHandler getListenHandler() {
        return this.handler;
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (this.onClientMessage == BroadcastService.OnClientMessage.BROADCAST) {
            this.handler.messageReceived(session, message);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (session.isClosing() && cause instanceof ClosedChannelException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("BroadcastServiceHandler: caught exception %s, probably because session was closed with pending writes", cause));
            }
        } else {
            LoggingUtils.log((IoSession)session, (Logger)this.logger, (String)"Unexpected exception in broadcast service handler", (Throwable)cause);
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        session.getFilterChain().addLast("io", this.codec);
        this.clients.add(session);
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("BroadcastServiceHandler: session closed on %s", session.toString()));
        }
        this.clients.remove(session);
    }
}

