/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.broadcast;

import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Collections;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.util.ConcurrentHashSet;
import org.kaazing.gateway.service.broadcast.BroadcastListenHandler;
import org.kaazing.gateway.transport.io.filter.IoMessageCodecFilter;
import org.slf4j.Logger;

class BroadcastServiceHandler
extends IoHandlerAdapter {
    private final IoFilter codec;
    private final Collection<IoSession> clients = new ConcurrentHashSet();
    private final IoHandler handler;
    private final Logger logger;
    private IoSession connectSession;

    BroadcastServiceHandler(boolean disconnectClientsOnReconnect, long maximumScheduledWriteBytes, Logger logger) throws Exception {
        this.handler = new BroadcastListenHandler(Collections.unmodifiableCollection(this.clients), disconnectClientsOnReconnect, maximumScheduledWriteBytes, logger);
        this.codec = new IoMessageCodecFilter();
        this.logger = logger;
    }

    IoSession getConnectSession() {
        return this.connectSession;
    }

    void setConnectSession(IoSession connectSession) {
        this.connectSession = connectSession;
    }

    IoHandler getListenHandler() {
        return this.handler;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (session.isClosing() && cause instanceof ClosedChannelException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("BroadcastServiceHandler: caught exception %s, probably because session was closed with pending writes", cause));
            }
        } else {
            this.logger.warn("Unexpected exception in broadcast service handler", cause);
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        session.getFilterChain().addLast("io", this.codec);
        this.clients.add(session);
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("BroadcastServiceHandler: session closed on %s", session.toString()));
        }
        this.clients.remove(session);
    }
}

