/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.service.broadcast;

import java.util.Collection;
import java.util.Iterator;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.bridge.Message;
import org.kaazing.gateway.transport.io.filter.IoMessageCodecFilter;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

public class BroadcastListenHandler
extends IoHandlerAdapter {
    private final Collection<IoSession> clients;
    private final IoMessageCodecFilter codec;
    private final boolean disconnectClientsOnReconnect;
    private final long maximumScheduledWriteBytes;
    private final Logger logger;

    public BroadcastListenHandler(Collection<IoSession> clients, boolean disconnectClientsOnReconnect, long maximumScheduledWriteBytes, Logger logger) {
        this.clients = clients;
        this.codec = new IoMessageCodecFilter();
        this.disconnectClientsOnReconnect = disconnectClientsOnReconnect;
        this.logger = logger;
        this.maximumScheduledWriteBytes = maximumScheduledWriteBytes;
    }

    public void sessionOpened(IoSession session) throws Exception {
        session.getFilterChain().addLast("io", (IoFilter)this.codec);
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (this.disconnectClientsOnReconnect) {
            Iterator<IoSession> clientsIterator = this.clients.iterator();
            while (clientsIterator.hasNext()) {
                clientsIterator.next().close(false);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message instanceof IoBuffer) {
            IoBuffer buf = (IoBuffer)message;
            for (IoSession client : this.clients) {
                this.writeOrClose(client, buf);
            }
            buf.skip(buf.remaining());
        } else {
            if (message instanceof Message) {
                ((Message)message).initCache();
            }
            for (IoSession client : this.clients) {
                this.writeOrClose(client, message);
            }
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(cause.getMessage(), cause);
        } else {
            this.logger.warn(cause.getMessage());
        }
    }

    private void writeOrClose(IoSession client, Object message) {
        long scheduledWriteBytes = this.getScheduledWriteBytes(client);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("BroadcastListenHandler: session %d: scheduledWriteBytes = %d", client.getId(), scheduledWriteBytes));
        }
        if (!client.isClosing()) {
            if (scheduledWriteBytes > this.maximumScheduledWriteBytes) {
                if (this.logger.isInfoEnabled()) {
                    String logMessage = String.format("Closing client session %s because scheduled write bytes %d exceeds the configured limit of %d", client, scheduledWriteBytes, this.maximumScheduledWriteBytes);
                    this.logger.info(logMessage);
                }
                client.close(true);
            } else {
                client.write(message);
            }
        }
    }

    private long getScheduledWriteBytes(IoSession client) {
        IoSession session = client;
        while (session instanceof BridgeSession) {
            IoSessionEx parent = ((BridgeSession)session).getParent();
            if (parent == null) {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(String.format("Null parent on session %s, ancestor of client session %s", session, client));
                break;
            }
            session = parent;
        }
        return session.getScheduledWriteBytes();
    }
}

