/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.kaazing.gateway.security.auth.GrantPrincipal;

public class GrantLoginModule
implements LoginModule {
    private Principal principal;
    private Subject subject;
    private String name;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.name = (String)options.get("name");
    }

    @Override
    public boolean login() throws LoginException {
        this.principal = new GrantPrincipal(this.name);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(this.principal);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        return true;
    }
}

