/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.auth.BaseStateDrivenLoginModule;
import org.kaazing.gateway.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutLoginModule
extends BaseStateDrivenLoginModule {
    public static final String CLASS_NAME = TimeoutLoginModule.class.getName();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String INITIALIZATION_FAILED_MESSAGE = "[TimeoutLoginModule] Initialization failed";
    private static final String AUTHENTICATION_FAILED_MESSAGE = "[TimeoutLoginModule] Authentication failed";
    private static final String SESSION_TIMEOUT_KEY = "session-timeout";
    private boolean debug;
    private Long sessionTimeout;
    private boolean forceFailure;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.forceFailure = "true".equalsIgnoreCase((String)options.get("force-failure"));
        this.sessionTimeout = this.readOption(options, SESSION_TIMEOUT_KEY);
        if (this.sessionTimeout == null) {
            IllegalArgumentException iae = new IllegalArgumentException(String.format("You must specify the \"%s\" option", SESSION_TIMEOUT_KEY));
            if (this.debug) {
                LOGGER.debug(INITIALIZATION_FAILED_MESSAGE, (Throwable)iae);
            }
            throw iae;
        }
        if (this.debug) {
            LOGGER.debug("[TimeoutLoginModule] session timeout configured as '{}'", (Object)this.sessionTimeout);
        }
    }

    @Override
    protected boolean doLogin() throws LoginException {
        if (this.loginResult == null) {
            LoginException le = new LoginException("Missing login result");
            if (this.debug) {
                LOGGER.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)le);
            }
            throw le;
        }
        boolean performedAction = false;
        if (this.sessionTimeout != null) {
            if (this.debug) {
                LOGGER.debug("[TimeoutLoginModule] Setting session timeout to '{}'", (Object)this.sessionTimeout);
            }
            this.loginResult.setSessionTimeout(this.sessionTimeout.longValue());
            performedAction = true;
        }
        if (!performedAction || this.forceFailure) {
            LoginException le = new LoginException("Unable to set timeout");
            if (this.debug) {
                LOGGER.debug(AUTHENTICATION_FAILED_MESSAGE, (Throwable)le);
            }
            this.cleanState();
            throw le;
        }
        return false;
    }

    @Override
    protected boolean doCommit() throws LoginException {
        return true;
    }

    @Override
    protected boolean doLogout() throws LoginException {
        this.cleanState();
        return true;
    }

    private Long readOption(Map<String, ?> options, String key) {
        String timeIntervalValue = (String)options.get(key);
        if (timeIntervalValue == null) {
            return null;
        }
        try {
            return Utils.parseTimeInterval((String)timeIntervalValue, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (NumberFormatException e) {
            LOGGER.error("[TimeoutLoginModule] Cannot determine the value for {}", (Object)key, (Object)e);
            throw e;
        }
    }

    private void cleanState() {
        this.sessionTimeout = 0L;
    }
}

