/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.auth.BaseStateDrivenLoginModule;
import org.kaazing.gateway.security.auth.DispatchCallbackHandler;
import org.kaazing.gateway.security.auth.NameCallbackHandler;
import org.kaazing.gateway.security.auth.PasswordCallbackHandler;
import org.kaazing.gateway.server.spi.security.AuthenticationToken;
import org.kaazing.gateway.server.spi.security.AuthenticationTokenCallback;
import org.kaazing.gateway.util.Encoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLoginModule
extends BaseStateDrivenLoginModule {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String CLASS_NAME = BasicLoginModule.class.getName();
    public static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String KAAZING_TOKEN_KEY = "org.kaazing.gateway.server.auth.token";
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";
    private boolean debug;
    private boolean tryFirstToken;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.tryFirstToken = "true".equalsIgnoreCase((String)options.get("tryFirstToken"));
    }

    @Override
    protected boolean doLogin() throws LoginException {
        block9: {
            if (!this.authenticationSchemeIsBasic()) {
                throw new LoginException("Only able to handle Basic authentication scheme");
            }
            if (this.loginResult == null) {
                LoginException le = new LoginException("Missing login result");
                if (this.debug) {
                    LOG.debug("[BasicLoginModule] Unable to perform authentication", (Throwable)le);
                }
                throw le;
            }
            this.loginResult.challenge(new Object[0]);
            if (this.tryFirstToken) {
                try {
                    this.attemptAuthenticate(true);
                    return true;
                }
                catch (LoginException le) {
                    if (!this.debug) break block9;
                    LOG.debug("[BasicLoginModule] reading from shared state failed: ", (Throwable)le);
                }
            }
        }
        try {
            this.attemptAuthenticate(false);
            return true;
        }
        catch (LoginException loginException) {
            this.cleanState();
            if (this.debug) {
                LOG.debug("[BasicLoginModule] regular authentication failed: ", (Throwable)loginException);
            }
            throw loginException;
        }
    }

    private boolean authenticationSchemeIsBasic() throws LoginException {
        AuthenticationTokenCallback authenticationTokenCallback = new AuthenticationTokenCallback();
        try {
            this.handler.handle(new Callback[]{authenticationTokenCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            if (this.debug) {
                LOG.debug("Unable to handle AuthenticationTokenCallback.", (Throwable)e);
            }
            throw this.wrapInLoginException(e);
        }
        return authenticationTokenCallback.getAuthenticationToken() != null && authenticationTokenCallback.getAuthenticationToken().getScheme() != null && authenticationTokenCallback.getAuthenticationToken().getScheme().equalsIgnoreCase("Basic");
    }

    private void attemptAuthenticate(boolean useSharedState) throws LoginException {
        try {
            String basicAuthToken = this.getBasicAuthToken(useSharedState);
            if (basicAuthToken == null) {
                throw new LoginException("No HTTP Basic Authentication Token found.");
            }
            if (basicAuthToken.startsWith("Basic ")) {
                basicAuthToken = basicAuthToken.substring("Basic ".length());
            }
            ByteBuffer credentialsBuf = Encoding.BASE64.decode(ByteBuffer.wrap(basicAuthToken.getBytes(UTF8)));
            byte[] credentialsBytes = new byte[credentialsBuf.remaining()];
            credentialsBuf.get(credentialsBytes);
            String credentials = new String(credentialsBytes, UTF8);
            int colonAt = credentials.indexOf(58);
            if (colonAt == -1) {
                throw new LoginException("Syntax error while decoding HTTP Basic Authentication token.");
            }
            String username = credentials.substring(0, colonAt);
            char[] password = credentials.substring(colonAt + 1).toCharArray();
            this.sharedState.put(NAME, username);
            this.sharedState.put(PWD, password);
            ((DispatchCallbackHandler)this.handler).register(NameCallback.class, new NameCallbackHandler(username));
            ((DispatchCallbackHandler)this.handler).register(PasswordCallback.class, new PasswordCallbackHandler(password));
        }
        catch (Exception e) {
            if (this.debug) {
                LOG.debug("Exception decoding HTTP Basic Authentication token", (Throwable)e);
            }
            this.cleanState();
            throw this.wrapInLoginException(e);
        }
    }

    private String getBasicAuthToken(boolean useSharedState) throws LoginException {
        if (useSharedState) {
            return (String)this.sharedState.get(KAAZING_TOKEN_KEY);
        }
        AuthenticationTokenCallback authenticationTokenCallback = new AuthenticationTokenCallback();
        try {
            this.handler.handle(new Callback[]{authenticationTokenCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            if (this.debug) {
                LOG.debug("Unable to handle AuthenticationTokenCallback.", (Throwable)e);
            }
            throw this.wrapInLoginException(e);
        }
        AuthenticationToken authToken = authenticationTokenCallback.getAuthenticationToken();
        if (authToken != null) {
            return authToken.get();
        }
        return null;
    }

    private void cleanState() {
        this.sharedState.remove(NAME);
        this.sharedState.remove(PWD);
        ((DispatchCallbackHandler)this.handler).unregister(NameCallback.class);
        ((DispatchCallbackHandler)this.handler).unregister(PasswordCallback.class);
    }

    @Override
    protected boolean doCommit() throws LoginException {
        return true;
    }

    @Override
    protected boolean doLogout() throws LoginException {
        this.cleanState();
        return true;
    }

    private LoginException wrapInLoginException(Exception e) {
        return (LoginException)new LoginException(e.getMessage()).initCause(e);
    }
}

