/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth.config.parse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kaazing.gateway.security.auth.config.JaasConfig;
import org.kaazing.gateway.security.auth.config.parse.DefaultJaasConfig;
import org.kaazing.gateway.security.auth.config.parse.DefaultRoleConfig;
import org.kaazing.gateway.security.auth.config.parse.DefaultUserConfig;
import org.kaazing.gateway.util.parse.ConfigParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JaasConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaasConfigParser.class);

    public JaasConfig parse(URL resource) throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        JaasConfig result = this.parse0(resource, new JaasConfigHandler(errors));
        if (!errors.isEmpty()) {
            throw new ParserConfigurationException((String)errors.get(0));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaasConfig parse0(URL resource, JaasConfigHandler handler) throws IOException, ParserConfigurationException, SAXException {
        try (InputStream in = resource.openStream();){
            JaasConfig jaasConfig = this.parse0(in, handler);
            return jaasConfig;
        }
    }

    private JaasConfig parse0(InputStream in, JaasConfigHandler handler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        return handler.getAuthConfig();
    }

    private static class JaasConfigHandler
    extends DefaultHandler {
        private static final String NAMESPACE_URI = "http://xmlns.kaazing.com/jaas-config/centurion";
        private static final String BATTLESTAR_URI = "http://xmlns.kaazing.org/jaas-config/battlestar";
        private static final String ATLANTIS_URI = "http://xmlns.kaazing.org/jaas-config/atlantis";
        private static final String JAAS_CONFIG_ELEMENT = "jaas-config";
        private static final String USER_ELEMENT = "user";
        private static final String ROLE_ELEMENT = "role";
        private static final String NAME_ELEMENT = "name";
        private static final String PASSWORD_ELEMENT = "password";
        private static final String DESCRIPTION_ELEMENT = "description";
        private static final String ROLE_NAME_ELEMENT = "role-name";
        private static final Properties EMPTY_PROPERTIES = new Properties();
        private static List<String> errors = new ArrayList<String>();
        private final File configFile;
        private HandlerState handlerState;
        private Deque<Object> handlerStack = new ArrayDeque<Object>(4);
        private DefaultJaasConfig authConfig;

        public JaasConfigHandler(List<String> errors) {
            this(null, errors);
        }

        public JaasConfigHandler(File configFile, List<String> errors) {
            this.configFile = configFile;
        }

        public JaasConfig getAuthConfig() {
            return this.authConfig;
        }

        @Override
        public void startDocument() throws SAXException {
            this.handlerState = HandlerState.DOCUMENT;
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.handlerState != HandlerState.DOCUMENT) {
                throw new SAXException("Invalid handler state: " + (Object)((Object)this.handlerState));
            }
            if (!this.handlerStack.isEmpty()) {
                throw new SAXException("Handler stack not empty: " + this.handlerStack);
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (NAMESPACE_URI.equals(uri)) {
                switch (this.handlerState) {
                    case DOCUMENT: {
                        if (!JAAS_CONFIG_ELEMENT.equals(name)) break;
                        this.handlerStack.push(new DefaultJaasConfig());
                        this.handlerState = HandlerState.JAAS_CONFIG;
                        return;
                    }
                    case JAAS_CONFIG: {
                        if (USER_ELEMENT.equals(name)) {
                            this.handlerStack.push(new DefaultUserConfig());
                            this.handlerState = HandlerState.USER;
                            return;
                        }
                        if (!ROLE_ELEMENT.equals(name)) break;
                        this.handlerStack.push(new DefaultRoleConfig());
                        this.handlerState = HandlerState.ROLE;
                        return;
                    }
                    case USER: {
                        if (NAME_ELEMENT.equals(name)) {
                            this.handlerStack.push(new StringBuilder());
                            this.handlerState = HandlerState.USER_NAME;
                            return;
                        }
                        if (PASSWORD_ELEMENT.equals(name)) {
                            this.handlerStack.push(new StringBuilder());
                            this.handlerState = HandlerState.USER_PASSWORD;
                            return;
                        }
                        if (!ROLE_NAME_ELEMENT.equals(name)) break;
                        this.handlerStack.push(new StringBuilder());
                        this.handlerState = HandlerState.USER_ROLE_NAME;
                        return;
                    }
                    case ROLE: {
                        if (NAME_ELEMENT.equals(name)) {
                            this.handlerStack.push(new StringBuilder());
                            this.handlerState = HandlerState.ROLE_NAME;
                            return;
                        }
                        if (DESCRIPTION_ELEMENT.equals(name)) {
                            this.handlerStack.push(new StringBuilder());
                            this.handlerState = HandlerState.ROLE_DESCRIPTION;
                            return;
                        }
                        if (!ROLE_NAME_ELEMENT.equals(name)) break;
                        this.handlerStack.push(new StringBuilder());
                        this.handlerState = HandlerState.ROLE_ROLE_NAME;
                        return;
                    }
                }
            } else if (ATLANTIS_URI.equals(uri) || BATTLESTAR_URI.equals(uri)) {
                if (this.configFile != null) {
                    LOGGER.error("Update your configuration namespace in the file \"" + this.configFile.getAbsolutePath() + "\" to use \"" + NAMESPACE_URI + "\"");
                } else {
                    LOGGER.error("Update your configuration namespace to use \"http://xmlns.kaazing.com/jaas-config/centurion\"");
                }
            }
            throw new SAXException("Unexpected element: {" + uri + "} " + name);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.handlerState) {
                case DOCUMENT: 
                case JAAS_CONFIG: 
                case USER: 
                case ROLE: {
                    break;
                }
                case USER_NAME: 
                case USER_PASSWORD: 
                case USER_ROLE_NAME: 
                case ROLE_NAME: 
                case ROLE_DESCRIPTION: 
                case ROLE_ROLE_NAME: {
                    String string = new StringBuilder().append(ch, start, length).toString();
                    string = ConfigParameter.resolveAndReplace((char[])ch, (int)start, (int)length, Collections.emptyMap(), (Properties)EMPTY_PROPERTIES, errors);
                    StringBuilder sb = (StringBuilder)this.handlerStack.peek();
                    sb.append(string);
                    break;
                }
                default: {
                    throw new SAXException("Unexpected handler state: " + (Object)((Object)this.handlerState));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.handlerState) {
                case JAAS_CONFIG: {
                    this.authConfig = (DefaultJaasConfig)this.handlerStack.pop();
                    this.handlerState = HandlerState.DOCUMENT;
                    break;
                }
                case USER: {
                    DefaultUserConfig userConfig = (DefaultUserConfig)this.handlerStack.pop();
                    DefaultJaasConfig authConfig = (DefaultJaasConfig)this.handlerStack.peek();
                    authConfig.getUsers().put(userConfig.getName(), userConfig);
                    this.handlerState = HandlerState.JAAS_CONFIG;
                    break;
                }
                case USER_NAME: {
                    StringBuilder sb = (StringBuilder)this.handlerStack.pop();
                    DefaultUserConfig userConfig = (DefaultUserConfig)this.handlerStack.peek();
                    userConfig.setName(sb.toString());
                    this.handlerState = HandlerState.USER;
                    break;
                }
                case USER_PASSWORD: {
                    StringBuilder sb = (StringBuilder)this.handlerStack.pop();
                    DefaultUserConfig userConfig = (DefaultUserConfig)this.handlerStack.peek();
                    userConfig.setPassword(sb.toString());
                    this.handlerState = HandlerState.USER;
                    break;
                }
                case USER_ROLE_NAME: {
                    StringBuilder sb = (StringBuilder)this.handlerStack.pop();
                    DefaultUserConfig userConfig = (DefaultUserConfig)this.handlerStack.peek();
                    userConfig.getRoleNames().add(sb.toString());
                    this.handlerState = HandlerState.USER;
                    break;
                }
                case ROLE: {
                    DefaultRoleConfig roleConfig = (DefaultRoleConfig)this.handlerStack.pop();
                    DefaultJaasConfig authConfig = (DefaultJaasConfig)this.handlerStack.peek();
                    authConfig.getRoles().put(roleConfig.getName(), roleConfig);
                    this.handlerState = HandlerState.JAAS_CONFIG;
                    break;
                }
                case ROLE_NAME: {
                    StringBuilder sb = (StringBuilder)this.handlerStack.pop();
                    DefaultRoleConfig roleConfig = (DefaultRoleConfig)this.handlerStack.peek();
                    roleConfig.setName(sb.toString());
                    this.handlerState = HandlerState.ROLE;
                    break;
                }
                case ROLE_DESCRIPTION: {
                    StringBuilder sb = (StringBuilder)this.handlerStack.pop();
                    DefaultRoleConfig roleConfig = (DefaultRoleConfig)this.handlerStack.peek();
                    roleConfig.setDescription(sb.toString());
                    this.handlerState = HandlerState.ROLE;
                    break;
                }
                case ROLE_ROLE_NAME: {
                    StringBuilder sb = (StringBuilder)this.handlerStack.pop();
                    DefaultRoleConfig roleConfig = (DefaultRoleConfig)this.handlerStack.peek();
                    roleConfig.getRoleNames().add(sb.toString());
                    this.handlerState = HandlerState.ROLE;
                    break;
                }
            }
        }
    }

    private static enum HandlerState {
        DOCUMENT,
        JAAS_CONFIG,
        USER,
        USER_NAME,
        USER_PASSWORD,
        USER_ROLE_NAME,
        ROLE,
        ROLE_NAME,
        ROLE_DESCRIPTION,
        ROLE_ROLE_NAME;

    }
}

