/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.auth.BaseStateDrivenLoginModule;

public class YesLoginModule
extends BaseStateDrivenLoginModule {
    private List<String> roles = new ArrayList<String>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.resolveRoles(options);
    }

    private void resolveRoles(Map<String, ?> options) {
        String roleString = (String)options.get("roles");
        if (roleString != null && null != this.roles) {
            String[] roleNames = roleString.split(",");
            for (int i = 0; i < roleNames.length; ++i) {
                if (roleNames[i] == null) continue;
                roleNames[i] = roleNames[i].trim();
            }
            this.roles = Arrays.asList(roleNames);
        }
    }

    @Override
    protected boolean doLogin() throws LoginException {
        return true;
    }

    @Override
    protected boolean doCommit() throws LoginException {
        if (this.roles != null) {
            Iterator<String> iterator = this.roles.iterator();
            while (iterator.hasNext()) {
                String role;
                final String role0 = role = iterator.next();
                this.subject.getPrincipals().add(new Principal(){

                    @Override
                    public String getName() {
                        return role0;
                    }
                });
            }
        }
        return true;
    }

    @Override
    protected boolean doLogout() throws LoginException {
        return true;
    }
}

