/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.security.auth;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.kaazing.gateway.security.auth.BaseStateDrivenLoginModule;
import org.kaazing.gateway.server.spi.security.AuthenticationTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NegotiateLoginModule
extends BaseStateDrivenLoginModule {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String CLASS_NAME = NegotiateLoginModule.class.getName();
    public static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String KAAZING_TOKEN_KEY = "org.kaazing.gateway.server.auth.token";
    private static final String KAAZING_GSS_TOKEN_KEY = "org.kaazing.gateway.server.auth.gss.token";
    private boolean debug;
    private boolean tryFirstToken;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.tryFirstToken = "true".equalsIgnoreCase((String)options.get("tryFirstToken"));
    }

    @Override
    protected boolean doLogin() throws LoginException {
        block7: {
            if (!this.authenticationSchemeIsNegotiate()) {
                return true;
            }
            if (this.tryFirstToken) {
                try {
                    this.attemptAuthenticate(true);
                    return true;
                }
                catch (Exception le) {
                    if (!this.debug) break block7;
                    LOG.debug("[NegotiateLoginModule] reading from shared state failed: " + le.getMessage());
                }
            }
        }
        try {
            this.attemptAuthenticate(false);
            return true;
        }
        catch (Exception loginException) {
            if (this.debug) {
                LOG.debug("[NegotiateLoginModule] regular authentication failed: " + loginException.getMessage());
            }
            return false;
        }
    }

    private void attemptAuthenticate(boolean useSharedState) throws LoginException {
        try {
            String negotiateAuthToken = this.getNegotiateAuthToken(useSharedState);
            if (negotiateAuthToken == null) {
                throw new LoginException("No HTTP Negotiate Authentication Token found.");
            }
            if (negotiateAuthToken.startsWith("Negotiate ")) {
                negotiateAuthToken = negotiateAuthToken.substring("Negotiate ".length());
            }
        }
        catch (Throwable e) {
            if (this.debug) {
                LOG.debug("Exception decoding HTTP Basic Authentication token", e);
            }
            throw (LoginException)new LoginException().initCause(e);
        }
    }

    private boolean authenticationSchemeIsNegotiate() throws LoginException {
        AuthenticationTokenCallback authenticationTokenCallback = new AuthenticationTokenCallback();
        try {
            this.handler.handle(new Callback[]{authenticationTokenCallback});
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encountered exception handling authenticationTokenCallback.", (Throwable)e);
            }
            return false;
        }
        catch (UnsupportedCallbackException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("UnsupportedCallbackException handling authenticationTokenCallback.");
            }
            return false;
        }
        return authenticationTokenCallback.getAuthenticationToken() != null && authenticationTokenCallback.getAuthenticationToken().getScheme() != null && authenticationTokenCallback.getAuthenticationToken().getScheme().equalsIgnoreCase("Negotiate");
    }

    private String getNegotiateAuthToken(boolean useSharedState) {
        if (useSharedState) {
            return (String)this.sharedState.get(KAAZING_TOKEN_KEY);
        }
        AuthenticationTokenCallback authenticationTokenCallback = new AuthenticationTokenCallback();
        try {
            this.handler.handle(new Callback[]{authenticationTokenCallback});
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encountered exception handling authenticationTokenCallback.", (Throwable)e);
            }
            return null;
        }
        catch (UnsupportedCallbackException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("UnsupportedCallbackException handling authenticationTokenCallback.");
            }
            return null;
        }
        return authenticationTokenCallback.getAuthenticationToken().get();
    }

    @Override
    protected boolean doCommit() throws LoginException {
        return true;
    }

    @Override
    protected boolean doLogout() throws LoginException {
        return true;
    }
}

