/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.uri.URIUtils;

public class ResourceAddressFactory {
    private final Map<String, ResourceAddressFactorySpi<?>> addressFactories;
    private final Map<String, Map<String, ResourceAddressFactorySpi<?>>> alternateAddressFactories;

    public static ResourceAddressFactory newResourceAddressFactory() {
        return ResourceAddressFactory.newResourceAddressFactory(Thread.currentThread().getContextClassLoader());
    }

    public static ResourceAddressFactory newResourceAddressFactory(ClassLoader classLoader) {
        String schemeName;
        ServiceLoader<ResourceAddressFactorySpi> loader = ResourceAddressFactory.loadResourceAddressFactorySpi(classLoader);
        HashMap<String, ResourceAddressFactorySpi<?>> addressFactories = new HashMap<String, ResourceAddressFactorySpi>();
        HashMap<String, Map<String, ResourceAddressFactorySpi<?>>> alternateAddressFactories = new HashMap();
        for (ResourceAddressFactorySpi resourceAddressFactorySpi : loader) {
            schemeName = resourceAddressFactorySpi.getSchemeName();
            ResourceAddressFactorySpi oldResourceAddressFactorySpi = addressFactories.put(schemeName, resourceAddressFactorySpi);
            if (oldResourceAddressFactorySpi != null) {
                throw new RuntimeException(String.format("Duplicate scheme resource address factory: %s", schemeName));
            }
            String alternateToScheme = resourceAddressFactorySpi.getRootSchemeName();
            if (alternateToScheme == null) continue;
            HashMap<String, ResourceAddressFactorySpi> alternates = (HashMap<String, ResourceAddressFactorySpi>)alternateAddressFactories.get(alternateToScheme);
            if (alternates == null) {
                alternates = new HashMap<String, ResourceAddressFactorySpi>();
                alternateAddressFactories.put(alternateToScheme, alternates);
            }
            alternates.put(schemeName, resourceAddressFactorySpi);
        }
        for (Map.Entry entry : alternateAddressFactories.entrySet()) {
            schemeName = (String)entry.getKey();
            Map alternates = (Map)entry.getValue();
            alternates = alternates == null ? Collections.emptyMap() : Collections.unmodifiableMap(alternates);
            alternateAddressFactories.put(schemeName, alternates);
        }
        addressFactories = Collections.unmodifiableMap(addressFactories);
        alternateAddressFactories = Collections.unmodifiableMap(alternateAddressFactories);
        ResourceAddressFactory resourceAddressFactory = new ResourceAddressFactory(addressFactories, alternateAddressFactories);
        for (ResourceAddressFactorySpi resourceAddressFactorySpi : addressFactories.values()) {
            resourceAddressFactorySpi.setResourceAddressFactory(resourceAddressFactory);
        }
        return resourceAddressFactory;
    }

    private static ServiceLoader<ResourceAddressFactorySpi> loadResourceAddressFactorySpi(ClassLoader classLoader) {
        Class<ResourceAddressFactorySpi> service = ResourceAddressFactorySpi.class;
        return classLoader != null ? ServiceLoader.load(service, classLoader) : ServiceLoader.load(service);
    }

    protected ResourceAddressFactory(Map<String, ResourceAddressFactorySpi<?>> addressFactories, Map<String, Map<String, ResourceAddressFactorySpi<?>>> alternateAddressFactories) {
        this.addressFactories = addressFactories;
        this.alternateAddressFactories = alternateAddressFactories;
    }

    public ResourceAddress newResourceAddress(String location) {
        Map<String, Object> EMPTY_OPTIONS = Collections.emptyMap();
        return this.newResourceAddress(location, EMPTY_OPTIONS);
    }

    public ResourceAddress newResourceAddress(String location, String nextProtocol) {
        if (nextProtocol != null) {
            ResourceOptions options = ResourceOptions.FACTORY.newResourceOptions();
            options.setOption(ResourceAddress.NEXT_PROTOCOL, nextProtocol);
            return this.newResourceAddress(location, options);
        }
        return this.newResourceAddress(location);
    }

    public ResourceAddress newResourceAddress(String location, ResourceOptions options) {
        return this.newResourceAddress(location, options, null);
    }

    public ResourceAddress newResourceAddress(String location, ResourceOptions options, Object qualifier) {
        Objects.requireNonNull(options, "options cannot be null");
        ResourceAddressFactorySpi<?> resourceAddressFactory = this.findResourceAddressFactory(URIUtils.getScheme(location));
        return resourceAddressFactory.newResourceAddress(location, options, qualifier);
    }

    public ResourceAddress newResourceAddress(String location, Map<String, Object> options) {
        ResourceAddressFactorySpi<?> resourceAddressFactory = this.findResourceAddressFactory(URIUtils.getScheme(location));
        return resourceAddressFactory.newResourceAddress(location, options, ResourceOptions.FACTORY);
    }

    public ResourceAddress newResourceAddress(String location, Map<String, Object> options, final String nextProtocol) {
        ResourceAddressFactorySpi<?> resourceAddressFactory = this.findResourceAddressFactory(URIUtils.getScheme(location));
        if (nextProtocol != null) {
            return resourceAddressFactory.newResourceAddress(location, options, new ResourceOptions.Factory(){

                @Override
                public ResourceOptions newResourceOptions(ResourceOptions defaults) {
                    ResourceOptions newOptions = ResourceOptions.FACTORY.newResourceOptions(defaults);
                    newOptions.setOption(ResourceAddress.NEXT_PROTOCOL, nextProtocol);
                    return newOptions;
                }

                @Override
                public ResourceOptions newResourceOptions() {
                    ResourceOptions newOptions = ResourceOptions.FACTORY.newResourceOptions();
                    newOptions.setOption(ResourceAddress.NEXT_PROTOCOL, nextProtocol);
                    return newOptions;
                }
            });
        }
        return resourceAddressFactory.newResourceAddress(location, options, ResourceOptions.FACTORY);
    }

    public ResourceAddress newResourceAddress(ResourceAddress uriAddress, ResourceAddress transportAddress) {
        ResourceOptions options = ResourceOptions.FACTORY.newResourceOptions();
        options.setOption(ResourceAddress.TRANSPORT, transportAddress);
        options.setOption(ResourceAddress.NEXT_PROTOCOL, uriAddress.getOption(ResourceAddress.NEXT_PROTOCOL));
        return this.newResourceAddress(URIUtils.uriToString(uriAddress.getResource()), options);
    }

    public ResourceAddressFactorySpi<?> findResourceAddressFactory(String schemeName) throws IllegalArgumentException {
        if (schemeName == null) {
            throw new NullPointerException("schemeName");
        }
        ResourceAddressFactorySpi<?> resourceAddressFactory = this.addressFactories.get(schemeName);
        if (resourceAddressFactory == null) {
            throw new IllegalArgumentException(String.format("Unable to load scheme '%s': No appropriate resource address factory found", schemeName));
        }
        return resourceAddressFactory;
    }

    public Map<String, ResourceAddressFactorySpi<?>> getAlternateAddressFactories(String schemeName) {
        Map<String, ResourceAddressFactorySpi<?>> alternates = this.alternateAddressFactories.get(schemeName);
        return alternates == null ? Collections.emptyMap() : alternates;
    }
}

