/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.gateway.resource.address.URLUtils;

public final class URIUtils {
    public static final String NETWORK_INTERFACE_AUTHORITY_PORT = "^(\\[@[a-zA-Z0-9 :]*\\]|@[a-zA-Z0-9:]*):([0-9]*)$";
    public static final String NETWORK_INTERFACE_AUTHORITY = "(\\[{0,1}@[a-zA-Z0-9 :]*\\]{0,1})";
    private static final String MOCK_HOST = "127.0.0.1";

    public static String uriToString(URI uri) {
        return uri.toString();
    }

    public static String uriToString(NetworkInterfaceURI uri) {
        return uri.toString();
    }

    public static String getHost(String uriString) {
        try {
            URI uri = new URI(uriString);
            if (uri.getHost() == null) {
                throw new IllegalArgumentException("Invalid URI syntax. Scheme and host must be provided (port number is optional): " + uriString);
            }
            if (uri.getAuthority().startsWith("@") && !uri.getHost().startsWith("@")) {
                return "@" + uri.getHost();
            }
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getHost();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getScheme(String uriString) {
        try {
            return new URI(uriString).getScheme();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getScheme();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getAuthority(String uriString) {
        try {
            return new URI(uriString).getAuthority();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getAuthority();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getFragment(String uriString) {
        try {
            return new URI(uriString).getFragment();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getFragment();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getPath(String uriString) {
        try {
            return new URI(uriString).getPath();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getPath();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getQuery(String uriString) {
        try {
            return new URI(uriString).getQuery();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getQuery();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static int getPort(String uriString) {
        try {
            return new URI(uriString).getPort();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getPort();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getUserInfo(String uriString) {
        try {
            return new URI(uriString).getUserInfo();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriString).getUserInfo();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String buildURIAsString(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        URI helperURI;
        try {
            helperURI = new URI(scheme, authority, path, query, fragment);
        }
        catch (URISyntaxException e) {
            return NetworkInterfaceURI.buildURIToString(scheme, authority, path, query, fragment);
        }
        return helperURI.toString();
    }

    public static String buildURIAsString(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        URI helperURI;
        try {
            helperURI = new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        catch (URISyntaxException e) {
            return NetworkInterfaceURI.buildURIToString(scheme, userInfo, host, port, path, query, fragment);
        }
        return helperURI.toString();
    }

    public static String resolve(String uriInitial, String uriString) {
        try {
            return URIUtils.uriToString(new URI(uriInitial).resolve(uriString));
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uriInitial).resolve(uriString);
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String modifyURIScheme(String uri, String newScheme) {
        try {
            URI uriObj = new URI(uri);
            return URIUtils.uriToString(URLUtils.modifyURIScheme(uriObj, newScheme));
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uri).modifyURIScheme(newScheme);
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String modifyURIAuthority(String uri, String newAuthority) {
        try {
            URI uriObj = new URI(uri);
            Pattern pattern = Pattern.compile(NETWORK_INTERFACE_AUTHORITY);
            Matcher matcher = pattern.matcher(newAuthority);
            String matchedToken = MOCK_HOST;
            if (matcher.find()) {
                matchedToken = matcher.group(0);
                newAuthority = newAuthority.replace(matchedToken, MOCK_HOST);
            }
            URI modifiedURIAuthority = URLUtils.modifyURIAuthority(uriObj, newAuthority);
            String uriWithModifiedAuthority = URIUtils.uriToString(modifiedURIAuthority).replace(MOCK_HOST, matchedToken);
            return uriWithModifiedAuthority;
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uri).modifyURIAuthority(newAuthority);
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String modifyURIPort(String uri, int newPort) {
        try {
            URI uriObj = new URI(uri);
            return URIUtils.uriToString(URLUtils.modifyURIPort(uriObj, newPort));
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uri).modifyURIPort(newPort);
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String modifyURIPath(String uri, String newPath) {
        try {
            URI uriObj = new URI(uri);
            return URIUtils.uriToString(URLUtils.modifyURIPath(uriObj, newPath));
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uri).modifyURIPath(newPath);
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static boolean isAbsolute(String uri) {
        try {
            return new URI(uri).isAbsolute();
        }
        catch (URISyntaxException e) {
            try {
                return new NetworkInterfaceURI(uri).isAbsolute();
            }
            catch (IllegalArgumentException ne) {
                throw new IllegalArgumentException(ne.getMessage(), ne);
            }
        }
    }

    public static String getCanonicalURI(String uriString, boolean canonicalizePath) {
        if (uriString != null && !"".equals(uriString)) {
            return URIUtils.getCanonicalizedURI(uriString, canonicalizePath);
        }
        return null;
    }

    public static String getCanonicalizedURI(String uri, boolean canonicalizePath) {
        String canonicalURI = uri;
        if (uri != null) {
            String newPath;
            boolean trailingSlashWithPathlessScheme;
            String host = URIUtils.getHost(uri);
            String path = URIUtils.getPath(uri);
            boolean emptyPath = "".equals(path);
            boolean noPathToCanonicalize = canonicalizePath && (path == null || emptyPath);
            boolean trailingSlashPath = "/".equals(path);
            String scheme = URIUtils.getScheme(uri);
            boolean pathlessScheme = "ssl".equals(scheme) || "tcp".equals(scheme) || "pipe".equals(scheme) || "udp".equals(scheme) || "mux".equals(scheme);
            boolean bl = trailingSlashWithPathlessScheme = trailingSlashPath && pathlessScheme;
            Object object = trailingSlashWithPathlessScheme ? "" : (noPathToCanonicalize ? (pathlessScheme ? null : "/") : (newPath = null));
            if (host != null && !host.equals(host.toLowerCase()) || newPath != null) {
                path = newPath == null ? path : newPath;
                try {
                    canonicalURI = URIUtils.buildURIAsString(scheme, URIUtils.getUserInfo(uri), host == null ? null : host.toLowerCase(), URIUtils.getPort(uri), path, URIUtils.getQuery(uri), URIUtils.getFragment(uri));
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI: " + uri + " in Gateway configuration file", ex);
                }
            }
        }
        return canonicalURI;
    }

    private static class NetworkInterfaceURI {
        private static final String HOST_TEMPLATE = "127.0.0.1";
        private URI mockNetworkInterfaceURI;
        private Parser parser;
        private String scheme;
        private String fragment;
        private String authority;
        private String userInfo;
        private String host;
        private int port = -1;
        private String path;
        private String query;
        private boolean absolute;

        public static String buildURIToString(String scheme, String authority, String path, String query, String fragment) {
            URI helperURI;
            try {
                helperURI = new URI(scheme, "127.0.0.1", path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return helperURI.toString().replace("127.0.0.1", authority);
        }

        public static String buildURIToString(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
            URI helperURI;
            try {
                helperURI = new URI(scheme, userInfo, "127.0.0.1", port, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return helperURI.toString().replace("127.0.0.1", host);
        }

        public NetworkInterfaceURI(String uri) throws IllegalArgumentException {
            this.parser = new Parser(uri);
            this.parser.parse();
        }

        public String getHost() {
            return this.host;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getAuthority() {
            return this.authority;
        }

        public String getFragment() {
            return this.fragment;
        }

        public String getPath() {
            return this.path;
        }

        public String getQuery() {
            return this.query;
        }

        public int getPort() {
            return this.port;
        }

        public String getUserInfo() {
            return this.userInfo;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public String resolve(String uriString) {
            return this.parser.resolve(uriString);
        }

        public String modifyURIScheme(String newScheme) {
            return this.buildURIFromTokens(newScheme, this.host, this.port, this.path, this.query, this.fragment);
        }

        public String modifyURIAuthority(String newAuthority) {
            return this.buildURIFromTokens(this.scheme, newAuthority, this.path, this.query, this.fragment);
        }

        public String modifyURIPort(int newPort) {
            return this.buildURIFromTokens(this.scheme, this.host, newPort, this.path, this.query, this.fragment);
        }

        public String modifyURIPath(String newPath) {
            return this.buildURIFromTokens(this.scheme, this.host, this.port, newPath, this.query, this.fragment);
        }

        private String buildURIFromTokens(String scheme, String host, int port, String path, String query, String fragment) {
            return scheme + "://" + host + ":" + port + (path.isEmpty() ? "" : "/") + path + (query != null ? "?" + query : "") + (fragment != null ? "#" + fragment : "");
        }

        private String buildURIFromTokens(String scheme, String authority, String path, String query, String fragment) {
            return scheme + "://" + authority + (path.isEmpty() ? "" : "/") + path + (query != null ? "?" + query : "") + (fragment != null ? "#" + fragment : "");
        }

        private class Parser {
            private String uri;
            private String matchedToken;

            public Parser(String uri) {
                this.uri = uri;
            }

            private void parse() throws IllegalArgumentException {
                if (!this.uri.startsWith("tcp://") && !this.uri.startsWith("udp://")) {
                    throw new IllegalArgumentException("Network interface URI syntax should only be applicable for tcp and udp schemes");
                }
                Pattern pattern = Pattern.compile(URIUtils.NETWORK_INTERFACE_AUTHORITY);
                Matcher matcher = pattern.matcher(this.uri);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Invalid network interface URI syntax");
                }
                this.matchedToken = matcher.group(0);
                if (this.matchedToken.matches(".*:.*:.*")) {
                    throw new IllegalArgumentException("Multiple ':' characters within network interface syntax not allowed");
                }
                if (!(!this.matchedToken.contains(" ") || this.matchedToken.startsWith("[") && this.matchedToken.endsWith("]"))) {
                    throw new IllegalArgumentException("Network interface syntax host contains spaces but misses bracket(s)");
                }
                NetworkInterfaceURI.this.mockNetworkInterfaceURI = URI.create(this.uri.replace(this.matchedToken, "127.0.0.1"));
                this.populateUriDataFromMockInterfaceURI();
            }

            private String resolve(String uriString) {
                return URIUtils.uriToString(NetworkInterfaceURI.this.mockNetworkInterfaceURI.resolve(uriString)).replace("127.0.0.1", this.matchedToken);
            }

            private void populateUriDataFromMockInterfaceURI() {
                NetworkInterfaceURI.this.scheme = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getScheme();
                NetworkInterfaceURI.this.fragment = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getFragment();
                NetworkInterfaceURI.this.authority = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getAuthority().replace("127.0.0.1", this.matchedToken);
                NetworkInterfaceURI.this.userInfo = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getUserInfo();
                NetworkInterfaceURI.this.host = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getHost().replace("127.0.0.1", this.matchedToken);
                NetworkInterfaceURI.this.port = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getPort();
                NetworkInterfaceURI.this.path = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getPath();
                NetworkInterfaceURI.this.query = NetworkInterfaceURI.this.mockNetworkInterfaceURI.getQuery();
                NetworkInterfaceURI.this.absolute = NetworkInterfaceURI.this.mockNetworkInterfaceURI.isAbsolute();
            }
        }
    }
}

