/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kaazing.gateway.resource.address.IdentityResolver;
import org.kaazing.gateway.resource.address.NameResolver;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;
import org.kaazing.gateway.resource.address.uri.URIUtils;

public abstract class ResourceAddressFactorySpi<T extends ResourceAddress> {
    private static final String NO_ADDRESSES_AVAILABLE_FOR_BINDING_FORMATTER = " No addresses available for binding for URI: %s.";
    private static final Map<String, Object> EMPTY_OPTIONS = Collections.emptyMap();
    private ResourceAddressFactory addressFactory;

    public void setResourceAddressFactory(ResourceAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    protected ResourceAddressFactory getResourceAddressFactory() {
        return this.addressFactory;
    }

    public abstract String getSchemeName();

    public final T newResourceAddress(String location) {
        return this.newResourceAddress(location, new HashMap<String, Object>(EMPTY_OPTIONS));
    }

    public final T newResourceAddress(String location, Map<String, Object> optionsByName) {
        return this.newResourceAddress(location, optionsByName, ResourceOptions.FACTORY);
    }

    public final T newResourceAddress(String location, Map<String, Object> optionsByName, ResourceOptions.Factory optionsFactory) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (optionsByName == null) {
            throw new NullPointerException("optionsByName");
        }
        String schemeName = this.getSchemeName();
        if (schemeName == null) {
            throw new NullPointerException("schemeName");
        }
        String transportName = this.getTransportName();
        if (transportName == null) {
            throw new NullPointerException("transportName");
        }
        if (!schemeName.equals(URIUtils.getScheme(location))) {
            throw new IllegalArgumentException(String.format("Expected scheme \"%s\" for URI: %s", schemeName, location));
        }
        ResourceOptions options = optionsFactory.newResourceOptions();
        this.setAlternateOption(location, options, optionsByName);
        this.stripOptionPrefixes(optionsByName);
        String external = location;
        if (URIUtils.getPort(external) == this.getSchemePort()) {
            location = URIUtils.modifyURIPort(location, -1);
        }
        if (URIUtils.getPort(location) == -1) {
            location = URIUtils.modifyURIPort(location, this.getSchemePort());
        }
        if (!transportName.equals(this.getSchemeName())) {
            location = URIUtils.modifyURIScheme(location, transportName);
        }
        this.parseNamedOptions(location, options, optionsByName);
        List<T> addresses = this.newResourceAddresses0(external, location, options);
        ResourceAddress alternate = null;
        for (int i = addresses.size() - 1; i >= 0; --i) {
            ResourceAddress address = (ResourceAddress)addresses.get(i);
            if (alternate != null) {
                ResourceOptions newOptions = ResourceOptions.FACTORY.newResourceOptions(options);
                newOptions.setOption(ResourceAddress.ALTERNATE, alternate);
                this.setOptions(address, location, newOptions, null);
            } else {
                this.setOptions(address, location, options, null);
            }
            URI resource = address.getResource();
            if (!transportName.equals(resource.getScheme())) {
                throw new IllegalArgumentException(String.format("Expected scheme \"%s\" for resource address URI: %s", transportName, resource));
            }
            alternate = address;
        }
        if (addresses.isEmpty()) {
            this.throwNoAddressesToBindError(location);
        }
        return (T)((ResourceAddress)addresses.get(0));
    }

    protected void setAlternateOption(String location, ResourceOptions options, Map<String, Object> optionsByName) {
    }

    protected void stripOptionPrefixes(Map<String, Object> optionsByName) {
        List<String> prefixes;
        String transportName = this.getTransportName();
        String protocolName = this.getProtocolName();
        String transportFormat = String.format("%s.", transportName);
        if (protocolName != null) {
            String transportAsProtocolFormat = String.format("%s[%s].", transportName, protocolName);
            prefixes = Arrays.asList(transportFormat, transportAsProtocolFormat);
        } else {
            prefixes = Arrays.asList(transportFormat);
        }
        for (String prefix : prefixes) {
            HashSet<String> prefixedOptionNames = new HashSet<String>();
            Set<Map.Entry<String, Object>> entrySet = optionsByName.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String optionName = entry.getKey();
                if (!optionName.startsWith(prefix)) continue;
                prefixedOptionNames.add(optionName);
            }
            int prefixLength = prefix.length();
            for (String prefixedOptionName : prefixedOptionNames) {
                Object optionValue = optionsByName.remove(prefixedOptionName);
                String newOptionName = prefixedOptionName.substring(prefixLength);
                optionsByName.put(newOptionName, optionValue);
            }
        }
    }

    public final T newResourceAddress(String location, ResourceOptions options, Object qualifier) {
        String transportName;
        String external = location;
        if (URIUtils.getPort(location) == -1) {
            location = URIUtils.modifyURIPort(location, this.getSchemePort());
        }
        if (!(transportName = this.getTransportName()).equals(this.getSchemeName())) {
            location = URIUtils.modifyURIScheme(location, transportName);
        }
        List<T> addresses = this.newResourceAddresses0(external, location, options);
        ResourceAddress alternate = null;
        for (int i = addresses.size() - 1; i >= 0; --i) {
            ResourceAddress address = (ResourceAddress)addresses.get(i);
            if (alternate != null) {
                ResourceOptions newOptions = ResourceOptions.FACTORY.newResourceOptions(options);
                newOptions.setOption(ResourceAddress.ALTERNATE, alternate);
                this.setOptions(address, location, newOptions, qualifier);
            } else {
                this.setOptions(address, location, options, qualifier);
            }
            URI resource = address.getResource();
            if (!transportName.equals(resource.getScheme())) {
                throw new IllegalArgumentException(String.format("Expected scheme \"%s\" for resource address URI: %s", transportName, resource));
            }
            alternate = address;
        }
        if (addresses.isEmpty()) {
            this.throwNoAddressesToBindError(location);
        }
        return (T)((ResourceAddress)addresses.get(0));
    }

    protected List<T> newResourceAddresses0(String original, String location, ResourceOptions options) {
        return Collections.singletonList(this.newResourceAddress0(original, location, options));
    }

    protected T newResourceAddress0(String original, String location, ResourceOptions options) {
        T address = this.newResourceAddress0(original, location);
        this.setOptions(address, location, options, options.getOption(ResourceAddress.QUALIFIER));
        return address;
    }

    protected abstract T newResourceAddress0(String var1, String var2);

    private void setOptions(T address, String location, ResourceOptions options, Object qualifier) {
        ResourceAddress transport = options.getOption(ResourceAddress.TRANSPORT);
        String transportURI = options.getOption(ResourceAddress.TRANSPORT_URI);
        if (transport == null && this.addressFactory != null) {
            ResourceFactory factory;
            ResourceOptions newOptions = ResourceOptions.FACTORY.newResourceOptions(options);
            if (transportURI == null && (factory = this.getTransportFactory()) != null) {
                transportURI = factory.createURI(location);
                newOptions.setOption(ResourceAddress.TRANSPORT_URI, transportURI);
            }
            if (transportURI != null) {
                ResourceOptions transportOptions = ResourceOptions.FACTORY.newResourceOptions();
                transportOptions.setOption(ResourceAddress.NEXT_PROTOCOL, this.getProtocolName());
                URI locationURI = URI.create(location);
                transportOptions.setOption(ResourceAddress.TRANSPORTED_URI, locationURI);
                transport = this.addressFactory.newResourceAddress(transportURI, transportOptions);
            }
            newOptions.setOption(ResourceAddress.TRANSPORT, transport);
            options = newOptions;
        }
        this.setOptions(address, options, qualifier);
    }

    protected void setOptions(T address, ResourceOptions options, Object qualifier) {
        Object newQualifier = options.getOption(ResourceAddress.QUALIFIER);
        if (newQualifier == null) {
            newQualifier = qualifier;
        }
        if (options.hasOption(ResourceAddress.NEXT_PROTOCOL)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.NEXT_PROTOCOL, (String)options.getOption(ResourceAddress.NEXT_PROTOCOL));
        }
        if (options.hasOption(ResourceAddress.TRANSPORT_URI)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.TRANSPORT_URI, (String)options.getOption(ResourceAddress.TRANSPORT_URI));
        }
        if (options.hasOption(ResourceAddress.TRANSPORT)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.TRANSPORT, (ResourceAddress)options.getOption(ResourceAddress.TRANSPORT));
        }
        if (options.hasOption(ResourceAddress.ALTERNATE)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.ALTERNATE, (ResourceAddress)options.getOption(ResourceAddress.ALTERNATE));
        }
        if (options.hasOption(ResourceAddress.RESOLVER)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.RESOLVER, (NameResolver)options.getOption(ResourceAddress.RESOLVER));
        }
        if (options.hasOption(ResourceAddress.BIND_ALTERNATE)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.BIND_ALTERNATE, (Boolean)options.getOption(ResourceAddress.BIND_ALTERNATE));
        }
        if (options.hasOption(ResourceAddress.TRANSPORTED_URI)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.TRANSPORTED_URI, (URI)options.getOption(ResourceAddress.TRANSPORTED_URI));
        }
        if (options.hasOption(ResourceAddress.IDENTITY_RESOLVER)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.IDENTITY_RESOLVER, (IdentityResolver)options.getOption(ResourceAddress.IDENTITY_RESOLVER));
        }
        if (qualifier != null || options.hasOption(ResourceAddress.QUALIFIER)) {
            ((ResourceAddress)address).setOption0(ResourceAddress.QUALIFIER, (Object)newQualifier);
        }
    }

    protected int getSchemePort() {
        return -1;
    }

    protected abstract String getTransportName();

    protected final void parseNamedOptions(String location, ResourceOptions options, Map<String, Object> optionsByName) {
        IdentityResolver identityResolver;
        URI transportedURI;
        Boolean bindAlternate;
        NameResolver resolver;
        ResourceAddress alternate;
        ResourceFactory factory;
        String transportURI;
        Object qualifier;
        String nextProtocol = (String)optionsByName.remove(ResourceAddress.NEXT_PROTOCOL.name());
        if (nextProtocol != null) {
            options.setOption(ResourceAddress.NEXT_PROTOCOL, nextProtocol);
        }
        if ((qualifier = optionsByName.remove(ResourceAddress.QUALIFIER.name())) != null) {
            options.setOption(ResourceAddress.QUALIFIER, qualifier);
        }
        if ((transportURI = (String)optionsByName.remove(ResourceAddress.TRANSPORT.name())) == null && (factory = this.getTransportFactory()) != null) {
            transportURI = factory.createURI(location);
        }
        if (transportURI != null) {
            options.setOption(ResourceAddress.TRANSPORT_URI, transportURI);
        }
        if ((alternate = (ResourceAddress)optionsByName.remove(ResourceAddress.ALTERNATE.name())) != null) {
            options.setOption(ResourceAddress.ALTERNATE, alternate);
        }
        if ((resolver = (NameResolver)optionsByName.remove(ResourceAddress.RESOLVER.name())) != null) {
            options.setOption(ResourceAddress.RESOLVER, resolver);
        }
        if ((bindAlternate = (Boolean)optionsByName.remove(ResourceAddress.BIND_ALTERNATE.name())) != null) {
            options.setOption(ResourceAddress.BIND_ALTERNATE, bindAlternate);
        }
        if ((transportedURI = (URI)optionsByName.remove(ResourceAddress.TRANSPORTED_URI.name())) != null) {
            options.setOption(ResourceAddress.TRANSPORTED_URI, transportedURI);
        }
        if ((identityResolver = (IdentityResolver)optionsByName.remove(ResourceAddress.IDENTITY_RESOLVER.name())) != null) {
            options.setOption(ResourceAddress.IDENTITY_RESOLVER, identityResolver);
        }
        this.parseNamedOptions0(location, options, optionsByName);
        ResourceAddress transport = null;
        if (transportURI != null && this.addressFactory != null) {
            String protocolName = this.getProtocolName();
            if (optionsByName == Collections.emptyMap()) {
                optionsByName = new HashMap<String, Object>();
            }
            URI locationURI = URI.create(location);
            optionsByName.put(ResourceAddress.TRANSPORTED_URI.name(), locationURI);
            transport = this.addressFactory.newResourceAddress(transportURI, optionsByName, protocolName);
        }
        if (transport != null) {
            options.setOption(ResourceAddress.TRANSPORT, transport);
        }
    }

    protected void parseNamedOptions0(String location, ResourceOptions options, Map<String, Object> optionsByName) {
    }

    protected <T extends ResourceAddress> T newResourceAddressWithAlternate(String location, Map<String, Object> optionsByName, ResourceAddress alternateAddress) {
        optionsByName.put(ResourceAddress.ALTERNATE.name(), alternateAddress);
        return (T)this.getResourceAddressFactory().newResourceAddress(location, optionsByName);
    }

    protected Map<String, Object> getNewOptionsByName(ResourceOptions options, Map<String, Object> optionsByName) {
        HashMap<String, Object> clonedOptionsByName = new HashMap<String, Object>(optionsByName);
        clonedOptionsByName.put(ResourceAddress.NEXT_PROTOCOL.name(), options.getOption(ResourceAddress.NEXT_PROTOCOL));
        clonedOptionsByName.put(ResourceAddress.QUALIFIER.name(), options.getOption(ResourceAddress.QUALIFIER));
        clonedOptionsByName.put(ResourceAddress.TRANSPORT_URI.name(), options.getOption(ResourceAddress.TRANSPORT_URI));
        clonedOptionsByName.put(ResourceAddress.BIND_ALTERNATE.name(), options.getOption(ResourceAddress.BIND_ALTERNATE));
        clonedOptionsByName.put(ResourceAddress.RESOLVER.name(), options.getOption(ResourceAddress.RESOLVER));
        return clonedOptionsByName;
    }

    protected abstract ResourceFactory getTransportFactory();

    protected abstract String getProtocolName();

    protected String getRootSchemeName() {
        return null;
    }

    private void throwNoAddressesToBindError(String location) {
        throw new IllegalArgumentException(String.format(NO_ADDRESSES_AVAILABLE_FOR_BINDING_FORMATTER, location));
    }
}

