/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.util.HashMap;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceOption;

public interface ResourceOptions {
    public static final Factory FACTORY = new Factory(){

        @Override
        public ResourceOptions newResourceOptions() {
            return new ResourceOptionsImpl();
        }

        @Override
        public ResourceOptions newResourceOptions(final ResourceOptions defaults) {
            return new ResourceOptionsImpl(){

                @Override
                public <T> boolean hasOption(ResourceOption<T> key) {
                    return super.hasOption(key) || defaults.hasOption(key);
                }

                @Override
                protected <T> T getOption0(ResourceOption<T> key) {
                    T option = super.getOption0(key);
                    if (option == null && !super.hasOption(key)) {
                        option = defaults.getOption(key);
                    }
                    return option;
                }
            };
        }

        class ResourceOptionsImpl
        implements ResourceOptions {
            private final Map<ResourceOption<?>, Object> optionsByKey = new HashMap();

            ResourceOptionsImpl() {
            }

            @Override
            public final <T> T setOption(ResourceOption<T> key, T value) {
                return (T)this.optionsByKey.put(key, value);
            }

            @Override
            public final <T> T getOption(ResourceOption<T> key) {
                return key.resolveValue(this.getOption0(key));
            }

            @Override
            public <T> boolean hasOption(ResourceOption<T> key) {
                return this.optionsByKey.containsKey(key);
            }

            protected <T> T getOption0(ResourceOption<T> key) {
                return (T)this.optionsByKey.get(key);
            }

            public String toString() {
                return this.optionsByKey.toString();
            }
        }
    };

    public <T> T setOption(ResourceOption<T> var1, T var2);

    public <T> T getOption(ResourceOption<T> var1);

    public <T> boolean hasOption(ResourceOption<T> var1);

    public static interface Factory {
        public ResourceOptions newResourceOptions();

        public ResourceOptions newResourceOptions(ResourceOptions var1);
    }
}

