/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolutionUtils {
    private static List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    private static final Logger LOG = LoggerFactory.getLogger(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    public static Collection<InetAddress> getAllByName(String host, boolean allowIPv6) {
        ArrayList<InetAddress> resolvedDeviceURIs;
        Enumeration<NetworkInterface> networkInterfaces = ResolutionUtils.cloneInterfaces(ResolutionUtils.networkInterfaces);
        List<String> resolvedAddresses = ResolutionUtils.resolveDeviceAddress(host, networkInterfaces, allowIPv6);
        ArrayList<InetAddress> resolvedHosts = resolvedDeviceURIs = new ArrayList<InetAddress>();
        for (String resolvedAddress : resolvedAddresses) {
            try {
                resolvedHosts.addAll(Arrays.asList(InetAddress.getAllByName(resolvedAddress)));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return resolvedHosts;
    }

    private static List<String> resolveDeviceAddress(String deviceName, Enumeration<NetworkInterface> networkInterfaces, boolean allowIPv6) {
        ArrayList<String> resolvedAddresses = new ArrayList<String>();
        if (deviceName.startsWith("[@") && deviceName.endsWith("]")) {
            deviceName = deviceName.substring(2, deviceName.lastIndexOf(93));
        } else if (deviceName.startsWith("@")) {
            deviceName = deviceName.substring(1);
        }
        while (networkInterfaces.hasMoreElements()) {
            Enumeration<NetworkInterface> subInterfaces;
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (deviceName.toLowerCase().equals(networkInterface.getDisplayName().toLowerCase())) {
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress instanceof Inet6Address) {
                        if (!allowIPv6) continue;
                        String inet6HostAddress = inetAddress.getHostAddress();
                        resolvedAddresses.add(String.format("[%s]", inet6HostAddress));
                        continue;
                    }
                    resolvedAddresses.add(inetAddress.getHostAddress());
                }
            }
            if (!(subInterfaces = networkInterface.getSubInterfaces()).hasMoreElements()) continue;
            resolvedAddresses.addAll(ResolutionUtils.resolveDeviceAddress(deviceName, subInterfaces, allowIPv6));
        }
        return resolvedAddresses;
    }

    private static Enumeration<NetworkInterface> cloneInterfaces(List<NetworkInterface> interfaces) {
        return Collections.enumeration(new ArrayList<NetworkInterface>(interfaces));
    }

    static {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                networkInterfaces.add(interfaces.nextElement());
            }
        }
        catch (SocketException socketEx) {
            LOG.debug("server", (Object)"Unable to resolve device URIs, processing URIs without device resolution.");
        }
    }
}

