/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kaazing.gateway.resource.address.NameResolver;
import org.kaazing.gateway.resource.address.ResourceAddressFactorySpi;
import org.kaazing.gateway.resource.address.ResourceOption;
import org.kaazing.gateway.resource.address.ResourceOptions;

public abstract class ResourceAddress
extends SocketAddress
implements ResourceOptions {
    private static final long serialVersionUID = 1L;
    public static final ResourceOption<String> NEXT_PROTOCOL = new NextProtocolOption();
    public static final ResourceOption<URI> TRANSPORT_URI = new TransportURIOption();
    public static final ResourceOption<ResourceAddress> TRANSPORT = new TransportOption();
    public static final ResourceOption<ResourceAddress> ALTERNATE = new AlternateOption();
    public static final ResourceOption<NameResolver> RESOLVER = new ResolverOption();
    public static final ResourceOption<Boolean> BIND_ALTERNATE = new BindAlternateOption();
    public static final ResourceOption<Boolean> CONNECT_REQUIRES_INIT = new ConnectRequiresInitOption();
    @Deprecated
    public static final ResourceOption<Object> QUALIFIER = new QualifierOption();
    public static final ResourceOption<URI> TRANSPORTED_URI = new TransportedURIOption();
    private final ResourceAddressFactorySpi factory;
    private final URI externalURI;
    private final URI resourceURI;
    private String nextProtocol;
    private ResourceAddress transport;
    private URI transportURI;
    private ResourceAddress alternate;
    private NameResolver resolver;
    private Object qualifier;
    private Boolean bindAlternate;
    private Boolean connectRequiresInit;

    public ResourceAddress(ResourceAddressFactorySpi factory, URI externalURI, URI resourceURI) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.externalURI = Objects.requireNonNull(externalURI, "externalURI");
        this.resourceURI = Objects.requireNonNull(resourceURI, "resourceURI");
    }

    protected ResourceAddress(ResourceAddressFactorySpi factory, URI resourceURI) {
        this(factory, resourceURI, resourceURI);
    }

    public URI getResource() {
        return this.resourceURI;
    }

    public URI getExternalURI() {
        return this.externalURI;
    }

    public ResourceAddress getTransport() {
        return this.transport;
    }

    public ResourceAddress findTransport(String query) {
        List<String> prefixes;
        String transportProtocolName;
        ResourceAddress result = null;
        if (query == null || query.length() == 0) {
            return result;
        }
        String myTransportName = String.format("%s.", this.getResource().getScheme());
        String string = transportProtocolName = this.getTransport() != null ? this.getTransport().getOption(NEXT_PROTOCOL) : null;
        if (transportProtocolName != null) {
            String transportAsProtocolFormat = String.format("%s[%s].", this.getResource().getScheme(), transportProtocolName);
            prefixes = Arrays.asList(myTransportName, transportAsProtocolFormat);
        } else {
            prefixes = Arrays.asList(myTransportName);
        }
        for (String prefix : prefixes) {
            if (result != null) continue;
            if (query.equals(prefix.substring(0, prefix.length() - 1))) {
                return this;
            }
            if (!query.startsWith(prefix)) continue;
            query = query.substring(prefix.length());
            result = this.getTransport().findTransport(query);
        }
        if (this.getTransport() == null) {
            return null;
        }
        return this.getTransport().findTransport(query);
    }

    @Override
    public <T> T setOption(ResourceOption<T> key, T value) {
        throw new IllegalStateException(String.format("%s options are read-only", ResourceAddress.class.getSimpleName()));
    }

    @Override
    public final <T> boolean hasOption(ResourceOption<T> option) {
        if (option instanceof DefaultResourceOption) {
            DefaultResourceOption resourceOption = (DefaultResourceOption)option;
            switch (resourceOption.kind) {
                case NEXT_PROTOCOL: {
                    return this.nextProtocol != null;
                }
                case TRANSPORT: {
                    return this.transport != null;
                }
                case TRANSPORT_URI: {
                    return this.transportURI != null;
                }
                case ALTERNATE: {
                    return this.alternate != null;
                }
                case RESOLVER: {
                    return this.resolver != null;
                }
                case BIND_ALTERNATE: {
                    return this.bindAlternate != null;
                }
                case QUALIFIER: {
                    return this.qualifier != null;
                }
                case TRANSPORTED_URI: {
                    return this.getTransportedURI() != null;
                }
                case CONNECT_REQUIRES_INIT: {
                    return this.connectRequiresInit != null;
                }
            }
        }
        return this.hasOption0(option);
    }

    protected <V> boolean hasOption0(ResourceOption<V> option) {
        throw new IllegalArgumentException(String.format("Unrecognized option: %s", option));
    }

    public final <V> V getOption(ResourceOption<V> option) {
        V value = this.getOption0(option);
        return value != null ? value : option.defaultValue();
    }

    protected URI getTransportedURI() {
        return null;
    }

    protected void setTransportedURI(URI transportedURI) {
    }

    public final ResourceAddress resolve(String newPath) {
        if (newPath == null) {
            throw new NullPointerException(newPath);
        }
        URI addressURI = this.getResource();
        return this.resolve(addressURI.getPath(), newPath);
    }

    protected final ResourceAddress resolve(String oldPath, String newPath) {
        boolean newPathDiffersFromOld;
        URI addressURI = this.getResource();
        URI externalURI = this.getExternalURI();
        boolean bl = newPathDiffersFromOld = !oldPath.equals(newPath);
        if (!newPathDiffersFromOld) {
            return this;
        }
        boolean shouldResolveNewPath = oldPath.equals(addressURI.getPath());
        if (!shouldResolveNewPath) {
            return this;
        }
        URI newResourceURI = addressURI.resolve(newPath);
        URI newExternalURI = externalURI.resolve(newPath);
        ResourceOptions newOptions = FACTORY.newResourceOptions(this);
        this.resolve(oldPath, newPath, newOptions);
        return this.factory.newResourceAddress0(newExternalURI, newResourceURI, newOptions);
    }

    protected void resolve(String oldPath, String newPath, ResourceOptions newOptions) {
        ResourceAddress alternate;
        ResourceAddress transport = this.getOption(TRANSPORT);
        if (transport != null) {
            newOptions.setOption(TRANSPORT, transport.resolve(oldPath, newPath));
        }
        if ((alternate = this.getOption(ALTERNATE)) != null) {
            newOptions.setOption(ALTERNATE, alternate.resolve(oldPath, newPath));
        }
    }

    protected <V> V getOption0(ResourceOption<V> option) {
        if (option instanceof DefaultResourceOption) {
            DefaultResourceOption resourceOption = (DefaultResourceOption)option;
            switch (resourceOption.kind) {
                case NEXT_PROTOCOL: {
                    return (V)this.nextProtocol;
                }
                case TRANSPORT: {
                    return (V)this.transport;
                }
                case TRANSPORT_URI: {
                    return (V)this.transportURI;
                }
                case ALTERNATE: {
                    return (V)this.alternate;
                }
                case RESOLVER: {
                    return (V)this.resolver;
                }
                case BIND_ALTERNATE: {
                    return (V)this.bindAlternate;
                }
                case QUALIFIER: {
                    return (V)this.qualifier;
                }
                case TRANSPORTED_URI: {
                    return (V)this.getTransportedURI();
                }
                case CONNECT_REQUIRES_INIT: {
                    return (V)this.connectRequiresInit;
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option: %s", option));
    }

    protected <V> void setOption0(ResourceOption<V> option, V value) {
        if (option instanceof DefaultResourceOption) {
            DefaultResourceOption defaultOption = (DefaultResourceOption)option;
            switch (defaultOption.kind) {
                case NEXT_PROTOCOL: {
                    this.nextProtocol = (String)value;
                    return;
                }
                case TRANSPORT_URI: {
                    this.transportURI = (URI)value;
                    return;
                }
                case TRANSPORT: {
                    this.transport = (ResourceAddress)value;
                    return;
                }
                case ALTERNATE: {
                    this.alternate = (ResourceAddress)value;
                    return;
                }
                case RESOLVER: {
                    this.resolver = (NameResolver)value;
                    return;
                }
                case BIND_ALTERNATE: {
                    this.bindAlternate = (Boolean)value;
                    return;
                }
                case QUALIFIER: {
                    this.qualifier = value;
                    return;
                }
                case TRANSPORTED_URI: {
                    this.setTransportedURI((URI)value);
                    return;
                }
                case CONNECT_REQUIRES_INIT: {
                    this.connectRequiresInit = (Boolean)value;
                    return;
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option: %s", option));
    }

    public int hashCode() {
        int result = this.resourceURI.hashCode();
        result = 31 * result + (this.nextProtocol != null ? this.nextProtocol.hashCode() : 0);
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        result = 31 * result + (this.transportURI != null ? this.transportURI.hashCode() : 0);
        result = 31 * result + (this.alternate != null ? this.alternate.hashCode() : 0);
        result = 31 * result + (this.resolver != null ? this.resolver.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.getTransportedURI() != null ? this.getTransportedURI().hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceAddress address = (ResourceAddress)o;
        if (!this.resourceURI.equals(address.resourceURI)) {
            return false;
        }
        if (this.nextProtocol != null ? !this.nextProtocol.equals(address.nextProtocol) : address.nextProtocol != null) {
            return false;
        }
        if (this.transport != null ? !this.transport.equals(address.transport) : address.transport != null) {
            return false;
        }
        if (this.transport == null && (this.transportURI != null ? !this.transportURI.equals(address.transportURI) : address.transportURI != null)) {
            return false;
        }
        if (this.alternate != null ? !this.alternate.equals(address.alternate) : address.alternate != null) {
            return false;
        }
        if (this.resolver != null ? !this.resolver.equals(address.resolver) : address.resolver != null) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(address.qualifier) : address.qualifier != null) {
            return false;
        }
        return !(this.getTransportedURI() == null ? address.getTransportedURI() != null : !this.getTransportedURI().equals(address.getTransportedURI()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    protected void toString(StringBuilder builder, int level) {
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        builder.append('[');
        builder.append(this.resourceURI);
        builder.append(' ');
        if (!this.externalURI.equals(this.resourceURI)) {
            builder.append('(');
            builder.append(this.externalURI);
            builder.append(')');
            builder.append(' ');
        }
        if (this.nextProtocol != null) {
            builder.append(this.nextProtocol);
            builder.append(' ');
        }
        builder.setCharAt(builder.length() - 1, ']');
        if (this.qualifier != null) {
            builder.append(' ');
            builder.append(this.qualifier);
        }
        if (this.transport != null) {
            builder.append('\n');
            this.transport.toString(builder, level + 1);
        }
        if (this.alternate != null && !Boolean.FALSE.equals(this.bindAlternate)) {
            builder.append('\n');
            this.alternate.toString(builder, level);
        }
    }

    private static class ConnectRequiresInitOption
    extends DefaultResourceOption<Boolean> {
        private ConnectRequiresInitOption() {
            super(DefaultResourceOption.Kind.CONNECT_REQUIRES_INIT, "connectRequiresInit", Boolean.FALSE);
        }
    }

    private static class TransportedURIOption
    extends DefaultResourceOption<URI> {
        private TransportedURIOption() {
            super(DefaultResourceOption.Kind.TRANSPORTED_URI, "transportedURI");
        }
    }

    private static class QualifierOption
    extends DefaultResourceOption<Object> {
        private QualifierOption() {
            super(DefaultResourceOption.Kind.QUALIFIER, "qualifier");
        }
    }

    private static class BindAlternateOption
    extends DefaultResourceOption<Boolean> {
        private BindAlternateOption() {
            super(DefaultResourceOption.Kind.BIND_ALTERNATE, "bindAlternate", Boolean.TRUE);
        }
    }

    private static class ResolverOption
    extends DefaultResourceOption<NameResolver> {
        private ResolverOption() {
            super(DefaultResourceOption.Kind.RESOLVER, "resolver", new NameResolver(){
                private final Map<String, NameResolver> wildcards;
                {
                    HashMap<String, NameResolver> wildcards = new HashMap<String, NameResolver>();
                    wildcards.put("0.0.0.0", new WildcardNameResolver(){

                        @Override
                        public Collection<InetAddress> getAllByName(String host) throws UnknownHostException {
                            if (!"0.0.0.0".equals(host)) {
                                throw new UnknownHostException(host);
                            }
                            Collection<InetAddress> inetAddresses = super.getAllByName(host);
                            ResolverOption.retainInetAddresses(inetAddresses, IpAddressFamily.IPv4);
                            return inetAddresses;
                        }
                    });
                    this.wildcards = wildcards;
                }

                @Override
                public Collection<InetAddress> getAllByName(String host) throws UnknownHostException {
                    NameResolver wildcard = this.wildcards.get(host);
                    if (wildcard != null) {
                        return wildcard.getAllByName(host);
                    }
                    return Arrays.asList(InetAddress.getAllByName(host));
                }

                abstract class WildcardNameResolver
                implements NameResolver {
                    WildcardNameResolver() {
                    }

                    @Override
                    public Collection<InetAddress> getAllByName(String host) throws UnknownHostException {
                        try {
                            HashSet<InetAddress> inetAddresses = new HashSet<InetAddress>();
                            for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                                ArrayList<InetAddress> ifaceAddresses = Collections.list(iface.getInetAddresses());
                                inetAddresses.addAll(ifaceAddresses);
                                for (NetworkInterface subiface : Collections.list(iface.getSubInterfaces())) {
                                    ArrayList<InetAddress> subifaceAddresses = Collections.list(subiface.getInetAddresses());
                                    inetAddresses.addAll(subifaceAddresses);
                                }
                            }
                            return inetAddresses;
                        }
                        catch (SocketException se) {
                            UnknownHostException e = new UnknownHostException(host);
                            e.initCause(se);
                            throw e;
                        }
                    }
                }
            });
        }

        private static void retainInetAddresses(Iterable<InetAddress> ifaceAddresses, IpAddressFamily family) {
            Iterator<InetAddress> $i = ifaceAddresses.iterator();
            block4: while ($i.hasNext()) {
                InetAddress ifaceAddress = $i.next();
                switch (family) {
                    case IPv4: {
                        if (ifaceAddress instanceof Inet4Address) continue block4;
                        $i.remove();
                        continue block4;
                    }
                    case IPv6: {
                        if (ifaceAddress instanceof Inet6Address) continue block4;
                        $i.remove();
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unrecognized IP address family " + (Object)((Object)family));
            }
        }

        private static enum IpAddressFamily {
            IPv4,
            IPv6;

        }
    }

    private static class AlternateOption
    extends DefaultResourceOption<ResourceAddress> {
        private AlternateOption() {
            super(DefaultResourceOption.Kind.ALTERNATE, "alternate");
        }
    }

    private static class TransportOption
    extends DefaultResourceOption<ResourceAddress> {
        private TransportOption() {
            super(DefaultResourceOption.Kind.TRANSPORT, "transport");
        }
    }

    private static class TransportURIOption
    extends DefaultResourceOption<URI> {
        private TransportURIOption() {
            super(DefaultResourceOption.Kind.TRANSPORT_URI, "transportURI");
        }
    }

    private static class NextProtocolOption
    extends DefaultResourceOption<String> {
        private NextProtocolOption() {
            super(DefaultResourceOption.Kind.NEXT_PROTOCOL, "nextProtocol");
        }
    }

    static class DefaultResourceOption<T>
    extends ResourceOption<T> {
        static final Map<String, ResourceOption<?>> OPTIONS = new HashMap();
        private final Kind kind;

        private DefaultResourceOption(Kind kind, String name) {
            this(kind, name, null);
        }

        private DefaultResourceOption(Kind kind, String name, T defaultValue) {
            super(OPTIONS, name, defaultValue);
            this.kind = kind;
        }

        static enum Kind {
            NEXT_PROTOCOL,
            TRANSPORT,
            TRANSPORT_URI,
            ALTERNATE,
            RESOLVER,
            BIND_ALTERNATE,
            QUALIFIER,
            TRANSPORTED_URI,
            CONNECT_REQUIRES_INIT;

        }
    }
}

