/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.util.Map;

public abstract class ResourceOption<V> {
    private final String name;
    private final V defaultValue;

    protected ResourceOption(Map<String, ResourceOption<?>> optionNames, String name) {
        this(optionNames, name, null);
    }

    protected ResourceOption(Map<String, ResourceOption<?>> optionNames, String name, V defaultValue) {
        if (optionNames.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Duplicate option '%s'", name));
        }
        this.name = name;
        this.defaultValue = defaultValue;
        optionNames.put(name, this);
    }

    public String name() {
        return this.name;
    }

    public V defaultValue() {
        return this.defaultValue;
    }

    public V resolveValue(V value) {
        return value != null ? value : this.defaultValue;
    }

    public String toString() {
        return this.name;
    }
}

