/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ResourceOptions;

public final class Comparators {
    private static final Comparator<String> STRING_COMPARATOR = Comparators.compareComparable(String.class);
    private static final Comparator<ResourceAddress> ORIGIN_COMPARATOR = Comparators.compareNonNull(new ResourceOriginComparator());
    private static final Comparator<ResourceAddress> LOCATION_COMPARATOR = Comparators.compareNonNull(new ResourceLocationComparator());
    private static final Comparator<ResourceAddress> PROTOCOL_STACK_COMPARATOR = Comparators.compareNonNull(new ResourceProtocolStackComparator());
    private static final Comparator<ResourceAddress> ORIGIN_AND_PROTOCOL_STACK_COMPARATOR = new ResourceOriginAndProtocolStackComparator();
    private static final Comparator<ResourceAddress> LOCATION_AND_TRANSPORT_PROTOCOL_STACK_COMPARATOR = Comparators.compareNonNull(new ResourceLocationAndTransportProtocolStackComparator());
    private static final Comparator<ResourceAddress> ORIGIN_PATH_ALTERNATES_AND_PROTOCOL_STACK_COMPARATOR = Comparators.compareAlternates(new ResourceOriginPathAndProtocolStackComparator());
    private static final Comparator<ResourceAddress> ORIGIN_PATH_AND_PROTOCOL_STACK_COMPARATOR = Comparators.compareNonNull(new ResourceOriginPathAndProtocolStackComparator());
    private static final Comparator<ResourceAddress> TRANSPORT_PROTOCOL_STACK_AND_TRANSPORTED_URI_COMPARATOR = Comparators.compareNonNull(new TransportProtocolStackAndTransportedURIComparator());
    private static final Comparator<URI> TRANSPORTED_URI_COMPARATOR = Comparators.compareNonNull(new TransportedURIComparator());

    public static Comparator<String> stringComparator() {
        return STRING_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceOrigin() {
        return ORIGIN_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceLocation() {
        return LOCATION_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceProtocolStack() {
        return PROTOCOL_STACK_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceOriginAndProtocolStack() {
        return ORIGIN_AND_PROTOCOL_STACK_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceOriginPathAndProtocolStack() {
        return ORIGIN_PATH_AND_PROTOCOL_STACK_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceOriginPathAlternatesAndProtocolStack() {
        return ORIGIN_PATH_ALTERNATES_AND_PROTOCOL_STACK_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareResourceLocationAndTransportProtocolStack() {
        return LOCATION_AND_TRANSPORT_PROTOCOL_STACK_COMPARATOR;
    }

    public static Comparator<ResourceAddress> compareTransportProtocolStackAndTransportedURI() {
        return TRANSPORT_PROTOCOL_STACK_AND_TRANSPORTED_URI_COMPARATOR;
    }

    public static <T> Comparator<T> compareNonNull(Comparator<T> comparator) {
        return new NonNullComparator<T>(comparator);
    }

    public static <T extends Comparable<T>> Comparator<T> compareComparable(Class<T> clazz) {
        return Comparators.compareNonNull(new ComparableComparator());
    }

    public static Comparator<ResourceAddress> compareAlternates(Comparator<ResourceAddress> comparator) {
        return Comparators.compareNonNull(new AlternateResourceAddressComparator(comparator));
    }

    private static final class TransportProtocolStackAndTransportedURIComparator
    implements Comparator<ResourceAddress> {
        private TransportProtocolStackAndTransportedURIComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            URI transportedURI1 = addr1.getOption(ResourceAddress.TRANSPORTED_URI);
            URI transportedURI2 = addr2.getOption(ResourceAddress.TRANSPORTED_URI);
            int compareTransportedURI = TRANSPORTED_URI_COMPARATOR.compare(transportedURI1, transportedURI2);
            if (compareTransportedURI != 0) {
                return compareTransportedURI;
            }
            ResourceAddress transport1 = addr1.getOption(ResourceAddress.TRANSPORT);
            ResourceAddress transport2 = addr2.getOption(ResourceAddress.TRANSPORT);
            int compareTransport = PROTOCOL_STACK_COMPARATOR.compare(transport1, transport2);
            if (compareTransport != 0) {
                return compareTransport;
            }
            return 0;
        }
    }

    private static final class TransportedURIComparator
    implements Comparator<URI> {
        private TransportedURIComparator() {
        }

        @Override
        public int compare(URI uri1, URI uri2) {
            return uri1.compareTo(uri2);
        }
    }

    private static final class ResourceLocationAndTransportProtocolStackComparator
    implements Comparator<ResourceAddress> {
        private ResourceLocationAndTransportProtocolStackComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            int compareLocation = LOCATION_COMPARATOR.compare(addr1, addr2);
            if (compareLocation != 0) {
                return compareLocation;
            }
            ResourceAddress transport1 = addr1.getOption(ResourceAddress.TRANSPORT);
            ResourceAddress transport2 = addr2.getOption(ResourceAddress.TRANSPORT);
            int compareTransport = PROTOCOL_STACK_COMPARATOR.compare(transport1, transport2);
            if (compareTransport != 0) {
                return compareTransport;
            }
            return 0;
        }
    }

    private static final class ResourceOriginPathAndProtocolStackComparator
    implements Comparator<ResourceAddress> {
        private ResourceOriginPathAndProtocolStackComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            int compareOrigin = ORIGIN_COMPARATOR.compare(addr1, addr2);
            if (compareOrigin != 0) {
                return compareOrigin;
            }
            int compareURI = STRING_COMPARATOR.compare(addr1.getResource().getPath(), addr2.getResource().getPath());
            if (compareURI != 0) {
                return compareURI;
            }
            int compareProtocol = STRING_COMPARATOR.compare(addr1.getOption(ResourceAddress.NEXT_PROTOCOL), addr2.getOption(ResourceAddress.NEXT_PROTOCOL));
            if (compareProtocol != 0) {
                return compareProtocol;
            }
            ResourceAddress transport1 = addr1.getOption(ResourceAddress.TRANSPORT);
            ResourceAddress transport2 = addr2.getOption(ResourceAddress.TRANSPORT);
            int compareTransport = ORIGIN_PATH_AND_PROTOCOL_STACK_COMPARATOR.compare(transport1, transport2);
            if (compareTransport != 0) {
                return compareTransport;
            }
            return 0;
        }
    }

    private static final class AlternateResourceAddressComparator
    implements Comparator<ResourceAddress> {
        private final Comparator<ResourceAddress> delegate;
        static ResourceAddressFactory addressFactory = ResourceAddressFactory.newResourceAddressFactory();

        private AlternateResourceAddressComparator(Comparator<ResourceAddress> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            List<ResourceAddress> addresses1 = this.asResourceAddressList(addr1);
            List<ResourceAddress> addresses2 = this.asResourceAddressList(addr2);
            for (ResourceAddress anAddress1 : addresses1) {
                for (ResourceAddress anAddress2 : addresses2) {
                    int result = this.delegate.compare(anAddress1, anAddress2);
                    if (result != 0) continue;
                    return result;
                }
            }
            return this.delegate.compare(addr1, addr2);
        }

        private List<ResourceAddress> asResourceAddressList(ResourceAddress addr) {
            ArrayList<ResourceAddress> result = new ArrayList<ResourceAddress>();
            ArrayList<ResourceAddress> topLevelAddresses = new ArrayList<ResourceAddress>();
            ResourceAddress cursor = addr;
            do {
                topLevelAddresses.add(cursor);
            } while ((cursor = cursor.getOption(ResourceAddress.ALTERNATE)) != null);
            for (ResourceAddress resourceAddress : topLevelAddresses) {
                ResourceAddress transport = resourceAddress.getTransport();
                if (transport != null) {
                    for (ResourceAddress transportAddress : this.asResourceAddressList(transport)) {
                        ResourceOptions newResultOptions = ResourceOptions.FACTORY.newResourceOptions(resourceAddress);
                        newResultOptions.setOption(ResourceAddress.TRANSPORT, transportAddress);
                        ResourceAddress newResult = addressFactory.newResourceAddress(resourceAddress.getExternalURI(), newResultOptions);
                        result.add(newResult);
                    }
                    continue;
                }
                result.add(resourceAddress);
            }
            return result;
        }
    }

    private static final class ResourceOriginAndProtocolStackComparator
    implements Comparator<ResourceAddress> {
        private ResourceOriginAndProtocolStackComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            int compareOrigin = ORIGIN_COMPARATOR.compare(addr1, addr2);
            if (compareOrigin != 0) {
                return compareOrigin;
            }
            int compareNextProtocol = PROTOCOL_STACK_COMPARATOR.compare(addr1, addr2);
            if (compareNextProtocol != 0) {
                return compareNextProtocol;
            }
            return 0;
        }
    }

    private static final class ResourceProtocolStackComparator
    implements Comparator<ResourceAddress> {
        private ResourceProtocolStackComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            String protocol1 = addr1.getOption(ResourceAddress.NEXT_PROTOCOL);
            String protocol2 = addr2.getOption(ResourceAddress.NEXT_PROTOCOL);
            int compareProtocol = STRING_COMPARATOR.compare(protocol1, protocol2);
            if (compareProtocol != 0) {
                return compareProtocol;
            }
            ResourceAddress transport1 = addr1.getOption(ResourceAddress.TRANSPORT);
            ResourceAddress transport2 = addr2.getOption(ResourceAddress.TRANSPORT);
            int compareTransport = PROTOCOL_STACK_COMPARATOR.compare(transport1, transport2);
            if (compareTransport != 0) {
                return compareTransport;
            }
            return 0;
        }
    }

    private static final class ResourceLocationComparator
    implements Comparator<ResourceAddress> {
        private ResourceLocationComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            URI location1 = addr1.getResource();
            URI location2 = addr2.getResource();
            assert (location1 != null);
            assert (location2 != null);
            return location1.compareTo(location2);
        }
    }

    private static final class ResourceOriginComparator
    implements Comparator<ResourceAddress> {
        private ResourceOriginComparator() {
        }

        @Override
        public int compare(ResourceAddress addr1, ResourceAddress addr2) {
            URI location1 = addr1.getResource();
            URI location2 = addr2.getResource();
            assert (location1 != null);
            assert (location2 != null);
            String scheme1 = location1.getScheme();
            String scheme2 = location2.getScheme();
            int compareScheme = STRING_COMPARATOR.compare(scheme1, scheme2);
            if (compareScheme != 0) {
                return compareScheme;
            }
            String authority1 = location1.getAuthority();
            String authority2 = location2.getAuthority();
            int compareAuthority = STRING_COMPARATOR.compare(authority1, authority2);
            if (compareAuthority != 0) {
                return compareAuthority;
            }
            return 0;
        }
    }

    private static final class NonNullComparator<T>
    implements Comparator<T> {
        private final Comparator<T> delegate;

        public NonNullComparator(Comparator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public final int compare(T o1, T o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return this.delegate.compare(o1, o2);
        }
    }

    private static final class ComparableComparator<T extends Comparable<T>>
    implements Comparator<T> {
        private ComparableComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    }
}

