/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.resource.address;

import java.net.URI;
import org.kaazing.gateway.resource.address.ResourceFactory;
import org.kaazing.gateway.resource.address.URLUtils;

public class ResourceFactories {
    private ResourceFactories() {
    }

    public static ResourceFactory keepAuthorityOnly(String newScheme) {
        return new KeepAuthorityOnlyTransportFactory(newScheme);
    }

    public static ResourceFactory changeSchemeOnly(String newScheme) {
        return new ChangeSchemeOnlyTransportFactory(newScheme);
    }

    private static final class ChangeSchemeOnlyTransportFactory
    extends ResourceFactory {
        private final String newScheme;

        public ChangeSchemeOnlyTransportFactory(String newScheme) {
            this.newScheme = newScheme;
        }

        @Override
        public URI createURI(URI location) {
            return URLUtils.modifyURIScheme(location, this.newScheme);
        }
    }

    private static final class KeepAuthorityOnlyTransportFactory
    extends ResourceFactory {
        private final String newScheme;

        public KeepAuthorityOnlyTransportFactory(String newScheme) {
            this.newScheme = newScheme;
        }

        @Override
        public URI createURI(URI location) {
            return URI.create(String.format("%s://%s", this.newScheme, location.getAuthority()));
        }
    }
}

