/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.filter;

import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.filter.ManagementFilterStrategy;
import org.kaazing.gateway.management.filter.ServiceOnlyManagementFilterStrategy;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.mina.core.session.IoSessionEx;

public class FullManagementFilterStrategy
extends ServiceOnlyManagementFilterStrategy {
    public static final AttributeKey SESSION_BEAN_ATTRIBUTE_KEY = new AttributeKey(ManagementFilterStrategy.class, "managementSessionBean");

    @Override
    public void doSessionCreated(ManagementContext managementContext, ServiceManagementBean serviceBean, IoSessionEx session, Utils.ManagementSessionType managementSessionType) throws Exception {
        SessionManagementBean sessionBean = managementContext.addSessionManagementBean(serviceBean, session);
        serviceBean.storeSessionManagementBean(sessionBean);
        managementContext.getManagementSessionStrategy().doSessionCreated(sessionBean);
        super.doSessionCreated(managementContext, serviceBean, session, managementSessionType);
    }

    @Override
    public void doSessionClosed(ManagementContext managementContext, ServiceManagementBean serviceBean, long sessionId, Utils.ManagementSessionType managementSessionType) throws Exception {
        SessionManagementBean sessionBean = serviceBean.removeSessionManagementBean(sessionId);
        if (sessionBean != null) {
            managementContext.getManagementSessionStrategy().doSessionClosed(sessionBean);
        }
        super.doSessionClosed(managementContext, serviceBean, sessionId, managementSessionType);
    }

    @Override
    public void doMessageReceived(ManagementContext managementContext, ServiceManagementBean serviceBean, long sessionId, long sessionBytesRead, Object message) throws Exception {
        SessionManagementBean sessionBean = serviceBean.getSessionManagementBean(sessionId);
        if (sessionBean != null) {
            managementContext.getManagementSessionStrategy().doMessageReceived(sessionBean, message);
        }
        super.doMessageReceived(managementContext, serviceBean, sessionId, sessionBytesRead, message);
    }

    @Override
    public void doFilterWrite(ManagementContext managementContext, ServiceManagementBean serviceBean, long sessionId, long sessionBytesWritten, WriteRequest writeRequest) throws Exception {
        SessionManagementBean sessionBean = serviceBean.getSessionManagementBean(sessionId);
        if (sessionBean != null) {
            managementContext.getManagementSessionStrategy().doFilterWrite(sessionBean, writeRequest);
        }
        super.doFilterWrite(managementContext, serviceBean, sessionId, sessionBytesWritten, writeRequest);
    }

    @Override
    public void doExceptionCaught(ManagementContext managementContext, ServiceManagementBean serviceBean, long sessionId, Throwable cause) throws Exception {
        SessionManagementBean sessionBean = serviceBean.getSessionManagementBean(sessionId);
        if (sessionBean != null) {
            managementContext.getManagementSessionStrategy().doExceptionCaught(sessionBean, cause);
        }
        super.doExceptionCaught(managementContext, serviceBean, sessionId, cause);
    }

    @Override
    public String toString() {
        return "FULL_FILTER_STRATEGY";
    }
}

