/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.gateway;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.util.CopyOnWriteMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.AbstractManagementBean;
import org.kaazing.gateway.management.ClusterManagementListener;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.gateway.GatewayManagementListener;
import org.kaazing.gateway.management.update.check.ManagementUpdateCheck;
import org.kaazing.gateway.management.update.check.ManagementUpdateCheckFactory;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.impl.VersionUtils;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.MemberId;
import org.kaazing.gateway.service.cluster.MembershipEventListener;
import org.kaazing.gateway.service.collections.CollectionsFactory;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayManagementBeanImpl
extends AbstractManagementBean
implements GatewayManagementBean,
MembershipEventListener,
EntryListener<MemberId, Collection<String>> {
    private static final Logger logger = LoggerFactory.getLogger(GatewayManagementBeanImpl.class);
    private final ThreadLocal<ThreadGatewayStats> gatewayStats = new VicariousThreadLocal<ThreadGatewayStats>(){

        protected ThreadGatewayStats initialValue() {
            ThreadGatewayStats stats = new ThreadGatewayStats();
            GatewayManagementBeanImpl.this.gatewayStatsMap.put((Object)Thread.currentThread(), (Object)stats);
            return stats;
        }
    };
    private final CopyOnWriteMap<Thread, ThreadGatewayStats> gatewayStatsMap = new CopyOnWriteMap();
    private final String hostAndPid;
    private GatewayContext gatewayContext;
    private String productTitle;
    private String productBuild;
    private String productEdition;
    private final long startTime;
    private ClusterContext clusterContext;
    private final List<ClusterManagementListener> clusterManagementListeners;
    private static final AtomicInteger maxGatewayIndex = new AtomicInteger(1);
    private final int id = maxGatewayIndex.getAndIncrement();
    private final ManagementUpdateCheck updateChecker;

    public GatewayManagementBeanImpl(ManagementContext managementContext, GatewayContext gatewayContext, String hostAndPid) {
        super(managementContext, managementContext.getGatewaySummaryDataNotificationInterval(), SUMMARY_DATA_FIELD_LIST);
        ManagementUpdateCheck updateCheckerLookup;
        this.hostAndPid = hostAndPid;
        this.startTime = System.currentTimeMillis();
        this.clusterManagementListeners = new ArrayList<ClusterManagementListener>();
        this.gatewayContext = gatewayContext;
        this.productTitle = VersionUtils.getGatewayProductTitle();
        this.productBuild = VersionUtils.getGatewayProductVersionBuild();
        this.productEdition = VersionUtils.getGatewayProductEdition();
        try {
            updateCheckerLookup = ManagementUpdateCheckFactory.newManagementUpdateCheckFactory().newUpdateCheck("http");
        }
        catch (IllegalArgumentException e) {
            updateCheckerLookup = null;
        }
        this.updateChecker = updateCheckerLookup;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getHostAndPid() {
        return this.hostAndPid;
    }

    @Override
    public String getProductTitle() {
        return this.productTitle;
    }

    @Override
    public String getProductBuild() {
        return this.productBuild;
    }

    @Override
    public String getProductEdition() {
        return this.productEdition;
    }

    @Override
    public long getTotalCurrentSessions() {
        long total = 0L;
        for (ThreadGatewayStats stats : this.gatewayStatsMap.values()) {
            total += stats.getTotalCurrentSessions();
        }
        return total;
    }

    @Override
    public long getTotalBytesReceived() {
        long total = 0L;
        for (ThreadGatewayStats stats : this.gatewayStatsMap.values()) {
            total += stats.getTotalBytesReceived();
        }
        return total;
    }

    @Override
    public long getTotalBytesSent() {
        long total = 0L;
        for (ThreadGatewayStats stats : this.gatewayStatsMap.values()) {
            total += stats.getTotalBytesSent();
        }
        return total;
    }

    @Override
    public long getTotalExceptions() {
        long total = 0L;
        for (ThreadGatewayStats stats : this.gatewayStatsMap.values()) {
            total += stats.getTotalExceptions();
        }
        return total;
    }

    @Override
    public long getUptime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getInstanceKey() {
        ClusterContext context = this.gatewayContext.getCluster();
        String instanceKey = context.getInstanceKey(context.getLocalMember());
        return instanceKey;
    }

    @Override
    public void setClusterContext(ClusterContext clusterContext) {
        this.clusterContext = clusterContext;
        if (clusterContext != null) {
            clusterContext.addMembershipEventListener((MembershipEventListener)this);
        }
    }

    @Override
    public String getClusterMembers() {
        if (this.clusterContext == null) {
            return "";
        }
        CollectionsFactory factory = this.clusterContext.getCollectionsFactory();
        Collection memberIds = this.clusterContext.getMemberIds();
        IMap memberIdBalancerMap = factory.getMap("memberIdBalancerMap");
        JSONObject jsonObj = new JSONObject();
        try {
            for (MemberId memberId : memberIds) {
                String instanceKey = this.clusterContext.getInstanceKey(memberId);
                Map balancerURIMap = (Map)memberIdBalancerMap.get(memberId);
                if (balancerURIMap != null) {
                    JSONObject uriMap = new JSONObject();
                    for (String balancerURI : balancerURIMap.keySet()) {
                        List balanceeURIs = (List)balancerURIMap.get(balancerURI);
                        JSONArray jsonArray = new JSONArray();
                        for (String balanceeURI : balanceeURIs) {
                            jsonArray.put((Object)balanceeURI);
                        }
                        uriMap.put(balancerURI, (Object)jsonArray);
                    }
                    jsonObj.put(instanceKey, (Object)uriMap);
                    continue;
                }
                jsonObj.put(instanceKey, JSONObject.NULL);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException("Error inserting balancer URIs for cluster members into JSON object");
        }
        return jsonObj.toString();
    }

    @Override
    public String getManagementServiceMap() {
        if (this.clusterContext == null) {
            return "";
        }
        CollectionsFactory factory = this.clusterContext.getCollectionsFactory();
        IMap managementServices = factory.getMap("managementServiceMap");
        if (managementServices == null || managementServices.isEmpty()) {
            return "";
        }
        JSONObject jsonObj = new JSONObject();
        try {
            for (MemberId member : managementServices.keySet()) {
                String instanceKey = this.clusterContext.getInstanceKey(member);
                JSONArray jsonArray = new JSONArray();
                Collection acceptURIs = (Collection)managementServices.get(member);
                if (acceptURIs != null) {
                    for (String acceptURI : acceptURIs) {
                        jsonArray.put((Object)acceptURI);
                    }
                }
                jsonObj.put(instanceKey, (Object)jsonArray);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException("Error inserting acceptURIs for management services into JSON array");
        }
        return jsonObj.toString();
    }

    @Override
    public String getClusterBalancerMap() {
        if (this.clusterContext == null) {
            return "";
        }
        CollectionsFactory factory = this.clusterContext.getCollectionsFactory();
        IMap balancers = factory.getMap("balancerMap");
        if (balancers == null || balancers.isEmpty()) {
            return "";
        }
        JSONObject jsonObj = new JSONObject();
        try {
            for (String uri : balancers.keySet()) {
                Collection balancees = (Collection)balancers.get(uri);
                if (balancees != null && balancees.size() > 0) {
                    JSONArray jsonArray = new JSONArray();
                    for (String balanceeURI : balancees) {
                        jsonArray.put((Object)balanceeURI);
                    }
                    jsonObj.put(uri, (Object)jsonArray);
                    continue;
                }
                jsonObj.put(uri, JSONObject.NULL);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException("Error inserting balanceeURIs for balancerURIs into JSON array");
        }
        return jsonObj.toString();
    }

    @Override
    public void addClusterManagementListener(ClusterManagementListener listener) {
        listener.setGatewayBean(this);
        this.clusterManagementListeners.add(listener);
    }

    @Override
    public String getSummaryData() {
        JSONArray jsonArray = null;
        try {
            Object[] vals = new Object[SUMMARY_DATA_FIELD_LIST.length];
            vals[0] = 0L;
            vals[1] = 0L;
            vals[2] = 0L;
            vals[3] = 0L;
            for (ThreadGatewayStats stats : this.gatewayStatsMap.values()) {
                stats.collectSummaryValues(vals);
            }
            jsonArray = new JSONArray((Object)vals);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonArray.toString();
    }

    private List<GatewayManagementListener> getManagementListeners() {
        return this.managementContext.getGatewayManagementListeners();
    }

    public void memberAdded(MemberId newMember) {
    }

    public void memberRemoved(MemberId removedMember) {
        CollectionsFactory factory = this.clusterContext.getCollectionsFactory();
        IMap managementServiceUriMap = factory.getMap("managementServiceMap");
        managementServiceUriMap.remove(removedMember);
    }

    public void entryAdded(EntryEvent<MemberId, Collection<String>> event) {
        MemberId memberId = (MemberId)event.getKey();
        String instanceKey = this.clusterContext.getInstanceKey(memberId);
        for (ClusterManagementListener listener : this.clusterManagementListeners) {
            listener.managementServicesChanged("add", instanceKey, (Collection)event.getValue());
        }
    }

    public void entryEvicted(EntryEvent<MemberId, Collection<String>> event) {
    }

    public void entryRemoved(EntryEvent<MemberId, Collection<String>> event) {
    }

    public void entryUpdated(EntryEvent<MemberId, Collection<String>> event) {
    }

    public void mapCleared(MapEvent event) {
    }

    public void mapEvicted(MapEvent event) {
    }

    @Override
    public void doSessionCreated(long sessionId, Utils.ManagementSessionType managementSessionType) throws Exception {
        ThreadGatewayStats stats = this.gatewayStats.get();
        stats.doSessionCreated();
    }

    @Override
    public void doSessionCreatedListeners(final long sessionId, Utils.ManagementSessionType managementSessionType) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (GatewayManagementListener listener : GatewayManagementBeanImpl.this.getManagementListeners()) {
                        listener.doSessionCreated(GatewayManagementBeanImpl.this, sessionId);
                    }
                    GatewayManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during sessionCreated gateway listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doSessionClosed(long sessionId, Utils.ManagementSessionType managementSessionType) throws Exception {
        ThreadGatewayStats stats = this.gatewayStats.get();
        stats.doSessionClosed();
    }

    @Override
    public void doSessionClosedListeners(final long sessionId, Utils.ManagementSessionType managementSessionType) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (GatewayManagementListener listener : GatewayManagementBeanImpl.this.getManagementListeners()) {
                        listener.doSessionClosed(GatewayManagementBeanImpl.this, sessionId);
                    }
                    GatewayManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during sessionClosed gateway listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doMessageReceived(long sessionId, long sessionReadBytes, Object message) throws Exception {
        if (message instanceof ByteBuffer) {
            ThreadGatewayStats stats = this.gatewayStats.get();
            stats.doMessageReceived((IoBuffer)message);
        }
    }

    @Override
    public void doMessageReceivedListeners(final long sessionId, long sessionReadBytes, Object message) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (GatewayManagementListener listener : GatewayManagementBeanImpl.this.getManagementListeners()) {
                        listener.doMessageReceived(GatewayManagementBeanImpl.this, sessionId);
                    }
                    GatewayManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during messageReceived gateway listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doFilterWrite(long sessionId, long sessionWrittenBytes, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof IoBuffer) {
            ThreadGatewayStats stats = this.gatewayStats.get();
            stats.doFilterWrite((IoBuffer)message);
        }
    }

    @Override
    public void doFilterWriteListeners(final long sessionId, long sessionWrittenBytes, WriteRequest writeRequest) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (GatewayManagementListener listener : GatewayManagementBeanImpl.this.getManagementListeners()) {
                        listener.doFilterWrite(GatewayManagementBeanImpl.this, sessionId);
                    }
                    GatewayManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during filterWrite gateway listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void doExceptionCaught(long sessionId, Throwable cause) throws Exception {
        ThreadGatewayStats stats = this.gatewayStats.get();
        stats.doExceptionCaught();
    }

    @Override
    public void doExceptionCaughtListeners(final long sessionId, Throwable cause) {
        this.runManagementTask(new Runnable(){

            @Override
            public void run() {
                try {
                    for (GatewayManagementListener listener : GatewayManagementBeanImpl.this.getManagementListeners()) {
                        listener.doExceptionCaught(GatewayManagementBeanImpl.this, sessionId);
                    }
                    GatewayManagementBeanImpl.this.markChanged();
                }
                catch (Exception ex) {
                    logger.warn("Error during exceptionCaught gateway listener notifications:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public String getAvailableUpdateVersion() {
        String version = "";
        if (this.updateChecker != null) {
            version = this.updateChecker.getAvailableUpdateVersion();
        }
        return version;
    }

    @Override
    public ManagementUpdateCheck getUpdateCheck() {
        return this.updateChecker;
    }

    @Override
    public void forceUpdateVersionCheck() {
        if (this.updateChecker != null) {
            this.updateChecker.checkForUpdate();
        }
    }

    private class ThreadGatewayStats {
        private long totalCurrentSessions;
        private long totalBytesReceived;
        private long totalBytesSent;
        private long totalExceptions;

        private ThreadGatewayStats() {
        }

        public long doSessionCreated() {
            ++this.totalCurrentSessions;
            return this.totalCurrentSessions;
        }

        public long doSessionClosed() {
            --this.totalCurrentSessions;
            return this.totalCurrentSessions;
        }

        public long doMessageReceived(IoBuffer buf) {
            this.totalBytesReceived += (long)buf.remaining();
            return this.totalBytesReceived;
        }

        public long doFilterWrite(IoBuffer buf) {
            this.totalBytesSent += (long)buf.remaining();
            return this.totalBytesSent;
        }

        public long doExceptionCaught() {
            ++this.totalExceptions;
            return this.totalExceptions;
        }

        public long getTotalCurrentSessions() {
            return this.totalCurrentSessions;
        }

        public long getTotalBytesReceived() {
            return this.totalBytesReceived;
        }

        public long getTotalBytesSent() {
            return this.totalBytesSent;
        }

        public long getTotalExceptions() {
            return this.totalExceptions;
        }

        public void collectSummaryValues(Object[] vals) {
            vals[0] = (Long)vals[0] + this.totalCurrentSessions;
            vals[1] = (Long)vals[1] + this.totalBytesReceived;
            vals[2] = (Long)vals[2] + this.totalBytesSent;
            vals[3] = (Long)vals[3] + this.totalExceptions;
            vals[4] = GatewayManagementBeanImpl.this.getAvailableUpdateVersion();
        }
    }
}

