/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.config;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kaazing.gateway.management.config.RealmConfigurationBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.security.RealmContext;

public class RealmConfigurationBeanImpl
implements RealmConfigurationBean {
    private final RealmContext realm;
    private final GatewayManagementBean gatewayBean;
    private final int id;
    private static final AtomicInteger staticIdCounter = new AtomicInteger(0);

    public RealmConfigurationBeanImpl(RealmContext realm, GatewayManagementBean gatewayBean) {
        this.realm = realm;
        this.gatewayBean = gatewayBean;
        this.id = staticIdCounter.incrementAndGet();
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayBean;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getAuthorizationMode() {
        return this.realm.getAuthenticationContext() == null ? null : this.realm.getAuthenticationContext().getAuthorizationMode();
    }

    @Override
    public String getSessionTimeout() {
        return this.realm.getAuthenticationContext() == null ? null : this.realm.getAuthenticationContext().getSessionTimeout();
    }

    @Override
    public String getLoginModules() {
        Configuration configuration = this.realm.getConfiguration();
        AppConfigurationEntry[] appConfigEntries = configuration.getAppConfigurationEntry(this.realm.getName());
        JSONArray jsonArray = new JSONArray();
        try {
            for (AppConfigurationEntry appConfigEntry : appConfigEntries) {
                String loginModuleName = appConfigEntry.getLoginModuleName();
                AppConfigurationEntry.LoginModuleControlFlag flag = appConfigEntry.getControlFlag();
                Map<String, ?> options = appConfigEntry.getOptions();
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("type", (Object)loginModuleName);
                String successVal = flag.toString();
                successVal = successVal.substring(successVal.indexOf(" ") + 1);
                jsonObj.put("success", (Object)successVal.toLowerCase());
                if (options != null && !options.isEmpty()) {
                    jsonObj.put("options", options);
                }
                jsonArray.put((Object)jsonObj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonArray.toString();
    }

    @Override
    public String getDescription() {
        return this.realm.getDescription();
    }

    @Override
    public String getHTTPChallengeScheme() {
        return this.realm.getAuthenticationContext() == null ? null : this.realm.getAuthenticationContext().getHttpChallengeScheme();
    }

    @Override
    public String getHTTPCookieNames() {
        return this.makeJSONArray(this.realm.getAuthenticationContext() == null ? null : this.realm.getAuthenticationContext().getHttpCookieNames());
    }

    @Override
    public String getHTTPHeaders() {
        return this.makeJSONArray(this.realm.getAuthenticationContext() == null ? null : this.realm.getAuthenticationContext().getHttpHeaders());
    }

    @Override
    public String getHTTPQueryParameters() {
        return this.makeJSONArray(this.realm.getAuthenticationContext() == null ? null : this.realm.getAuthenticationContext().getHttpQueryParameters());
    }

    @Override
    public String getName() {
        return this.realm.getName();
    }

    @Override
    public String getUserPrincipalClasses() {
        return this.makeJSONArray(this.realm.getUserPrincipalClasses());
    }

    public String makeJSONArray(String[] strArray) {
        if (strArray == null) {
            return null;
        }
        try {
            JSONArray jsonArray = new JSONArray((Object)strArray);
            return jsonArray.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

