/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import java.util.ArrayList;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Uptime;
import org.kaazing.gateway.management.system.SystemDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigarSystemDataProvider
implements SystemDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(SigarSystemDataProvider.class);
    private Sigar sigar = new Sigar();
    private boolean nicErrorShown;

    @Override
    public int getNumberOfCpus() {
        try {
            CpuInfo[] cpuInfo = this.sigar.getCpuInfoList();
            return cpuInfo.length;
        }
        catch (Throwable t) {
            return 1;
        }
    }

    @Override
    public double getCombinedCpuPercentage() {
        try {
            return this.sigar.getCpuPerc().getCombined();
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    @Override
    public long getTotalFreeMemory() {
        try {
            Mem mem = this.sigar.getMem();
            return mem.getFree();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public long getTotalUsedMemory() {
        try {
            Mem mem = this.sigar.getMem();
            return mem.getUsed();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public long getTotalMemory() {
        try {
            Mem mem = this.sigar.getMem();
            return mem.getTotal();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public long getTotalFreeSwap() {
        try {
            Swap swap = this.sigar.getSwap();
            return swap.getFree();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public long getTotalUsedSwap() {
        try {
            Swap swap = this.sigar.getSwap();
            return swap.getUsed();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public long getTotalSwap() {
        try {
            Swap swap = this.sigar.getSwap();
            return swap.getTotal();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public String[] getNetInterfaceNames() {
        try {
            String[] names = this.sigar.getNetInterfaceList();
            boolean foundError = false;
            ArrayList<String> netInterfaceNames = new ArrayList<String>();
            for (String nicName : names) {
                if (nicName.contains(":")) continue;
                try {
                    this.sigar.getNetInterfaceStat(nicName);
                    netInterfaceNames.add(nicName);
                }
                catch (Exception ex) {
                    if (this.nicErrorShown) continue;
                    logger.warn("Caught SIGAR exception trying to get NIC stats for interface '" + nicName + "'. No data for that interface will be sent.");
                    foundError = true;
                }
            }
            if (foundError) {
                this.nicErrorShown = true;
            }
            String[] val = new String[netInterfaceNames.size()];
            for (int i = 0; i < netInterfaceNames.size(); ++i) {
                val[i] = (String)netInterfaceNames.get(i);
            }
            return val;
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    @Override
    public double getUptimeSeconds() {
        try {
            Uptime uptime = this.sigar.getUptime();
            return uptime.getUptime();
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    @Override
    public Long[] getNetInterfaceStats(String netInterfaceName) {
        try {
            NetInterfaceStat nicStat = this.sigar.getNetInterfaceStat(netInterfaceName);
            return new Long[]{nicStat.getRxBytes(), nicStat.getRxDropped(), nicStat.getRxErrors(), nicStat.getTxBytes(), nicStat.getTxDropped(), nicStat.getTxErrors()};
        }
        catch (Throwable t) {
            return new Long[]{0L, 0L, 0L, 0L, 0L, 0L};
        }
    }

    @Override
    public Double[][] getCpuPercentages() {
        try {
            CpuPerc[] cpuPercList = this.sigar.getCpuPercList();
            int numCpus = cpuPercList.length;
            Double[][] cpuData = new Double[numCpus][9];
            for (int i = 0; i < numCpus; ++i) {
                CpuPerc cpuPerc = cpuPercList[i];
                cpuData[i][0] = cpuPerc.getCombined() * 100.0;
                cpuData[i][1] = cpuPerc.getIdle() * 100.0;
                cpuData[i][2] = cpuPerc.getIrq() * 100.0;
                cpuData[i][3] = cpuPerc.getNice() * 100.0;
                cpuData[i][4] = cpuPerc.getSoftIrq() * 100.0;
                cpuData[i][5] = cpuPerc.getStolen() * 100.0;
                cpuData[i][6] = cpuPerc.getSys() * 100.0;
                cpuData[i][7] = cpuPerc.getUser() * 100.0;
                cpuData[i][8] = cpuPerc.getWait() * 100.0;
            }
            return cpuData;
        }
        catch (Throwable t) {
            Double[][] cpuData = new Double[1][9];
            cpuData[0] = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            return cpuData;
        }
    }
}

