/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hyperic.sigar.SigarException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.AbstractManagementBean;
import org.kaazing.gateway.management.SummaryManagementInterval;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.system.ManagementSystemStrategy;
import org.kaazing.gateway.management.system.SystemManagementBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSystemManagementBean
extends AbstractManagementBean
implements SystemManagementBean {
    private final String dataTypeStr;
    private final ArrayBlockingQueue<JSONObject> summaryDataList;
    private boolean notificationsEnabled;
    protected boolean errorShown;
    private SummaryManagementInterval gatherInterval;
    private String schedulerName;
    private ScheduledExecutorService gatherScheduler;
    private ScheduledFuture gatherSchedulerFuture;
    private static final Logger logger = LoggerFactory.getLogger(AbstractSystemManagementBean.class);

    public AbstractSystemManagementBean(ManagementContext managementContext, SummaryManagementInterval summaryInterval, String[] summaryDataFields, SummaryManagementInterval gatherInterval, String dataTypeStr, int summaryDataLimit, String schedulerName) {
        super(managementContext, summaryInterval, summaryDataFields);
        this.dataTypeStr = dataTypeStr;
        this.summaryDataList = summaryDataLimit > 0 ? new ArrayBlockingQueue(summaryDataLimit) : null;
        this.schedulerName = schedulerName;
        this.gatherInterval = gatherInterval;
        managementContext.addManagementStrategyChangeListener(this);
    }

    public ScheduledExecutorService getGatherScheduler() {
        if (this.gatherScheduler == null) {
            this.gatherScheduler = this.getSchedulerProvider().getScheduler(this.schedulerName, false);
        }
        return this.gatherScheduler;
    }

    @Override
    public String getSummaryData() {
        JSONArray jsonArray = new JSONArray();
        if (this.summaryDataList != null) {
            ArrayList tmpList = new ArrayList(this.summaryDataList.size());
            this.summaryDataList.drainTo(tmpList);
            for (JSONObject jsonObject : tmpList) {
                jsonArray.put((Object)jsonObject);
            }
        }
        return jsonArray.toString();
    }

    @Override
    public void enableNotifications(boolean notificationsEnabled) {
        this.notificationsEnabled = notificationsEnabled;
    }

    @Override
    public boolean areNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    @Override
    public final int getSummaryDataGatherInterval() {
        return this.gatherInterval.getInterval();
    }

    @Override
    public final void setSummaryDataGatherInterval(int interval) {
        this.gatherInterval.setInterval(interval);
    }

    @Override
    public void managementStrategyChanged() {
        ManagementSystemStrategy systemStrategy = this.managementContext.getManagementSystemStrategy();
        systemStrategy.gatherStats(this);
    }

    public void gatherStats() {
        this.managementContext.runManagementTask(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        long readTime = System.currentTimeMillis();
                        JSONObject jsonObj = new JSONObject();
                        AbstractSystemManagementBean.this.doGatherStats(jsonObj, readTime);
                        jsonObj.put("readTime", readTime);
                        if (AbstractSystemManagementBean.this.summaryDataList != null && !AbstractSystemManagementBean.this.summaryDataList.offer(jsonObj)) {
                            AbstractSystemManagementBean.this.summaryDataList.poll();
                            AbstractSystemManagementBean.this.summaryDataList.offer(jsonObj);
                        }
                    }
                    catch (SigarException ex) {
                        if (!AbstractSystemManagementBean.this.errorShown) {
                            logger.warn("Caught SIGAR exception trying to get " + AbstractSystemManagementBean.this.dataTypeStr, (Throwable)ex);
                            AbstractSystemManagementBean.this.errorShown = true;
                        }
                    }
                    catch (JSONException ex) {
                        if (!AbstractSystemManagementBean.this.errorShown) {
                            logger.warn("Caught JSON exception trying to get " + AbstractSystemManagementBean.this.dataTypeStr, (Throwable)ex);
                            AbstractSystemManagementBean.this.errorShown = true;
                        }
                    }
                    catch (Exception ex) {
                        if (AbstractSystemManagementBean.this.errorShown) break block7;
                        logger.warn("Caught unexpected exception trying to get " + AbstractSystemManagementBean.this.dataTypeStr, (Throwable)ex);
                        AbstractSystemManagementBean.this.errorShown = true;
                    }
                }
                AbstractSystemManagementBean.this.markChanged();
                ManagementSystemStrategy systemStrategy = AbstractSystemManagementBean.this.managementContext.getManagementSystemStrategy();
                systemStrategy.continueGatherStats(AbstractSystemManagementBean.this);
            }
        });
    }

    public void continueGatherStats() {
        this.gatherSchedulerFuture = this.getGatherScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                AbstractSystemManagementBean.this.gatherStats();
            }
        }, (long)this.getSummaryDataGatherInterval(), TimeUnit.MILLISECONDS);
    }

    public void stopGatherStats() {
        if (this.gatherSchedulerFuture != null) {
            if (!this.gatherSchedulerFuture.isDone()) {
                this.gatherSchedulerFuture.cancel(false);
            }
            this.gatherSchedulerFuture = null;
        }
    }

    public abstract void doGatherStats(JSONObject var1, long var2) throws SigarException, JSONException;
}

