/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.jmx;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.integration.jmx.IoSessionMBean;
import org.kaazing.gateway.management.jmx.JmxManagementServiceHandler;
import org.kaazing.gateway.management.jmx.ServiceMXBean;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementListener;
import org.kaazing.mina.core.session.DummySessionEx;

public final class JmxServiceManagementListener
extends NotificationBroadcasterSupport
implements ServiceManagementListener {
    private static final Executor executor;
    private JmxManagementServiceHandler managementServiceHandler;

    public JmxServiceManagementListener(JmxManagementServiceHandler managementServiceHandler) {
        super(executor);
        this.managementServiceHandler = managementServiceHandler;
    }

    @Override
    public void doSessionCreated(ServiceManagementBean serviceBean, long newCurrentSessionCount, long newTotalSessionCount) throws Exception {
        ServiceMXBean serviceMXBean = this.managementServiceHandler.getServiceMXBean(serviceBean.getId());
        long currentTime = System.currentTimeMillis();
        AttributeChangeNotification n = new AttributeChangeNotification(serviceMXBean, this.managementServiceHandler.nextNotificationSequenceNumber(), currentTime, "Sessions Count changed", "Sessions Count", "long", newCurrentSessionCount - 1L, newCurrentSessionCount);
        this.sendNotification(n);
        n = new AttributeChangeNotification(serviceMXBean, this.managementServiceHandler.nextNotificationSequenceNumber(), currentTime, "Cumulative sessions count changed", "Cumulative Sessions Count", "long", newTotalSessionCount - 1L, newTotalSessionCount);
        this.sendNotification(n);
    }

    @Override
    public void doSessionClosed(ServiceManagementBean serviceBean, long sessionId, long newCurrentSessionCount) throws Exception {
        ServiceMXBean serviceMXBean = this.managementServiceHandler.getServiceMXBean(serviceBean.getId());
        AttributeChangeNotification n = new AttributeChangeNotification(serviceMXBean, this.managementServiceHandler.nextNotificationSequenceNumber(), System.currentTimeMillis(), "Sessions Count changed", "Sessions Count", "long", newCurrentSessionCount + 1L, newCurrentSessionCount);
        this.sendNotification(n);
    }

    @Override
    public void doMessageReceived(ServiceManagementBean serviceBean, long sessionId, ByteBuffer message) throws Exception {
    }

    @Override
    public void doFilterWrite(ServiceManagementBean serviceBean, long sessionId, ByteBuffer writeMessage) throws Exception {
    }

    @Override
    public void doExceptionCaught(ServiceManagementBean serviceBean, long sessionId, String exceptionMessage) throws Exception {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "Number of sessions in Kaazing Enterprise Gateway has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    static {
        IoSessionMBean dummyBean = new IoSessionMBean((IoSession)new DummySessionEx());
        executor = Executors.newSingleThreadExecutor();
    }
}

