/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.system.CpuManagementBean;

public class CpuManagementBeanImpl
implements CpuManagementBean {
    public static final int ROUND_TO_PLACES = 4;
    private final int id;
    private Double[] cpuPercentages;

    public static double roundTo(double val, int places) {
        long temp = (long)(val * Math.pow(10.0, places));
        return (double)temp / Math.pow(10.0, places);
    }

    public CpuManagementBeanImpl(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public double getCombined() {
        return this.cpuPercentages[0];
    }

    @Override
    public double getIdle() {
        return this.cpuPercentages[1];
    }

    @Override
    public double getIrq() {
        return this.cpuPercentages[2];
    }

    @Override
    public double getNice() {
        return this.cpuPercentages[3];
    }

    @Override
    public double getSoftIrq() {
        return this.cpuPercentages[4];
    }

    @Override
    public double getStolen() {
        return this.cpuPercentages[5];
    }

    @Override
    public double getSys() {
        return this.cpuPercentages[6];
    }

    @Override
    public double getUser() {
        return this.cpuPercentages[7];
    }

    @Override
    public double getWait() {
        return this.cpuPercentages[8];
    }

    @Override
    public void update(Double[] cpuPercentages) {
        this.cpuPercentages = cpuPercentages;
    }

    @Override
    public String getSummaryData() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[0], CpuManagementBeanImpl.roundTo(this.getCombined(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[1], CpuManagementBeanImpl.roundTo(this.getIdle(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[2], CpuManagementBeanImpl.roundTo(this.getIrq(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[3], CpuManagementBeanImpl.roundTo(this.getNice(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[4], CpuManagementBeanImpl.roundTo(this.getSoftIrq(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[5], CpuManagementBeanImpl.roundTo(this.getStolen(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[6], CpuManagementBeanImpl.roundTo(this.getSys(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[7], CpuManagementBeanImpl.roundTo(this.getUser(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[8], CpuManagementBeanImpl.roundTo(this.getWait(), 4));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObj.toString();
    }

    @Override
    public Number[] getSummaryDataValues() {
        Number[] vals = new Number[SUMMARY_DATA_FIELD_LIST.length];
        vals[0] = CpuManagementBeanImpl.roundTo(this.getCombined(), 4);
        vals[1] = CpuManagementBeanImpl.roundTo(this.getIdle(), 4);
        vals[2] = CpuManagementBeanImpl.roundTo(this.getIrq(), 4);
        vals[3] = CpuManagementBeanImpl.roundTo(this.getNice(), 4);
        vals[4] = CpuManagementBeanImpl.roundTo(this.getSoftIrq(), 4);
        vals[5] = CpuManagementBeanImpl.roundTo(this.getStolen(), 4);
        vals[6] = CpuManagementBeanImpl.roundTo(this.getSys(), 4);
        vals[7] = CpuManagementBeanImpl.roundTo(this.getUser(), 4);
        vals[8] = CpuManagementBeanImpl.roundTo(this.getWait(), 4);
        return vals;
    }
}

