/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import org.hyperic.sigar.SigarException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.system.AbstractSystemManagementBean;
import org.kaazing.gateway.management.system.CpuListManagementBean;
import org.kaazing.gateway.management.system.CpuManagementBean;
import org.kaazing.gateway.management.system.CpuManagementBeanImpl;

public class CpuListManagementBeanImpl
extends AbstractSystemManagementBean
implements CpuListManagementBean {
    private final GatewayManagementBean gatewayManagementBean;
    private CpuManagementBean[] cpuManagementBeans;

    public CpuListManagementBeanImpl(GatewayManagementBean gatewayManagementBean, int summaryDataLimit) {
        super(gatewayManagementBean.getManagementContext(), gatewayManagementBean.getManagementContext().getSystemSummaryDataNotificationInterval(), CpuManagementBean.SUMMARY_DATA_FIELD_LIST, gatewayManagementBean.getManagementContext().getCpuListSummaryDataGatherInterval(), "CPU list stats", summaryDataLimit, "SNMPCpuListSummaryData");
        this.gatewayManagementBean = gatewayManagementBean;
        int numCpus = this.managementContext.getSystemDataProvider().getNumberOfCpus();
        this.cpuManagementBeans = new CpuManagementBean[numCpus];
        for (int i = 0; i < numCpus; ++i) {
            this.cpuManagementBeans[i] = new CpuManagementBeanImpl(i);
        }
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayManagementBean;
    }

    @Override
    public CpuManagementBean[] getCpuManagementBeans() {
        return this.cpuManagementBeans;
    }

    @Override
    public int getNumCpus() {
        return this.managementContext.getSystemDataProvider().getNumberOfCpus();
    }

    @Override
    public void doGatherStats(JSONObject jsonObj, long readTime) throws SigarException, JSONException {
        JSONArray cpuData = new JSONArray();
        Double[][] cpuPercentages = this.managementContext.getSystemDataProvider().getCpuPercentages();
        int numCpus = cpuPercentages.length;
        for (int i = 0; i < numCpus; ++i) {
            CpuManagementBean cpuBean = this.cpuManagementBeans[i];
            cpuBean.update(cpuPercentages[i]);
            cpuData.put((Object)cpuBean.getSummaryDataValues());
        }
        jsonObj.put("cpuData", (Object)cpuData);
        double total = 0.0;
        for (int i = 0; i < numCpus; ++i) {
            total += this.cpuManagementBeans[i].getCombined();
        }
        double cpuPercentage = total / (double)numCpus;
        jsonObj.put("cpuPercentage", CpuManagementBeanImpl.roundTo(cpuPercentage, 4));
    }
}

