/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.kaazing.gateway.management.jmx.JmxManagementServiceHandler;
import org.kaazing.gateway.management.jmx.SessionMXBean;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.management.session.SessionManagementListener;

public final class JmxSessionManagementListener
extends NotificationBroadcasterSupport
implements SessionManagementListener {
    private static final String SESSION_CREATED = "session.created";
    private static final String SESSION_CLOSED = "session.closed";
    private JmxManagementServiceHandler managementServiceHandler;

    public JmxSessionManagementListener(JmxManagementServiceHandler managementServiceHandler) {
        this.managementServiceHandler = managementServiceHandler;
    }

    @Override
    public void doSessionCreated(SessionManagementBean sessionBean) throws Exception {
        SessionMXBean sessionMxBean = this.managementServiceHandler.getSessionMXBean(sessionBean.getId());
        Map<String, String> userPrincipals = sessionBean.getUserPrincipalMap();
        if (userPrincipals != null) {
            HashMap<String, Map<String, String>> userData = new HashMap<String, Map<String, String>>();
            userData.put(sessionMxBean.getObjectName().toString(), userPrincipals);
            Notification n2 = new Notification(SESSION_CREATED, sessionMxBean, this.managementServiceHandler.nextNotificationSequenceNumber(), System.currentTimeMillis(), "Session Credentials Registered");
            n2.setUserData(userData);
            this.sendNotification(n2);
        }
    }

    @Override
    public void doSessionClosed(SessionManagementBean sessionBean) throws Exception {
        SessionMXBean sessionMxBean = this.managementServiceHandler.getSessionMXBean(sessionBean.getId());
        Map<String, String> userPrincipals = sessionBean.getUserPrincipalMap();
        if (userPrincipals != null) {
            HashMap<String, Map<String, String>> userData = new HashMap<String, Map<String, String>>();
            userData.put(sessionMxBean.getObjectName().toString(), userPrincipals);
            Notification n2 = new Notification(SESSION_CLOSED, sessionMxBean, this.managementServiceHandler.nextNotificationSequenceNumber(), System.currentTimeMillis(), "Session Credentials Deregistered");
            n2.setUserData(userData);
            this.sendNotification(n2);
        }
    }

    @Override
    public void doMessageReceived(SessionManagementBean sessionBean, Object message) throws Exception {
    }

    @Override
    public void doFilterWrite(SessionManagementBean sessionBean, Object message, Object originalMessage) throws Exception {
    }

    @Override
    public void doExceptionCaught(SessionManagementBean sessionBean, Throwable cause) {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] sessionCredentialsTypes = new String[]{SESSION_CREATED, SESSION_CLOSED};
        String sessionCredentialsClassName = Notification.class.getName();
        String sessionCredentialsDescription = "The objectName to login name mapping for authenticated sessions";
        MBeanNotificationInfo sessionCredentialsInfo = new MBeanNotificationInfo(sessionCredentialsTypes, sessionCredentialsClassName, sessionCredentialsDescription);
        return new MBeanNotificationInfo[]{sessionCredentialsInfo};
    }
}

