/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.transport.ManagementAddress;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;

public class ManagementTransport
implements TransportMapping {
    private static final Logger logger = LoggerFactory.getLogger(ManagementTransport.class);
    private final ManagementContext managementContext;
    private List<TransportListener> transportListeners = new ArrayList<TransportListener>();

    public ManagementTransport(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public void addMessageDispatcher(MessageDispatcher dispatcher) {
        this.addTransportListener((TransportListener)dispatcher);
    }

    public void addTransportListener(TransportListener transportListener) {
        this.transportListeners.add(transportListener);
    }

    public void close() throws IOException {
    }

    public Address getListenAddress() {
        return null;
    }

    public int getMaxInboundMessageSize() {
        return 0;
    }

    public Class getSupportedAddressClass() {
        return ManagementAddress.class;
    }

    public boolean isListening() {
        return true;
    }

    public void listen() throws IOException {
    }

    public void removeMessageDispatcher(MessageDispatcher dispatcher) {
        this.removeTransportListener((TransportListener)dispatcher);
    }

    public void removeTransportListener(TransportListener transportListener) {
        this.transportListeners.remove(transportListener);
    }

    public void sendMessage(Address address, final byte[] message) throws IOException {
        if (address instanceof ManagementAddress) {
            IoSessionEx session = ((ManagementAddress)address).getSession();
            if (logger.isTraceEnabled()) {
                logger.trace("#### ManagementTransport sending message with " + message.length + " bytes");
            }
            ByteBuffer b = ByteBuffer.wrap(message);
            IoBufferEx buf = session.getBufferAllocator().wrap(b);
            WriteFuture future = session.write((Object)buf);
            future.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture future) {
                    if (future.isWritten() && logger.isTraceEnabled()) {
                        String msg = "SNMP write operation completed, bytes written: " + message.length;
                        logger.trace(msg);
                    }
                }
            });
        }
    }

    public void processMessage(final ManagementAddress address, final ByteBuffer message) {
        for (final TransportListener listener : this.transportListeners) {
            this.managementContext.runManagementTask(new Runnable(){

                @Override
                public void run() {
                    listener.processMessage((TransportMapping)ManagementTransport.this, (Address)address, message);
                }
            });
        }
    }
}

