/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.kaazing.gateway.management.system.HostManagementBean;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SystemManagementMIB
implements MOGroup {
    private static final int OS_NAME_OPER = 1;
    private static final int UPTIME_SECONDS_OPER = 2;
    private static final int TOTAL_FREE_MEMORY_OPER = 3;
    private static final int TOTAL_USED_MEMORY_OPER = 4;
    private static final int TOTAL_MEMORY_OPER = 5;
    private static final int TOTAL_FREE_SWAP_OPER = 6;
    private static final int TOTAL_USED_SWAP_OPER = 7;
    private static final int TOTAL_SWAP_OPER = 8;
    private static final int CPU_PERCENTAGE_OPER = 9;
    private static final int SUMMARY_DATA_FIELDS_OPER = 30;
    private static final int SUMMARY_DATA_OPER = 31;
    private final ManagementContext managementContext;
    private SystemString osName;
    private SystemDouble uptimeSeconds;
    private SystemLong totalFreeMemory;
    private SystemLong totalUsedMemory;
    private SystemLong totalMemory;
    private SystemLong totalFreeSwap;
    private SystemLong totalUsedSwap;
    private SystemLong totalSwap;
    private SystemDouble cpuPercentage;
    private SystemString summaryDataFields;
    private SystemString summaryData;
    private MOScalar summaryDataNotificationInterval;
    private MOScalar summaryDataGatherInterval;
    private HostManagementBean bean;

    public SystemManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        this.createMO(factory);
    }

    private void createMO(MOFactory moFactory) {
        try {
            this.osName = new SystemString(MIBConstants.oidSystemOsName, moFactory.createAccess(9), (Variable)new OctetString(), 1);
            this.uptimeSeconds = new SystemDouble(MIBConstants.oidSystemUptimeSeconds, moFactory.createAccess(9), (Variable)new Counter64(), 2);
            this.totalFreeMemory = new SystemLong(MIBConstants.oidSystemTotalFreeMemory, moFactory.createAccess(9), (Variable)new Counter64(), 3);
            this.totalUsedMemory = new SystemLong(MIBConstants.oidSystemTotalUsedMemory, moFactory.createAccess(9), (Variable)new Counter64(), 4);
            this.totalMemory = new SystemLong(MIBConstants.oidSystemTotalMemory, moFactory.createAccess(9), (Variable)new Counter64(), 5);
            this.totalFreeSwap = new SystemLong(MIBConstants.oidSystemTotalFreeSwap, moFactory.createAccess(9), (Variable)new Counter64(), 6);
            this.totalUsedSwap = new SystemLong(MIBConstants.oidSystemTotalUsedSwap, moFactory.createAccess(9), (Variable)new Counter64(), 7);
            this.totalSwap = new SystemLong(MIBConstants.oidSystemTotalSwap, moFactory.createAccess(9), (Variable)new Counter64(), 8);
            this.cpuPercentage = new SystemDouble(MIBConstants.oidSystemCpuPercentage, moFactory.createAccess(9), (Variable)new Counter64(), 9);
            this.summaryDataFields = new SystemString(MIBConstants.oidSystemSummaryDataFields, moFactory.createAccess(9), (Variable)new OctetString(), 30);
            this.summaryData = new SystemString(MIBConstants.oidSystemSummaryData, moFactory.createAccess(9), (Variable)new OctetString(), 31);
            this.summaryDataNotificationInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getSystemSummaryDataNotificationInterval(), MIBConstants.oidSystemSummaryDataNotificationInterval);
            this.summaryDataGatherInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getSystemSummaryDataNotificationInterval(), MIBConstants.oidSystemSummaryDataGatherInterval);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.osName, context);
        server.register((ManagedObject)this.uptimeSeconds, context);
        server.register((ManagedObject)this.totalFreeMemory, context);
        server.register((ManagedObject)this.totalUsedMemory, context);
        server.register((ManagedObject)this.totalMemory, context);
        server.register((ManagedObject)this.totalFreeSwap, context);
        server.register((ManagedObject)this.totalUsedSwap, context);
        server.register((ManagedObject)this.totalSwap, context);
        server.register((ManagedObject)this.cpuPercentage, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryData, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
        server.register((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.osName, context);
        server.unregister((ManagedObject)this.uptimeSeconds, context);
        server.unregister((ManagedObject)this.totalFreeMemory, context);
        server.unregister((ManagedObject)this.totalUsedMemory, context);
        server.unregister((ManagedObject)this.totalMemory, context);
        server.unregister((ManagedObject)this.totalFreeSwap, context);
        server.unregister((ManagedObject)this.totalUsedSwap, context);
        server.unregister((ManagedObject)this.totalSwap, context);
        server.unregister((ManagedObject)this.cpuPercentage, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryData, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
        server.unregister((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void addSystemManagementBean(HostManagementBean systemManagementBean) {
        this.bean = systemManagementBean;
    }

    class SystemString
    extends MOScalar {
        private int operation;

        SystemString(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            String value;
            switch (this.operation) {
                case 1: {
                    value = SystemManagementMIB.this.bean.getOSName();
                    break;
                }
                case 30: {
                    value = SystemManagementMIB.this.bean.getSummaryDataFields();
                    break;
                }
                case 31: {
                    value = SystemManagementMIB.this.bean.getSummaryData();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemString incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            OctetString val = (OctetString)Utils.stringToVariable(value);
            return val;
        }
    }

    class SystemDouble
    extends MOScalar {
        private int operation;

        SystemDouble(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            double value;
            switch (this.operation) {
                case 2: {
                    value = SystemManagementMIB.this.bean.getUptimeSeconds();
                    break;
                }
                case 9: {
                    value = SystemManagementMIB.this.bean.getCpuPercentage();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemFloat incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            return new Counter64(Math.round(value * 1000.0));
        }
    }

    class SystemLong
    extends MOScalar {
        private int operation;

        SystemLong(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            long value;
            switch (this.operation) {
                case 3: {
                    value = SystemManagementMIB.this.bean.getTotalFreeMemory();
                    break;
                }
                case 4: {
                    value = SystemManagementMIB.this.bean.getTotalUsedMemory();
                    break;
                }
                case 5: {
                    value = SystemManagementMIB.this.bean.getTotalMemory();
                    break;
                }
                case 6: {
                    value = SystemManagementMIB.this.bean.getTotalFreeSwap();
                    break;
                }
                case 7: {
                    value = SystemManagementMIB.this.bean.getTotalUsedSwap();
                    break;
                }
                case 8: {
                    value = SystemManagementMIB.this.bean.getTotalSwap();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemLong incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            return new Counter64(value);
        }
    }
}

