/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.kaazing.gateway.management.system.JvmManagementBean;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class JVMManagementMIB
implements MOGroup {
    public static final OID oidSunEnterprise = new OID(new int[]{1, 3, 6, 1, 4, 1, 42});
    public static final OID oidJMgmt = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145});
    public static final OID oidJvmStandard = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3});
    public static final OID oidJvmManagementMIB = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1});
    public static final OID oidJvmMIBObjects = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1});
    public static final OID oidJvmMIBNotifications = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 2});
    public static final OID oidJvmMIBConformance = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 3});
    public static final OID oidJvmClassLoading = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 1});
    public static final OID oidJvmClassesLoadedCount = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 1, 1, 0});
    public static final OID oidJvmClassesTotalLoadedCount = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 1, 2, 0});
    public static final OID oidJvmClassesUnloadedCount = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 1, 3, 0});
    public static final OID oidJvmClassesVerboseLevel = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 1, 4, 0});
    public static final OID oidJvmMemory = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2});
    public static final OID oidJvmMemoryPendingFinalCount = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 1, 0});
    public static final OID oidJvmMemoryGCVerboseLevel = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 2, 0});
    public static final OID oidJvmMemoryGCCall = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 3, 0});
    public static final OID oidJvmMemoryHeapInitSize = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 10, 0});
    public static final OID oidJvmMemoryHeapUsed = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 11, 0});
    public static final OID oidJvmMemoryHeapCommitted = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 12, 0});
    public static final OID oidJvmMemoryHeapMaxSize = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 13, 0});
    public static final OID oidJvmMemoryNonHeapInitSize = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 20, 0});
    public static final OID oidJvmMemoryNonHeapUsed = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 21, 0});
    public static final OID oidJvmMemoryNonHeapCommitted = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 22, 0});
    public static final OID oidJvmMemoryNonHeapMaxSize = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 23, 0});
    public static final OID oidJvmMemoryManagerTable = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 100});
    public static final OID oidJvmMemoryManagerEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 100, 1});
    public static final OID oidJvmMemoryManagerIndex = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 100, 1, 1});
    public static final OID oidJvmMemoryManagerName = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 100, 1, 2});
    public static final OID oidJvmMemoryManagerState = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 2, 100, 1, 3});
    public static final OID oidJvmThreading = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 3});
    public static final OID oidJvmThreadingLiveThreads = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 3, 1, 0});
    public static final OID oidJvmThreadingPeakThreads = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 3, 3, 0});
    public static final OID oidJvmThreadingTotalCount = new OID(new int[]{1, 3, 6, 1, 4, 1, 42, 2, 145, 3, 163, 1, 1, 3, 4, 0});
    private static final int JVM_CLASSES_LOADED_OPER = 1;
    private static final int JVM_CLASSES_TOTAL_LOADED_OPER = 2;
    private static final int JVM_CLASSES_UNLOADED_OPER = 3;
    private static final int JVM_CLASSES_VERBOSE_LEVEL_OPER = 4;
    private static final int JVM_MEMORY_PENDING_FINAL_COUNT_OPER = 5;
    private static final int JVM_MEMORY_GC_VERBOSE_LEVEL_OPER = 6;
    private static final int JVM_MEMORY_GC_CALL_OPER = 7;
    private static final int JVM_MEMORY_HEAP_SIZE_INIT_OPER = 8;
    private static final int JVM_MEMORY_HEAP_USED_OPER = 9;
    private static final int JVM_MEMORY_HEAP_COMMITTED_OPER = 10;
    private static final int JVM_MEMORY_HEAP_MAX_SIZE_OPER = 11;
    private static final int JVM_MEMORY_NONHEAP_SIZE_INIT_OPER = 12;
    private static final int JVM_MEMORY_NONHEAP_USED_OPER = 13;
    private static final int JVM_MEMORY_NONHEAP_COMMITTED_OPER = 14;
    private static final int JVM_MEMORY_NONHEAP_MAX_SIZE_OPER = 15;
    private static final int JVM_THREAD_LIVE_OPER = 16;
    private static final int JVM_THREAD_PEAK_OPER = 17;
    private static final int JVM_THREAD_TOTAL_OPER = 18;
    private final ManagementContext managementContext;
    private final MOScalar jvmClassesLoadedCount;
    private final MOScalar jvmClassesTotalLoadedCount;
    private final MOScalar jvmClassesUnloadedCount;
    private final MOScalar jvmClassesVerboseLevel;
    private final MOScalar jvmMemoryPendingFinalCount;
    private final MOScalar jvmMemoryGCVerboseLevel;
    private final MOScalar jvmMemoryGCCall;
    private final MOScalar jvmMemoryHeapSizeInit;
    private final MOScalar jvmMemoryHeapUsed;
    private final MOScalar jvmMemoryHeapCommitted;
    private final MOScalar jvmMemoryHeapMaxSize;
    private final MOScalar jvmMemoryNonHeapSizeInit;
    private final MOScalar jvmMemoryNonHeapUsed;
    private final MOScalar jvmMemoryNonHeapCommitted;
    private final MOScalar jvmMemoryNonHeapMaxSize;
    private final MOScalar jvmThreadingLiveThreads;
    private final MOScalar jvmThreadingPeakThreads;
    private final MOScalar jvmThreadingTotalThreads;
    private SystemString summaryDataFields;
    private SystemString summaryData;
    private MOScalar summaryDataNotificationInterval;
    private MOScalar summaryDataGatherInterval;
    private JvmManagementBean bean;
    private static final int SUMMARY_DATA_FIELDS_OPER = 40;
    private static final int SUMMARY_DATA_OPER = 41;

    public JVMManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        try {
            ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
            this.jvmClassesLoadedCount = new JVMClassLoadingLong(oidJvmClassesLoadedCount, factory.createAccess(9), (Variable)new Counter64((long)classLoadingBean.getLoadedClassCount()), 1);
            this.jvmClassesTotalLoadedCount = new JVMClassLoadingLong(oidJvmClassesTotalLoadedCount, factory.createAccess(9), (Variable)new Counter64(classLoadingBean.getTotalLoadedClassCount()), 2);
            this.jvmClassesUnloadedCount = new JVMClassLoadingLong(oidJvmClassesUnloadedCount, factory.createAccess(9), (Variable)new Counter64(classLoadingBean.getUnloadedClassCount()), 3);
            this.jvmClassesVerboseLevel = new JVMClassLoadingVerboseLevel(oidJvmClassesVerboseLevel, factory.createAccess(11), (Variable)new Integer32(classLoadingBean.isVerbose() ? 2 : 1));
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            this.jvmMemoryPendingFinalCount = new JVMMemoryScalar(oidJvmMemoryPendingFinalCount, factory.createAccess(9), (Variable)new Gauge32((long)memoryBean.getObjectPendingFinalizationCount()), 5);
            this.jvmMemoryGCVerboseLevel = new JVMMemoryGCVerboseLevel(oidJvmMemoryGCVerboseLevel, factory.createAccess(11), (Variable)new Integer32(memoryBean.isVerbose() ? 2 : 1));
            this.jvmMemoryGCCall = new JVMMemoryGCCall(oidJvmMemoryGCCall, factory.createAccess(11), (Variable)new Integer32(2));
            MemoryUsage heapUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            this.jvmMemoryHeapSizeInit = new JVMMemoryScalar(oidJvmMemoryHeapInitSize, factory.createAccess(9), (Variable)new Counter64(heapUsage.getInit()), 8);
            this.jvmMemoryHeapUsed = new JVMMemoryScalar(oidJvmMemoryHeapUsed, factory.createAccess(9), (Variable)new Counter64(heapUsage.getUsed()), 9);
            this.jvmMemoryHeapCommitted = new JVMMemoryScalar(oidJvmMemoryHeapCommitted, factory.createAccess(9), (Variable)new Counter64(heapUsage.getCommitted()), 10);
            this.jvmMemoryHeapMaxSize = new JVMMemoryScalar(oidJvmMemoryHeapMaxSize, factory.createAccess(9), (Variable)new Counter64(heapUsage.getMax()), 11);
            MemoryUsage nonHeapUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
            this.jvmMemoryNonHeapSizeInit = new JVMMemoryScalar(oidJvmMemoryNonHeapInitSize, factory.createAccess(9), (Variable)new Counter64(nonHeapUsage.getInit()), 12);
            this.jvmMemoryNonHeapUsed = new JVMMemoryScalar(oidJvmMemoryNonHeapUsed, factory.createAccess(9), (Variable)new Counter64(nonHeapUsage.getUsed()), 13);
            this.jvmMemoryNonHeapCommitted = new JVMMemoryScalar(oidJvmMemoryNonHeapCommitted, factory.createAccess(9), (Variable)new Counter64(nonHeapUsage.getCommitted()), 14);
            this.jvmMemoryNonHeapMaxSize = new JVMMemoryScalar(oidJvmMemoryNonHeapMaxSize, factory.createAccess(9), (Variable)new Counter64(nonHeapUsage.getMax()), 15);
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            this.jvmThreadingLiveThreads = new JVMThreadingScalar(oidJvmThreadingLiveThreads, factory.createAccess(9), (Variable)new Gauge32((long)threadBean.getThreadCount()), 16);
            this.jvmThreadingPeakThreads = new JVMThreadingScalar(oidJvmThreadingPeakThreads, factory.createAccess(9), (Variable)new Gauge32((long)threadBean.getPeakThreadCount()), 17);
            this.jvmThreadingTotalThreads = new JVMThreadingScalar(oidJvmThreadingTotalCount, factory.createAccess(9), (Variable)new Gauge32(threadBean.getTotalStartedThreadCount()), 18);
            this.summaryDataFields = new SystemString(MIBConstants.oidJvmSummaryDataFields, factory.createAccess(9), (Variable)new OctetString(), 40);
            this.summaryData = new SystemString(MIBConstants.oidJvmSummaryData, factory.createAccess(9), (Variable)new OctetString(), 41);
            this.summaryDataNotificationInterval = new SummaryDataIntervalMO(factory, managementContext.getJvmSummaryDataNotificationInterval(), MIBConstants.oidJvmSummaryDataNotificationInterval);
            this.summaryDataGatherInterval = new SummaryDataIntervalMO(factory, managementContext.getJvmSummaryDataNotificationInterval(), MIBConstants.oidJvmSummaryDataGatherInterval);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.jvmClassesLoadedCount, context);
        server.register((ManagedObject)this.jvmClassesTotalLoadedCount, context);
        server.register((ManagedObject)this.jvmClassesUnloadedCount, context);
        server.register((ManagedObject)this.jvmClassesVerboseLevel, context);
        server.register((ManagedObject)this.jvmMemoryPendingFinalCount, context);
        server.register((ManagedObject)this.jvmMemoryGCVerboseLevel, context);
        server.register((ManagedObject)this.jvmMemoryGCCall, context);
        server.register((ManagedObject)this.jvmMemoryHeapSizeInit, context);
        server.register((ManagedObject)this.jvmMemoryHeapUsed, context);
        server.register((ManagedObject)this.jvmMemoryHeapCommitted, context);
        server.register((ManagedObject)this.jvmMemoryHeapMaxSize, context);
        server.register((ManagedObject)this.jvmMemoryNonHeapSizeInit, context);
        server.register((ManagedObject)this.jvmMemoryNonHeapUsed, context);
        server.register((ManagedObject)this.jvmMemoryNonHeapCommitted, context);
        server.register((ManagedObject)this.jvmMemoryNonHeapMaxSize, context);
        server.register((ManagedObject)this.jvmThreadingLiveThreads, context);
        server.register((ManagedObject)this.jvmThreadingPeakThreads, context);
        server.register((ManagedObject)this.jvmThreadingTotalThreads, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryData, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
        server.register((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.jvmClassesLoadedCount, context);
        server.unregister((ManagedObject)this.jvmClassesTotalLoadedCount, context);
        server.unregister((ManagedObject)this.jvmClassesUnloadedCount, context);
        server.unregister((ManagedObject)this.jvmClassesVerboseLevel, context);
        server.unregister((ManagedObject)this.jvmMemoryPendingFinalCount, context);
        server.unregister((ManagedObject)this.jvmMemoryGCVerboseLevel, context);
        server.unregister((ManagedObject)this.jvmMemoryGCCall, context);
        server.unregister((ManagedObject)this.jvmMemoryHeapSizeInit, context);
        server.unregister((ManagedObject)this.jvmMemoryHeapUsed, context);
        server.unregister((ManagedObject)this.jvmMemoryHeapCommitted, context);
        server.unregister((ManagedObject)this.jvmMemoryHeapMaxSize, context);
        server.unregister((ManagedObject)this.jvmMemoryNonHeapSizeInit, context);
        server.unregister((ManagedObject)this.jvmMemoryNonHeapUsed, context);
        server.unregister((ManagedObject)this.jvmMemoryNonHeapCommitted, context);
        server.unregister((ManagedObject)this.jvmMemoryNonHeapMaxSize, context);
        server.unregister((ManagedObject)this.jvmThreadingLiveThreads, context);
        server.unregister((ManagedObject)this.jvmThreadingPeakThreads, context);
        server.unregister((ManagedObject)this.jvmThreadingTotalThreads, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryData, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
        server.unregister((ManagedObject)this.summaryDataGatherInterval, context);
    }

    public void addJvmManagementBean(JvmManagementBean jvmManagementBean) {
        this.bean = jvmManagementBean;
    }

    class SystemString
    extends MOScalar {
        private int operation;

        SystemString(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            String value;
            switch (this.operation) {
                case 40: {
                    value = JVMManagementMIB.this.bean.getSummaryDataFields();
                    break;
                }
                case 41: {
                    value = JVMManagementMIB.this.bean.getSummaryData();
                    break;
                }
                default: {
                    throw new RuntimeException("SystemString incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            OctetString val = (OctetString)Utils.stringToVariable(value);
            return val;
        }
    }

    class JVMThreadingScalar
    extends MOScalar {
        private int operation;

        JVMThreadingScalar(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            switch (this.operation) {
                case 1: {
                    return new Integer32(bean.getThreadCount());
                }
                case 2: {
                    return new Integer32(bean.getPeakThreadCount());
                }
                case 3: {
                    return new Counter64(bean.getTotalStartedThreadCount());
                }
            }
            throw new RuntimeException("JMVThreadingScalar incorrectly configured with unsupported operation: " + this.operation);
        }
    }

    class JVMMemoryScalar
    extends MOScalar {
        private int operation;

        JVMMemoryScalar(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
            switch (this.operation) {
                case 1: {
                    return new Gauge32((long)bean.getObjectPendingFinalizationCount());
                }
                case 8: {
                    return new Counter64(bean.getHeapMemoryUsage().getInit());
                }
                case 9: {
                    return new Counter64(bean.getHeapMemoryUsage().getUsed());
                }
                case 10: {
                    return new Counter64(bean.getHeapMemoryUsage().getCommitted());
                }
                case 11: {
                    return new Counter64(bean.getHeapMemoryUsage().getMax());
                }
                case 12: {
                    return new Counter64(bean.getNonHeapMemoryUsage().getInit());
                }
                case 13: {
                    return new Counter64(bean.getNonHeapMemoryUsage().getUsed());
                }
                case 14: {
                    return new Counter64(bean.getNonHeapMemoryUsage().getCommitted());
                }
                case 15: {
                    return new Counter64(bean.getNonHeapMemoryUsage().getMax());
                }
            }
            throw new RuntimeException("JMVMemoryScalar incorrectly configured with unsupported operation: " + this.operation);
        }
    }

    class JVMMemoryGCCall
    extends MOScalar {
        JVMMemoryGCCall(OID id, MOAccess access, Variable value) {
            super(id, access, value);
        }

        public int setValue(Variable value) {
            try {
                if (value instanceof Integer32) {
                    int gcCallValue = ((Integer32)value).getValue();
                    if (gcCallValue == 3) {
                        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
                        bean.gc();
                        return 0;
                    }
                    return 3;
                }
                return 3;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class JVMMemoryGCVerboseLevel
    extends JVMVerboseLevel {
        private MemoryMXBean bean;

        JVMMemoryGCVerboseLevel(OID id, MOAccess access, Variable value) {
            super(id, access, value);
            this.bean = ManagementFactory.getMemoryMXBean();
        }

        @Override
        boolean isVerbose() {
            return this.bean.isVerbose();
        }

        @Override
        void setVerbose(boolean verbose) {
            this.bean.setVerbose(verbose);
        }
    }

    class JVMClassLoadingVerboseLevel
    extends JVMVerboseLevel {
        private ClassLoadingMXBean bean;

        JVMClassLoadingVerboseLevel(OID id, MOAccess access, Variable value) {
            super(id, access, value);
            this.bean = ManagementFactory.getClassLoadingMXBean();
        }

        @Override
        boolean isVerbose() {
            return this.bean.isVerbose();
        }

        @Override
        void setVerbose(boolean verbose) {
            this.bean.setVerbose(verbose);
        }
    }

    abstract class JVMVerboseLevel
    extends MOScalar {
        JVMVerboseLevel(OID id, MOAccess access, Variable value) {
            super(id, access, value);
        }

        abstract boolean isVerbose();

        abstract void setVerbose(boolean var1);

        public Variable getValue() {
            if (this.isVerbose()) {
                return new Integer32(2);
            }
            return new Integer32(1);
        }

        public int setValue(Variable value) {
            if (value instanceof Integer32) {
                int verboseLevel = ((Integer32)value).getValue();
                this.setVerbose(verboseLevel == 2);
                return 0;
            }
            return 3;
        }
    }

    class JVMClassLoadingLong
    extends MOScalar {
        private int operation;

        JVMClassLoadingLong(OID id, MOAccess access, Variable value, int operation) {
            super(id, access, value);
            this.operation = operation;
        }

        public Variable getValue() {
            long classLoadingLong;
            ClassLoadingMXBean bean = ManagementFactory.getClassLoadingMXBean();
            switch (this.operation) {
                case 1: {
                    classLoadingLong = bean.getLoadedClassCount();
                    break;
                }
                case 2: {
                    classLoadingLong = bean.getTotalLoadedClassCount();
                    break;
                }
                case 3: {
                    classLoadingLong = bean.getUnloadedClassCount();
                    break;
                }
                default: {
                    throw new RuntimeException("JMVClassLoadingLong incorrectly configured with unsupported operation: " + this.operation);
                }
            }
            return new Counter64(classLoadingLong);
        }
    }
}

