/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.core.session.IoSession;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kaazing.gateway.management.ClusterManagementListener;
import org.kaazing.gateway.management.ManagementServiceHandler;
import org.kaazing.gateway.management.SummaryDataListener;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.config.ClusterConfigurationBean;
import org.kaazing.gateway.management.config.NetworkConfigurationBean;
import org.kaazing.gateway.management.config.RealmConfigurationBean;
import org.kaazing.gateway.management.config.SecurityConfigurationBean;
import org.kaazing.gateway.management.config.ServiceConfigurationBean;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBean;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.gateway.GatewayManagementListener;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementListener;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.management.session.SessionManagementListener;
import org.kaazing.gateway.management.snmp.KaazingPDU;
import org.kaazing.gateway.management.snmp.mib.CpuManagementMIB;
import org.kaazing.gateway.management.snmp.mib.GatewayConfigurationMIB;
import org.kaazing.gateway.management.snmp.mib.GatewayManagementMIB;
import org.kaazing.gateway.management.snmp.mib.JVMManagementMIB;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.kaazing.gateway.management.snmp.mib.NicManagementMIB;
import org.kaazing.gateway.management.snmp.mib.ServiceManagementMIB;
import org.kaazing.gateway.management.snmp.mib.SessionManagementMIB;
import org.kaazing.gateway.management.snmp.mib.SystemManagementMIB;
import org.kaazing.gateway.management.snmp.transport.ManagementAddress;
import org.kaazing.gateway.management.snmp.transport.ManagementTDomainAddressFactory;
import org.kaazing.gateway.management.snmp.transport.ManagementTcpTransport;
import org.kaazing.gateway.management.snmp.transport.ManagementTransport;
import org.kaazing.gateway.management.snmp.transport.ManagementUdpTransport;
import org.kaazing.gateway.management.system.CpuListManagementBean;
import org.kaazing.gateway.management.system.CpuManagementBean;
import org.kaazing.gateway.management.system.HostManagementBean;
import org.kaazing.gateway.management.system.JvmManagementBean;
import org.kaazing.gateway.management.system.NicListManagementBean;
import org.kaazing.gateway.management.system.NicManagementBean;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.server.context.resolve.DefaultServiceContext;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.io.IoMessage;
import org.kaazing.gateway.transport.ws.AbstractWsBridgeSession;
import org.kaazing.gateway.transport.ws.extension.ExtensionHeader;
import org.kaazing.gateway.transport.ws.extension.ExtensionParameter;
import org.kaazing.gateway.transport.ws.extension.WebSocketExtension;
import org.kaazing.gateway.transport.wseb.WsebSession;
import org.kaazing.gateway.transport.wsn.WsnSession;
import org.kaazing.gateway.util.ws.WebSocketWireProtocol;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.RequestHandler;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.mo.snmp.NotificationLogListener;
import org.snmp4j.agent.mo.snmp.NotificationLogMib;
import org.snmp4j.agent.mo.snmp.NotificationOriginatorImpl;
import org.snmp4j.agent.mo.snmp.ProxyForwarderImpl;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpFrameworkMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.agent.mo.util.MOTableSizeLimit;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportListener;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.version.VersionInfo;

class SnmpManagementServiceHandler
extends IoHandlerAdapter<IoSessionEx>
implements VariableProvider,
ManagementServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(SnmpManagementServiceHandler.class);
    public static final String NOTIF_TARGET_PARAM_NAME = "KaazingData";
    private static final String SESSION_CLOSED_OTHER_END_MSG = "Session was closed at other end";
    protected final ServiceContext serviceContext;
    private final ManagementContext managementContext;
    private final ManagementTransport transportMapping;
    private final MOServer server;
    private final KaazingConfigManager agent;
    private final ScheduledExecutorService notifScheduler;
    private final ScheduledExecutorService summaryDataScheduler;

    public SnmpManagementServiceHandler(ServiceContext serviceContext, ManagementContext managementContext) {
        this.serviceContext = serviceContext;
        this.managementContext = managementContext;
        this.managementContext.addGatewayManagementListener(new SNMPGatewayManagementListener());
        this.managementContext.addServiceManagementListener(new SNMPServiceManagementListener());
        this.managementContext.addSessionManagementListener(new SNMPSessionManagementListener());
        this.transportMapping = new ManagementTransport(managementContext);
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        final Properties props = KaazingSNMPAgentProperties.getProperties();
        MOInputFactory configurationFactory = new MOInputFactory(){

            public MOInput createMOInput() {
                return new PropertyMOInput(props, (VariableProvider)SnmpManagementServiceHandler.this);
            }
        };
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        messageDispatcher.addTransportMapping((TransportMapping)this.transportMapping);
        messageDispatcher.addTransportMapping((TransportMapping)new ManagementTcpTransport(serviceContext, managementContext));
        messageDispatcher.addTransportMapping((TransportMapping)new ManagementUdpTransport(serviceContext, managementContext));
        this.agent = new KaazingConfigManager(new OctetString(MPv3.createLocalEngineID()), (MessageDispatcher)messageDispatcher, null, moServers, null, configurationFactory, (MOPersistenceProvider)new DefaultMOPersistenceProvider(moServers, ""));
        this.notifScheduler = serviceContext.getSchedulerProvider().getScheduler("SNMPNotif", true);
        this.summaryDataScheduler = serviceContext.getSchedulerProvider().getScheduler("SNMPSummaryData", false);
        this.agent.initialize();
        this.agent.configure();
        this.agent.launch();
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    protected void doSessionCreated(IoSessionEx session) throws Exception {
        this.managementContext.incrementManagementSessionCount();
        super.doSessionCreated((IoSession)session);
    }

    protected void doSessionClosed(IoSessionEx session) throws Exception {
        this.managementContext.decrementManagementSessionCount();
        OctetString name = this.generateNotificationTargetAddressName(session.getId());
        this.agent.getSnmpTargetMIB().removeTargetAddress(name);
        super.doSessionClosed((IoSession)session);
    }

    protected void doMessageReceived(IoSessionEx session, Object message) throws Exception {
        if (message instanceof IoBufferEx) {
            ByteBuffer buf = ((IoBufferEx)message).buf();
            this.transportMapping.processMessage(new ManagementAddress(session), buf);
        }
        super.doMessageReceived((IoSession)session, message);
    }

    protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
        String message = cause.getMessage();
        if ((message == null || !message.equals(SESSION_CLOSED_OTHER_END_MSG)) && logger.isDebugEnabled()) {
            logger.debug("Exception caught in SNMP session: ", cause);
        }
    }

    protected void sendNotification(final OID oid, final VariableBinding[] variableBindings) {
        this.notifScheduler.submit(new Callable<Object>(){

            @Override
            public Object call() {
                return SnmpManagementServiceHandler.this.agent.getNotificationOriginator().notify(new OctetString(), oid, variableBindings);
            }
        });
    }

    public OctetString generateNotificationTargetAddressName(long sessionId) {
        OctetString targetAddressName = new OctetString(Long.toString(sessionId));
        return targetAddressName;
    }

    public Variable getVariable(String name) {
        OID oid;
        OctetString context = null;
        int pos = name.indexOf(58);
        if (pos >= 0) {
            context = new OctetString(name.substring(0, pos));
            oid = new OID(name.substring(pos + 1, name.length()));
        } else {
            oid = new OID(name);
        }
        final DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
        DefaultMOQuery query = new DefaultMOQuery((MOContextScope)scope, false, (Object)this);
        ManagedObject mo = this.server.lookup((MOQuery)query);
        if (mo != null) {
            final VariableBinding vb = new VariableBinding(oid);
            final RequestStatus status = new RequestStatus();
            SubRequest req = new SubRequest(){
                private boolean completed;
                private MOQuery query;

                public boolean hasError() {
                    return false;
                }

                public void setErrorStatus(int errorStatus) {
                    status.setErrorStatus(errorStatus);
                }

                public int getErrorStatus() {
                    return status.getErrorStatus();
                }

                public RequestStatus getStatus() {
                    return status;
                }

                public MOScope getScope() {
                    return scope;
                }

                public VariableBinding getVariableBinding() {
                    return vb;
                }

                public Request getRequest() {
                    return null;
                }

                public Object getUndoValue() {
                    return null;
                }

                public void setUndoValue(Object undoInformation) {
                }

                public void completed() {
                    this.completed = true;
                }

                public boolean isComplete() {
                    return this.completed;
                }

                public void setTargetMO(ManagedObject managedObject) {
                }

                public ManagedObject getTargetMO() {
                    return null;
                }

                public int getIndex() {
                    return 0;
                }

                public void setQuery(MOQuery query) {
                    this.query = query;
                }

                public MOQuery getQuery() {
                    return this.query;
                }

                public SubRequestIterator repetitions() {
                    return null;
                }

                public void updateNextRepetition() {
                }

                public Object getUserObject() {
                    return null;
                }

                public void setUserObject(Object userObject) {
                }
            };
            mo.get(req);
            return vb.getVariable();
        }
        return null;
    }

    public void removeGatewayBean(OID oid) {
        this.agent.removeGatewayBean(oid);
    }

    public void removeServiceBean(OID oid) {
        this.agent.removeServiceBean(oid);
    }

    public void removeSessionBean(OID oid) {
        this.agent.removeSessionBean(oid);
    }

    @Override
    public void addGatewayManagementBean(GatewayManagementBean gatewayManagementBean) {
        this.agent.addGatewayBean(gatewayManagementBean);
        OID dataOID = ((OID)MIBConstants.oidGatewayEntry.clone()).append(9).append(gatewayManagementBean.getId());
        OID notificationOID = MIBConstants.oidGatewaySummaryDataEvent;
        gatewayManagementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
        gatewayManagementBean.addClusterManagementListener(new SNMPClusterListener());
    }

    @Override
    public void addServiceManagementBean(ServiceManagementBean serviceManagementBean) {
        this.agent.addServiceBean(serviceManagementBean);
        OID dataOID = ((OID)MIBConstants.oidServiceEntry.clone()).append(25).append(serviceManagementBean.getGatewayManagementBean().getId()).append(serviceManagementBean.getId());
        OID notificationOID = MIBConstants.oidServiceSummaryDataNotification;
        serviceManagementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
    }

    @Override
    public void addSessionManagementBean(SessionManagementBean sessionManagementBean) {
        this.agent.addSessionBean(sessionManagementBean);
        ServiceManagementBean serviceBean = sessionManagementBean.getServiceManagementBean();
        OID dataOID = ((OID)MIBConstants.oidSessionEntry.clone()).append(14).append(serviceBean.getGatewayManagementBean().getId()).append(serviceBean.getId()).append((int)sessionManagementBean.getId());
        OID notificationOID = MIBConstants.oidSessionSummaryDataNotification;
        sessionManagementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
    }

    @Override
    public void removeSessionManagementBean(SessionManagementBean sessionManagementBean) {
        ServiceManagementBean serviceBean = sessionManagementBean.getServiceManagementBean();
        GatewayManagementBean gatewayBean = serviceBean.getGatewayManagementBean();
        OID sessionIndexOID = new OID(new int[]{gatewayBean.getId(), serviceBean.getId(), (int)sessionManagementBean.getId()});
        this.agent.removeSessionBean(sessionIndexOID);
    }

    @Override
    public void addClusterConfigurationBean(ClusterConfigurationBean configurationBean) {
        this.agent.addClusterConfigurationBean(configurationBean);
    }

    @Override
    public void addNetworkConfigurationBean(NetworkConfigurationBean configurationBean) {
        this.agent.addNetworkConfigurationBean(configurationBean);
    }

    @Override
    public void addSecurityConfigurationBean(SecurityConfigurationBean configurationBean) {
        this.agent.addSecurityBean(configurationBean);
    }

    @Override
    public void addRealmConfigurationBean(RealmConfigurationBean configurationBean) {
        this.agent.addRealmBean(configurationBean);
    }

    @Override
    public void addServiceConfigurationBean(ServiceConfigurationBean configurationBean) {
        this.agent.addServiceConfigurationBean(configurationBean);
    }

    @Override
    public void addServiceDefaultsConfigurationBean(ServiceDefaultsConfigurationBean configurationBean) {
        this.agent.addServiceDefaultsConfigurationBean(configurationBean);
    }

    @Override
    public void addVersionInfo(GatewayManagementBean managementBean) {
        this.agent.addVersionInfo(managementBean);
    }

    @Override
    public void addSystemManagementBean(final HostManagementBean managementBean) {
        this.agent.addSystemManagementBean(managementBean);
        this.managementContext.runManagementTask(new Runnable(){

            @Override
            public void run() {
                OID dataOID = ((OID)MIBConstants.oidSystemSummaryData.clone()).append(managementBean.getGatewayManagementBean().getId());
                OID notificationOID = MIBConstants.oidSystemSummaryDataNotification;
                managementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
            }
        });
    }

    @Override
    public void addCpuListManagementBean(final CpuListManagementBean managementBean) {
        this.agent.addCpuListManagementBean(managementBean);
        this.managementContext.runManagementTask(new Runnable(){

            @Override
            public void run() {
                OID dataOID = ((OID)MIBConstants.oidCpuListSummaryData.clone()).append(managementBean.getGatewayManagementBean().getId());
                OID notificationOID = MIBConstants.oidCpuListSummaryDataNotification;
                managementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
            }
        });
    }

    @Override
    public void addCpuManagementBean(CpuManagementBean managementBean, String hostAndPid) {
        this.agent.addCpuManagementBean(managementBean);
    }

    @Override
    public void addNicListManagementBean(final NicListManagementBean managementBean) {
        this.agent.addNicListManagementBean(managementBean);
        this.managementContext.runManagementTask(new Runnable(){

            @Override
            public void run() {
                OID dataOID = ((OID)MIBConstants.oidNicListSummaryData.clone()).append(managementBean.getGatewayManagementBean().getId());
                OID notificationOID = MIBConstants.oidNicListSummaryDataNotification;
                managementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
            }
        });
    }

    @Override
    public void addNicManagementBean(NicManagementBean managementBean, String hostAndPid) {
        this.agent.addNicManagementBean(managementBean);
    }

    @Override
    public void addJvmManagementBean(final JvmManagementBean managementBean) {
        this.agent.addJvmManagementBean(managementBean);
        this.managementContext.runManagementTask(new Runnable(){

            @Override
            public void run() {
                OID dataOID = ((OID)MIBConstants.oidJvmSummaryData.clone()).append(managementBean.getGatewayManagementBean().getId());
                OID notificationOID = MIBConstants.oidJvmSummaryDataNotification;
                managementBean.addSummaryDataListener(new SNMPSummaryDataListener(dataOID, notificationOID));
            }
        });
    }

    private static class KaazingSNMPAgentProperties {
        private static Properties agentProperties = new Properties();
        private static Properties tableSizeLimits;

        private KaazingSNMPAgentProperties() {
        }

        private static Properties getProperties() {
            return agentProperties;
        }

        private static Properties getTableSizeLimits() {
            return tableSizeLimits;
        }

        static {
            agentProperties.setProperty("snmp4j.agent.cfg.contexts", "");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.2.1.1.2.0", "{o}1.3.6.1.4.1.4976");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.2.1.1.4.0", "{s}System Administrator");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.2.1.1.6.0", "{s}<edit location>");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.2.1.1.7.0", "{i}10");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.2.1.1.9.1", "1:2");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.2.1.1.9.1.0", "{o}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.2.1.1.9.1.0.0", "{o}1.3.6.1.4.1.4976.10.1.1.100.4.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.2.1.1.9.1.0.1", "");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.16.1.2.1", "5:3");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.2.1.0", "{o}2.6.'public'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.0.0", "{s}v1v2cgroup");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.0.1", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.0.2", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.2.1.1", "{o}3.6.'SHADES'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.1.0", "{s}v3group");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.1.1", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.1.2", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.2.1.2", "{o}1.6.'public'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.2.0", "{s}v1v2cgroup");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.2.1", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.2.2", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.2.1.3", "{o}3.3.'SHA'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.3.0", "{s}v3group");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.3.1", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.3.2", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.2.1.4", "{o}3.5.'unsec'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.4.0", "{s}v3group");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.4.1", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.2.1.4.2", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.16.1.4.1", "5:6");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.4.1.0", "{o}10.'v1v2cgroup'.0.2.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.0.0", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.0.1", "{s}unrestrictedReadView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.0.2", "{s}unrestrictedWriteView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.0.3", "{s}unrestrictedNotifyView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.0.4", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.0.5", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.4.1.1", "{o}7.'v3group'.0.3.3");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.1.0", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.1.1", "{s}unrestrictedReadView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.1.2", "{s}unrestrictedWriteView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.1.3", "{s}unrestrictedNotifyView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.1.4", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.1.5", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.4.1.2", "{o}10.'v1v2cgroup'.0.1.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.2.0", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.2.1", "{s}unrestrictedReadView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.2.2", "{s}unrestrictedWriteView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.2.3", "{s}unrestrictedNotifyView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.2.4", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.2.5", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.4.1.3", "{o}7.'v3group'.0.3.2");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.3.0", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.3.1", "{s}unrestrictedReadView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.3.2", "{s}unrestrictedWriteView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.3.3", "{s}unrestrictedNotifyView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.3.4", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.3.5", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.4.1.4", "{o}7.'v3group'.0.3.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.4.0", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.4.1", "{s}unrestrictedReadView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.4.2", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.4.3", "{s}unrestrictedNotifyView");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.4.4", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.4.1.4.5", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.16.1.5.2.1", "3:4");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.5.2.1.0", "{o}20.'unrestrictedReadView'.3.1.3.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.0.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.0.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.0.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.0.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.5.2.1.1", "{o}21.'unrestrictedWriteView'.3.1.3.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.1.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.1.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.1.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.1.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.16.1.5.2.1.2", "{o}22.'unrestrictedNotifyView'.3.1.3.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.2.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.2.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.2.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.16.1.5.2.1.2.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.18.1.1.1", "1:7");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.18.1.1.1.0", "{o}'public'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.0", "{s}public");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.1", "{s}public");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.2", "{$1.3.6.1.6.3.10.2.1.1.0}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.3", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.4", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.5", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.18.1.1.1.0.6", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.15.1.2.2.1", "3:14");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.15.1.2.2.1.0", "{o}$#{1.3.6.1.6.3.10.2.1.1.0}.6.'SHADES'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.0", "{s}SHADES");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.1", "{o}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.2", "{o}1.3.6.1.6.3.10.1.1.3");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.3", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.4", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.5", "{o}1.3.6.1.6.3.10.1.2.2");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.6", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.7", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.8", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.9", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.10", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.11", "{s}SHADESAuthPassword");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.12", "{s}SHADESPrivPassword");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.0.13", "");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.15.1.2.2.1.1", "{o}$#{1.3.6.1.6.3.10.2.1.1.0}.3.'SHA'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.0", "{s}SHA");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.1", "{o}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.2", "{o}1.3.6.1.6.3.10.1.1.3");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.3", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.4", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.5", "{o}1.3.6.1.6.3.10.1.2.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.6", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.7", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.8", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.9", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.10", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.11", "{s}SHAAuthPassword");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.12", "");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.1.13", "");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.15.1.2.2.1.2", "{o}$#{1.3.6.1.6.3.10.2.1.1.0}.5.'unsec'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.0", "{s}unsec");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.1", "{o}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.2", "{o}1.3.6.1.6.3.10.1.1.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.3", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.4", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.5", "{o}1.3.6.1.6.3.10.1.2.1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.6", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.7", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.8", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.9", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.10", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.11", "");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.12", "");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.15.1.2.2.1.2.13", "");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.12.1.3.1", "1:6");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.12.1.3.1.0", "{o}'SNMPv2c'");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.12.1.3.1.0", "{o}'KaazingData'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.12.1.3.1.0.0", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.12.1.3.1.0.1", "{i}2");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.12.1.3.1.0.2", "{s}public");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.12.1.3.1.0.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.12.1.3.1.0.4", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.12.1.3.1.0.5", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.13.1.1.1", "1:4");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.1.1.0", "{o}'unfiltered'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.1.1.0.0", "{s}notify");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.1.1.0.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.1.1.0.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.1.1.0.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.13.1.2.1", "1:3");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.2.1.0", "{o}'SNMPv2c'");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.2.1.0", "{o}'KaazingData'");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.2.1.0.0", "{s}kaazing");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.2.1.0.1", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.2.1.0.2", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.oid.1.3.6.1.6.3.13.1.3.1", "19:4");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.0", "{o}7.'kaazing'.1.3.6.1.6.3.1.1.5.5");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.0.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.0.1", "{i}2");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.0.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.0.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.1", "{o}7.'kaazing'.1.3.6.1.4.1.29197.2.4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.1.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.1.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.1.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.1.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.2", "{o}7.'kaazing'.1.3.6.1.4.1.29197.2.5");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.2.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.2.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.2.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.2.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.3", "{o}7.'kaazing'.1.3.6.1.4.1.29197.2.8");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.3.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.3.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.3.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.3.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.4", "{o}7.'kaazing'.1.3.6.1.4.1.29197.2.11");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.4.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.4.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.4.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.4.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.5", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.1.2");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.5.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.5.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.5.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.5.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.6", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.1.3");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.6.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.6.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.6.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.6.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.7", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.1.4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.7.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.7.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.7.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.7.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.8", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.1.5");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.8.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.8.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.8.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.8.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.9", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.9.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.9.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.9.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.9.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.10", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.5");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.10.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.10.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.10.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.10.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.11", "{o}7.'kaazing'.1.3.6.1.4.1.29197.3.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.11.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.11.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.11.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.11.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.12", "{o}7.'kaazing'.1.3.6.1.4.1.29197.4.4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.12.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.12.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.12.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.12.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.13", "{o}7.'kaazing'.1.3.6.1.4.1.29197.4.5");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.13.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.13.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.13.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.13.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.14", "{o}7.'kaazing'.1.3.6.1.4.1.29197.4.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.14.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.14.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.14.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.14.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.15", "{o}7.'kaazing'.1.3.6.1.4.1.29197.5.33");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.15.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.15.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.15.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.15.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.16", "{o}7.'kaazing'.1.3.6.1.4.1.29197.5.43");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.16.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.16.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.16.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.16.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.17", "{o}7.'kaazing'.1.3.6.1.4.1.29197.6.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.17.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.17.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.17.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.17.3", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.index.1.3.6.1.6.3.13.1.3.1.18", "{o}7.'kaazing'.1.3.6.1.4.1.29197.7.6");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.18.0", "{s}");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.18.1", "{i}1");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.18.2", "{i}4");
            agentProperties.setProperty("snmp4j.agent.cfg.value.1.3.6.1.6.3.13.1.3.1.18.3", "{i}1");
            tableSizeLimits = new Properties();
            tableSizeLimits.setProperty("snmp4j.tableSizeLimit.1.3.6.1.2.1.92", "200");
        }
    }

    private class SNMPClusterListener
    implements ClusterManagementListener {
        private GatewayManagementBean gatewayBean;

        private SNMPClusterListener() {
        }

        @Override
        public void setGatewayBean(GatewayManagementBean gatewayBean) {
            this.gatewayBean = gatewayBean;
        }

        @Override
        public void membershipChanged(String changeType, String instanceKey) {
            OID gatewayOID = new OID(new int[]{1});
            OID notificationOID = MIBConstants.oidClusterMembershipEvent;
            OID membershipEventTypeOID = MIBConstants.oidClusterMembershipEventType;
            OID instanceKeyOID = ((OID)MIBConstants.oidGatewayEntry.clone()).append(8).append(gatewayOID);
            VariableBinding[] variables = new VariableBinding[]{new VariableBinding(membershipEventTypeOID, (Variable)new OctetString(changeType)), new VariableBinding(instanceKeyOID, (Variable)new OctetString(instanceKey))};
            SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
        }

        @Override
        public void managementServicesChanged(String changeType, String instanceKey, Collection<String> managementServiceAccepts) {
            OID gatewayOID = new OID(new int[]{1});
            OID notificationOID = MIBConstants.oidClusterManagementServiceEvent;
            OID mgmtSvcNotificationEventTypeOID = MIBConstants.oidClusterManagementServiceEventType;
            OID mgmtSvcNotificationEventURIsOID = MIBConstants.oidClusterManagementServiceEventURIs;
            OID instanceKeyOID = ((OID)MIBConstants.oidGatewayEntry.clone()).append(8).append(gatewayOID);
            StringBuffer sb = new StringBuffer();
            String managementServiceAcceptsValue = "";
            if (managementServiceAccepts != null) {
                for (String managementServiceAccept : managementServiceAccepts) {
                    sb.append(managementServiceAccept + '\n');
                }
                if (sb.length() > 1) {
                    managementServiceAcceptsValue = sb.substring(0, sb.length() - 1);
                }
            }
            VariableBinding[] variables = new VariableBinding[]{new VariableBinding(mgmtSvcNotificationEventTypeOID, (Variable)new OctetString(changeType)), new VariableBinding(instanceKeyOID, (Variable)new OctetString(instanceKey)), new VariableBinding(mgmtSvcNotificationEventURIsOID, (Variable)new OctetString(managementServiceAcceptsValue))};
            SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
        }

        @Override
        public void balancerMapChanged(String changeType, String balancerURI, Collection<String> balanceeURIs) {
            OID gatewayOID = new OID(new int[]{1});
            OID notificationOID = MIBConstants.oidClusterBalancerMapEvent;
            OID balancerMapNotificationEventTypeOID = MIBConstants.oidClusterBalancerMapEventType;
            OID balancerMapNotificationBalancerUriOID = MIBConstants.oidClusterBalancerMapEventBalancerURI;
            OID balancerMapNotificationBalanceeUrisOID = MIBConstants.oidClusterBalancerMapEventBalanceeURIs;
            StringBuffer sb = new StringBuffer();
            String balanceeURIsValue = "";
            if (balanceeURIs != null) {
                for (String balanceeURI : balanceeURIs) {
                    sb.append(balanceeURI + '\n');
                }
                if (sb.length() > 1) {
                    balanceeURIsValue = sb.substring(0, sb.length() - 1);
                }
            }
            VariableBinding[] variables = new VariableBinding[]{new VariableBinding(balancerMapNotificationEventTypeOID, (Variable)new OctetString(changeType)), new VariableBinding(balancerMapNotificationBalancerUriOID, (Variable)new OctetString(balancerURI)), new VariableBinding(balancerMapNotificationBalanceeUrisOID, (Variable)new OctetString(balanceeURIsValue))};
            SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
        }
    }

    private final class SNMPSessionManagementListener
    implements SessionManagementListener {
        private SNMPSessionManagementListener() {
        }

        @Override
        public void doSessionCreated(SessionManagementBean sessionBean) throws Exception {
            ServiceManagementBean serviceBean = sessionBean.getServiceManagementBean();
            if (serviceBean.areNotificationsEnabled()) {
                JSONObject sessionData = new JSONObject();
                IoSessionEx session = sessionBean.getSession();
                sessionData.put("sessionId", session.getId());
                sessionData.put("serviceId", serviceBean.getId());
                sessionData.put("createTime", session.getCreationTime());
                sessionData.put("localAddress", (Object)session.getLocalAddress());
                sessionData.put("remoteAddress", (Object)serviceBean.getSessionRemoteAddress(session));
                ResourceAddress address = (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get((IoSession)session);
                sessionData.put("sessionTypeName", (Object)Utils.getSessionTypeName(address));
                sessionData.put("sessionDirection", (Object)Utils.getSessionDirection(session));
                Map<String, String> userPrincipals = sessionBean.getUserPrincipalMap();
                if (userPrincipals != null) {
                    sessionData.put("principals", userPrincipals);
                }
                JSONObject protocolAttributes = null;
                if (session instanceof AbstractWsBridgeSession) {
                    AbstractWsBridgeSession wsBridgeSession = (AbstractWsBridgeSession)session;
                    protocolAttributes = new JSONObject();
                    List extensions = wsBridgeSession.getExtensions();
                    if (extensions != null && extensions.size() > 0) {
                        JSONObject jsonObj = new JSONObject();
                        for (WebSocketExtension extension : extensions) {
                            ExtensionHeader extensionHeader = extension.getExtensionHeader();
                            String token = extensionHeader.getExtensionToken();
                            JSONArray paramsArray = null;
                            if (extensionHeader.hasParameters()) {
                                paramsArray = new JSONArray();
                                for (ExtensionParameter param : extensionHeader.getParameters()) {
                                    String name = param.getName();
                                    String value = param.getValue();
                                    if (value == null) {
                                        paramsArray.put((Object)name);
                                        continue;
                                    }
                                    paramsArray.put((Object)(name + "=" + value));
                                }
                            }
                            jsonObj.put(token, (Object)paramsArray);
                        }
                        protocolAttributes.put("extensions", (Object)jsonObj);
                    }
                    if (session instanceof WsnSession) {
                        WsnSession wsnSession = (WsnSession)session;
                        WebSocketWireProtocol protocolVersion = wsnSession.getVersion();
                        protocolAttributes.put("protocolVersion", (Object)protocolVersion.toString());
                    } else if (session instanceof WsebSession) {
                        WsebSession wsebSession = (WsebSession)session;
                        ResourceAddress readAddr = wsebSession.getReadAddress();
                        ResourceAddress writeAddr = wsebSession.getWriteAddress();
                        if (readAddr != null) {
                            protocolAttributes.put("readAddress", (Object)readAddr);
                        }
                        if (writeAddr != null) {
                            protocolAttributes.put("writeAddress", (Object)writeAddr);
                        }
                    }
                }
                if (protocolAttributes != null) {
                    sessionData.put("protocolAttributes", protocolAttributes);
                }
                OID notificationOID = MIBConstants.oidServiceConnectionNotification;
                VariableBinding[] variables = new VariableBinding[]{new VariableBinding(notificationOID, (Variable)new OctetString(sessionData.toString()))};
                SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
            }
        }

        @Override
        public void doSessionClosed(SessionManagementBean sessionBean) throws Exception {
        }

        @Override
        public void doMessageReceived(SessionManagementBean sessionBean, Object message) throws Exception {
            if (sessionBean.areNotificationsEnabled() && message instanceof IoBufferEx) {
                StringBuffer sb = new StringBuffer();
                sb.append("Message Received: ");
                IoBufferEx buffer = (IoBufferEx)message;
                byte[] bytes = buffer.array();
                int arrayOffset = buffer.arrayOffset();
                for (int i = buffer.position(); i < buffer.limit(); ++i) {
                    sb.append(String.format("%02X ", bytes[i + arrayOffset]));
                }
                ServiceManagementBean serviceBean = sessionBean.getServiceManagementBean();
                GatewayManagementBean gatewayBean = serviceBean.getGatewayManagementBean();
                OID sessionOID = new OID(new int[]{gatewayBean.getId(), serviceBean.getId(), (int)sessionBean.getId()});
                OID notificationOID = MIBConstants.oidSessionMessageReceivedNotification;
                VariableBinding[] variables = new VariableBinding[]{new VariableBinding(((OID)MIBConstants.oidSessionEntry.clone()).append(2).append(sessionOID), (Variable)new Counter64(sessionBean.getId())), new VariableBinding(notificationOID, (Variable)new OctetString(sb.toString()))};
                SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
            }
        }

        @Override
        public void doFilterWrite(SessionManagementBean sessionBean, Object message, Object originalMessage) throws Exception {
            if (sessionBean.areNotificationsEnabled() && message instanceof IoBufferEx) {
                StringBuffer sb = new StringBuffer();
                sb.append("Message Sent: ");
                IoBufferEx buffer = null;
                if (originalMessage != null) {
                    if (originalMessage instanceof IoBufferEx) {
                        buffer = (IoBufferEx)originalMessage;
                    } else if (originalMessage instanceof IoMessage) {
                        buffer = ((IoMessage)originalMessage).getBuffer();
                    }
                } else {
                    buffer = (IoBufferEx)message;
                }
                byte[] bytes = buffer.array();
                int arrayOffset = buffer.arrayOffset();
                for (int i = buffer.position(); i < buffer.limit(); ++i) {
                    sb.append(String.format("%02X ", bytes[i + arrayOffset]));
                }
                ServiceManagementBean serviceBean = sessionBean.getServiceManagementBean();
                GatewayManagementBean gatewayBean = serviceBean.getGatewayManagementBean();
                OID sessionOID = new OID(new int[]{gatewayBean.getId(), serviceBean.getId(), (int)sessionBean.getId()});
                OID notificationOID = MIBConstants.oidSessionFilterWriteNotification;
                VariableBinding[] variables = new VariableBinding[]{new VariableBinding(((OID)MIBConstants.oidSessionEntry.clone()).append(2).append(sessionOID), (Variable)new Counter64(sessionBean.getId())), new VariableBinding(notificationOID, (Variable)new OctetString(sb.toString()))};
                SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
            }
        }

        @Override
        public void doExceptionCaught(SessionManagementBean sessionBean, Throwable cause) {
        }
    }

    private final class SNMPServiceManagementListener
    implements ServiceManagementListener {
        private SNMPServiceManagementListener() {
        }

        @Override
        public void doSessionCreated(ServiceManagementBean serviceBean, long newCurrentSessionCount, long newTotalSessionCount) {
        }

        @Override
        public void doSessionClosed(ServiceManagementBean serviceBean, long sessionId, long newCurrentSessionCount) throws Exception {
            if (serviceBean.areNotificationsEnabled()) {
                int gatewayId = serviceBean.getGatewayManagementBean().getId();
                int serviceId = serviceBean.getId();
                OID serviceOID = new OID(new int[]{gatewayId, serviceId});
                OID notificationOID = MIBConstants.oidServiceDisconnectionNotification;
                VariableBinding[] variables = new VariableBinding[2];
                OID currSessionCountOID = ((OID)MIBConstants.oidServiceEntry.clone()).append(6).append(serviceOID);
                variables[0] = new VariableBinding(currSessionCountOID, (Variable)new Counter64(newCurrentSessionCount));
                OID sessionOID = new OID(new int[]{gatewayId, serviceId, (int)sessionId});
                variables[1] = new VariableBinding(((OID)MIBConstants.oidSessionEntry.clone()).append(7).append(sessionOID), (Variable)new Integer32(0));
                SnmpManagementServiceHandler.this.sendNotification(notificationOID, variables);
            }
        }

        @Override
        public void doMessageReceived(ServiceManagementBean serviceBean, long sessionId, ByteBuffer message) throws Exception {
        }

        @Override
        public void doFilterWrite(ServiceManagementBean serviceBean, long sessionId, ByteBuffer writeMessage) throws Exception {
        }

        @Override
        public void doExceptionCaught(ServiceManagementBean serviceBean, long sessionId, String exceptionMessage) throws Exception {
        }
    }

    private final class SNMPGatewayManagementListener
    implements GatewayManagementListener {
        private SNMPGatewayManagementListener() {
        }

        @Override
        public void doSessionCreated(GatewayManagementBean gatewayBean, long sessionId) throws Exception {
        }

        @Override
        public void doSessionClosed(GatewayManagementBean gatewayBean, long sessionId) throws Exception {
        }

        @Override
        public void doMessageReceived(GatewayManagementBean gatewayBean, long sessionId) throws Exception {
        }

        @Override
        public void doFilterWrite(GatewayManagementBean gatewayBean, long sessionId) throws Exception {
        }

        @Override
        public void doExceptionCaught(GatewayManagementBean gatewayBean, long sessionId) throws Exception {
        }
    }

    private final class SNMPSummaryDataListener
    implements SummaryDataListener {
        private final OID summaryDataOID;
        private final OID summaryDataNotificationOID;

        public SNMPSummaryDataListener(OID summaryDataOID, OID summaryDataNotificationOID) {
            this.summaryDataOID = summaryDataOID;
            this.summaryDataNotificationOID = summaryDataNotificationOID;
        }

        @Override
        public void sendSummaryData(String summaryData) {
            VariableBinding[] variables = new VariableBinding[]{new VariableBinding(this.summaryDataOID, (Variable)new OctetString(summaryData))};
            SnmpManagementServiceHandler.this.sendNotification(this.summaryDataNotificationOID, variables);
        }
    }

    class KaazingConfigManager {
        public static final int STATE_CREATED = 0;
        public static final int STATE_INITIALIZED = 10;
        public static final int STATE_CONFIGURED = 20;
        public static final int STATE_RESTORED = 30;
        public static final int STATE_SUSPENDED = 35;
        public static final int STATE_RUNNING = 40;
        public static final int STATE_UNSAVED_CHANGES = 45;
        public static final int STATE_SAVED = 50;
        public static final int STATE_SHUTDOWN = -1;
        private CommandProcessor agent;
        private VACM vacm;
        private USM usm;
        private MOServer[] servers;
        private Session snmpSession;
        private MessageDispatcher dispatcher;
        private OctetString engineID;
        private ProxyForwarder proxyForwarder;
        private NotificationOriginator notificationOriginator;
        private MOInputFactory configuration;
        private MOPersistenceProvider persistenceProvider;
        private int persistenceImportMode = 2;
        private SNMPv2MIB snmpv2MIB;
        private SnmpTargetMIB targetMIB;
        private SnmpCommunityMIB communityMIB;
        private SnmpNotificationMIB notificationMIB;
        private SnmpFrameworkMIB frameworkMIB;
        private UsmMIB usmMIB;
        private VacmMIB vacmMIB;
        private GatewayManagementMIB gatewayManagementMIB;
        private ServiceManagementMIB serviceManagementMIB;
        private SessionManagementMIB sessionManagementMIB;
        private GatewayConfigurationMIB gatewayConfigurationMIB;
        private JVMManagementMIB jvmManagementMIB;
        private SystemManagementMIB systemManagementMIB;
        private CpuManagementMIB cpuManagementMIB;
        private NicManagementMIB nicManagementMIB;
        protected SnmpProxyMIB proxyMIB;
        private Snmp4jLogMib snmp4jLogMIB;
        private Snmp4jConfigMib snmp4jConfigMIB;
        private NotificationLogMib notificationLogMIB;
        private UnsignedInteger32 notificationLogDefaultLimit = new UnsignedInteger32(100);
        private UnsignedInteger32 notificationLogGlobalLimit = new UnsignedInteger32(1000);
        private UnsignedInteger32 notificationLogGlobalAge = new UnsignedInteger32(0);
        protected MOFactory moFactory = DefaultMOFactory.getInstance();
        protected OctetString sysDescr = new OctetString("Kaazing WebSocket Gateway  [powered by SNMP4J v" + VersionInfo.getVersion() + "]" + " - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
        protected OID sysOID = new OID("1.3.6.1.4.1.4976.10");
        protected Integer32 sysServices = new Integer32(72);
        protected OctetString defaultContext;
        protected MOTableSizeLimit tableSizeLimit;

        public KaazingConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider) {
            this.engineID = agentsOwnEngineID;
            this.dispatcher = messageDispatcher;
            this.vacm = vacm;
            this.servers = moServers;
            this.configuration = configurationFactory;
            this.persistenceProvider = persistenceProvider;
        }

        public KaazingConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, MOFactory moFactory) {
            this(agentsOwnEngineID, messageDispatcher, vacm, moServers, workerPool, configurationFactory, persistenceProvider);
            this.moFactory = moFactory == null ? this.moFactory : moFactory;
        }

        public VACM getVACM() {
            return this.vacm;
        }

        public SNMPv2MIB getSNMPv2MIB() {
            return this.snmpv2MIB;
        }

        public SnmpTargetMIB getSnmpTargetMIB() {
            return this.targetMIB;
        }

        public SnmpNotificationMIB getSnmpNotificationMIB() {
            return this.notificationMIB;
        }

        public SnmpCommunityMIB getSnmpCommunityMIB() {
            return this.communityMIB;
        }

        public NotificationLogMib getNotificationLogMIB() {
            return this.notificationLogMIB;
        }

        public Snmp4jLogMib getSnmp4jLogMIB() {
            return this.snmp4jLogMIB;
        }

        public Snmp4jConfigMib getSnmp4jConfigMIB() {
            return this.snmp4jConfigMIB;
        }

        protected void launch() {
            if (this.tableSizeLimit != null) {
                for (MOServer server1 : this.servers) {
                    DefaultMOServer.unregisterTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
                    DefaultMOServer.registerTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
                }
            }
            this.dispatcher.removeCommandResponder((CommandResponder)this.agent);
            this.dispatcher.addCommandResponder((CommandResponder)this.agent);
            this.registerTransportMappings();
            this.fireLaunchNotifications();
        }

        protected void fireLaunchNotifications() {
            if (this.notificationOriginator != null) {
                this.notificationOriginator.notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[0]);
            }
        }

        public void shutdown() {
            try {
                this.snmpSession.close();
                this.snmpSession = null;
            }
            catch (IOException ex) {
                logger.warn("Failed to close SNMP session: " + ex.getMessage());
            }
            if (this.tableSizeLimit != null) {
                for (MOServer server1 : this.servers) {
                    DefaultMOServer.unregisterTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
                }
            }
            this.unregisterMIBs(null);
        }

        public void initSnmp4jLogMIB() {
            this.snmp4jLogMIB = new Snmp4jLogMib();
        }

        public void initSnmp4jConfigMIB(MOPersistenceProvider[] persistenceProvider) {
            this.snmp4jConfigMIB = new Snmp4jConfigMib(this.snmpv2MIB.getSysUpTime());
            this.snmp4jConfigMIB.setSnmpCommunityMIB(this.communityMIB);
            if (this.persistenceProvider != null) {
                this.snmp4jConfigMIB.setPrimaryProvider(this.persistenceProvider);
            }
            if (persistenceProvider != null) {
                for (MOPersistenceProvider aPersistenceProvider : persistenceProvider) {
                    if (aPersistenceProvider == this.persistenceProvider) continue;
                    this.snmp4jConfigMIB.addPersistenceProvider(aPersistenceProvider);
                }
            }
        }

        protected void initNotificationLogMIB(VACM vacm, SnmpNotificationMIB notifyMIB) {
            this.notificationLogMIB = new NotificationLogMib(this.moFactory, vacm, notifyMIB);
            NotificationLogMib.NlmConfigLogEntryRow row = (NotificationLogMib.NlmConfigLogEntryRow)this.notificationLogMIB.getNlmConfigLogEntry().createRow(new OID(new int[]{0}), new Variable[]{new OctetString(), this.notificationLogDefaultLimit, new Integer32(1), new Integer32(), new Integer32(4), new Integer32(1)});
            this.notificationLogMIB.getNlmConfigLogEntry().addRow((MOTableRow)row);
            this.notificationLogMIB.getNlmConfigGlobalAgeOut().setValue((Variable)this.notificationLogGlobalAge);
            this.notificationLogMIB.getNlmConfigGlobalEntryLimit().setValue((Variable)this.notificationLogGlobalLimit);
            if (this.notificationOriginator instanceof NotificationOriginatorImpl) {
                ((NotificationOriginatorImpl)this.notificationOriginator).removeNotificationLogListener((NotificationLogListener)this.notificationLogMIB);
                ((NotificationOriginatorImpl)this.notificationOriginator).addNotificationLogListener((NotificationLogListener)this.notificationLogMIB);
            }
        }

        protected void initSecurityModels() {
            this.usm = this.createUSM();
            SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
            this.frameworkMIB = new SnmpFrameworkMIB(this.usm, this.dispatcher.getTransportMappings());
        }

        protected void initMessageDispatcherWithMPs(MessageDispatcher mp) {
            PDUFactory pduFactory = new PDUFactory(){

                public PDU createPDU(Target target) {
                    return new KaazingPDU();
                }
            };
            mp.addMessageProcessingModel((MessageProcessingModel)new MPv1());
            mp.addMessageProcessingModel((MessageProcessingModel)new MPv2c(pduFactory));
            MPv3 mpv3 = new MPv3(this.agent.getContextEngineID().getValue(), pduFactory);
            mp.addMessageProcessingModel((MessageProcessingModel)mpv3);
        }

        protected void registerTransportMappings() {
            ArrayList l = new ArrayList(this.dispatcher.getTransportMappings());
            for (TransportMapping tm : l) {
                tm.removeTransportListener((TransportListener)this.dispatcher);
                tm.addTransportListener((TransportListener)this.dispatcher);
            }
        }

        protected void stopTransportMappings(Collection<TransportMapping> transportMappings) throws IOException {
            ArrayList<TransportMapping> l = new ArrayList<TransportMapping>(transportMappings);
            for (TransportMapping tm : l) {
                if (!tm.isListening()) continue;
                tm.close();
            }
        }

        public void configure() {
            if (this.configuration != null) {
                MOInput config = this.configuration.createMOInput();
                if (config == null) {
                    logger.debug("No configuration returned by configuration factory " + this.configuration);
                    return;
                }
                MOServerPersistence serverPersistence = new MOServerPersistence(this.servers);
                try {
                    serverPersistence.loadData(config);
                }
                catch (IOException ex) {
                    String txt = "Failed to load agent configuration: " + ex.getMessage();
                    logger.error(txt, (Throwable)ex);
                    throw new RuntimeException(txt, ex);
                }
                finally {
                    try {
                        config.close();
                    }
                    catch (IOException ex1) {
                        logger.warn("Failed to close config input stream: " + ex1.getMessage());
                    }
                }
            }
        }

        protected void initMandatoryMIBs() {
            this.targetMIB = new SnmpTargetMIB(this.dispatcher);
            this.targetMIB.addDefaultTDomains();
            this.targetMIB.addSupportedTDomain(ManagementTDomainAddressFactory.KaazingTransportDomain, (TDomainAddressFactory)new ManagementTDomainAddressFactory((DefaultServiceContext)SnmpManagementServiceHandler.this.serviceContext));
            this.snmpv2MIB = new SNMPv2MIB(this.getSysDescr(), this.getSysOID(), this.getSysServices());
            this.notificationMIB = new SnmpNotificationMIB();
            this.vacmMIB = new VacmMIB(this.servers);
            this.usmMIB = new UsmMIB(this.usm, this.getSupportedSecurityProtocols());
            this.usm.addUsmUserListener((UsmUserListener)this.usmMIB);
            this.communityMIB = new SnmpCommunityMIB(this.targetMIB);
            this.gatewayManagementMIB = new GatewayManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
            this.serviceManagementMIB = new ServiceManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
            this.sessionManagementMIB = new SessionManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
            this.gatewayConfigurationMIB = new GatewayConfigurationMIB(this.moFactory);
            this.jvmManagementMIB = new JVMManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
            this.systemManagementMIB = new SystemManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
            this.cpuManagementMIB = new CpuManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
            this.nicManagementMIB = new NicManagementMIB(SnmpManagementServiceHandler.this.managementContext, this.moFactory);
        }

        protected void linkCounterListener() {
            this.agent.removeCounterListener((CounterListener)this.snmpv2MIB);
            this.agent.addCounterListener((CounterListener)this.snmpv2MIB);
            this.usm.getCounterSupport().removeCounterListener((CounterListener)this.snmpv2MIB);
            this.usm.getCounterSupport().addCounterListener((CounterListener)this.snmpv2MIB);
        }

        protected SecurityProtocols getSupportedSecurityProtocols() {
            SecurityProtocols.getInstance().addDefaultProtocols();
            return SecurityProtocols.getInstance();
        }

        protected USM createUSM() {
            return new USM(this.getSupportedSecurityProtocols(), this.engineID, 1);
        }

        public Integer32 getSysServices() {
            return this.sysServices;
        }

        public OID getSysOID() {
            return this.sysOID;
        }

        public OctetString getSysDescr() {
            return this.sysDescr;
        }

        public SysUpTime getSysUpTime() {
            return this.snmpv2MIB.getSysUpTime();
        }

        public NotificationOriginator getNotificationOriginator() {
            return this.notificationOriginator;
        }

        public NotificationOriginator getAgentNotificationOriginator() {
            return this.agent.getNotificationOriginator();
        }

        public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
            this.notificationOriginator = notificationOriginator;
            if (this.agent != null) {
                this.agent.setNotificationOriginator(notificationOriginator);
            }
        }

        private VACM vacm() {
            if (this.vacm != null) {
                return this.vacm;
            }
            return this.vacmMIB;
        }

        public void initialize() {
            this.snmpSession = this.createSnmpSession(this.dispatcher);
            if (this.engineID == null) {
                this.engineID = new OctetString(MPv3.createLocalEngineID());
            }
            this.agent = this.createCommandProcessor(this.engineID);
            this.initSecurityModels();
            this.initMessageDispatcherWithMPs(this.dispatcher);
            this.initMandatoryMIBs();
            this.linkCounterListener();
            this.agent.setVacm(this.vacm());
            for (MOServer server1 : this.servers) {
                this.agent.addMOServer(server1);
            }
            this.agent.setCoexistenceProvider((CoexistenceInfoProvider)this.communityMIB);
            if (this.notificationOriginator == null) {
                this.notificationOriginator = this.createNotificationOriginator();
            }
            this.agent.setNotificationOriginator(this.notificationOriginator);
            this.snmpv2MIB.setNotificationOriginator((NotificationOriginator)this.agent);
            this.initOptionalMIBs();
            try {
                this.registerMIBs(this.getDefaultContext());
            }
            catch (DuplicateRegistrationException drex) {
                logger.error("Duplicate MO registration: " + drex.getMessage(), (Throwable)drex);
            }
        }

        public void setTableSizeLimits(Properties sizeLimits) {
            if (this.tableSizeLimit != null && this.servers != null) {
                for (MOServer server1 : this.servers) {
                    DefaultMOServer.unregisterTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
                }
            }
            this.tableSizeLimit = new MOTableSizeLimit(sizeLimits);
            for (MOServer server1 : this.servers) {
                DefaultMOServer.registerTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
            }
        }

        public void setTableSizeLimit(int sizeLimit) {
            if (this.tableSizeLimit != null && this.servers != null) {
                for (MOServer server1 : this.servers) {
                    DefaultMOServer.unregisterTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
                }
            }
            this.tableSizeLimit = new MOTableSizeLimit(sizeLimit);
            for (MOServer server1 : this.servers) {
                DefaultMOServer.registerTableRowListener((MOServer)server1, (MOTableRowListener)this.tableSizeLimit);
            }
        }

        protected void initOptionalMIBs() {
            this.initSnmp4jLogMIB();
            this.initSnmp4jConfigMIB(null);
            if (this.vacm() != null && this.notificationMIB != null) {
                this.initNotificationLogMIB(this.vacm(), this.notificationMIB);
            }
        }

        public OctetString getDefaultContext() {
            return this.defaultContext;
        }

        protected OctetString getContext(MOGroup mibGroup, OctetString defaultContext) {
            return defaultContext;
        }

        protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
            MOServer server = this.agent.getServer(context);
            this.targetMIB.registerMOs(server, this.getContext((MOGroup)this.targetMIB, context));
            this.notificationMIB.registerMOs(server, this.getContext((MOGroup)this.notificationMIB, context));
            this.vacmMIB.registerMOs(server, this.getContext((MOGroup)this.vacmMIB, context));
            this.usmMIB.registerMOs(server, this.getContext((MOGroup)this.usmMIB, context));
            this.snmpv2MIB.registerMOs(server, this.getContext((MOGroup)this.snmpv2MIB, context));
            this.frameworkMIB.registerMOs(server, this.getContext((MOGroup)this.frameworkMIB, context));
            this.communityMIB.registerMOs(server, this.getContext((MOGroup)this.communityMIB, context));
            this.gatewayManagementMIB.registerMOs(server, this.getContext(this.gatewayManagementMIB, context));
            this.serviceManagementMIB.registerMOs(server, this.getContext(this.serviceManagementMIB, context));
            this.sessionManagementMIB.registerMOs(server, this.getContext(this.sessionManagementMIB, context));
            this.gatewayConfigurationMIB.registerMOs(server, this.getContext(this.gatewayConfigurationMIB, context));
            this.jvmManagementMIB.registerMOs(server, this.getContext(this.jvmManagementMIB, context));
            this.systemManagementMIB.registerMOs(server, this.getContext(this.systemManagementMIB, context));
            this.cpuManagementMIB.registerMOs(server, this.getContext(this.cpuManagementMIB, context));
            this.nicManagementMIB.registerMOs(server, this.getContext(this.nicManagementMIB, context));
            if (this.snmp4jLogMIB != null) {
                this.snmp4jLogMIB.registerMOs(server, this.getContext((MOGroup)this.snmp4jLogMIB, context));
            }
            if (this.snmp4jConfigMIB != null) {
                this.snmp4jConfigMIB.registerMOs(server, this.getContext((MOGroup)this.snmp4jConfigMIB, context));
            }
            if (this.proxyMIB != null) {
                this.proxyMIB.registerMOs(server, this.getContext((MOGroup)this.proxyMIB, context));
            }
            if (this.notificationLogMIB != null) {
                this.notificationLogMIB.registerMOs(server, this.getContext((MOGroup)this.notificationLogMIB, context));
            }
        }

        protected void unregisterMIBs(OctetString context) {
            MOServer server = this.agent.getServer(context);
            this.targetMIB.unregisterMOs(server, this.getContext((MOGroup)this.targetMIB, context));
            this.notificationMIB.unregisterMOs(server, this.getContext((MOGroup)this.notificationMIB, context));
            this.vacmMIB.unregisterMOs(server, this.getContext((MOGroup)this.vacmMIB, context));
            this.usmMIB.unregisterMOs(server, this.getContext((MOGroup)this.usmMIB, context));
            this.snmpv2MIB.unregisterMOs(server, this.getContext((MOGroup)this.snmpv2MIB, context));
            this.frameworkMIB.unregisterMOs(server, this.getContext((MOGroup)this.frameworkMIB, context));
            this.communityMIB.unregisterMOs(server, this.getContext((MOGroup)this.communityMIB, context));
            this.gatewayManagementMIB.unregisterMOs(server, this.getContext(this.gatewayManagementMIB, context));
            this.serviceManagementMIB.unregisterMOs(server, this.getContext(this.serviceManagementMIB, context));
            this.sessionManagementMIB.unregisterMOs(server, this.getContext(this.sessionManagementMIB, context));
            this.gatewayConfigurationMIB.unregisterMOs(server, this.getContext(this.gatewayConfigurationMIB, context));
            this.jvmManagementMIB.unregisterMOs(server, this.getContext(this.jvmManagementMIB, context));
            this.systemManagementMIB.unregisterMOs(server, this.getContext(this.systemManagementMIB, context));
            this.cpuManagementMIB.unregisterMOs(server, this.getContext(this.cpuManagementMIB, context));
            this.nicManagementMIB.unregisterMOs(server, this.getContext(this.nicManagementMIB, context));
            if (this.snmp4jLogMIB != null) {
                this.snmp4jLogMIB.unregisterMOs(server, this.getContext((MOGroup)this.snmp4jLogMIB, context));
            }
            if (this.snmp4jConfigMIB != null) {
                this.snmp4jConfigMIB.unregisterMOs(server, this.getContext((MOGroup)this.targetMIB, context));
            }
            if (this.proxyMIB != null) {
                this.proxyMIB.unregisterMOs(server, this.getContext((MOGroup)this.proxyMIB, context));
            }
            if (this.notificationLogMIB != null) {
                this.notificationLogMIB.unregisterMOs(server, this.getContext((MOGroup)this.notificationLogMIB, context));
            }
        }

        public void setupProxyForwarder() {
            this.proxyForwarder = this.createProxyForwarder(this.agent);
        }

        protected NotificationOriginator createNotificationOriginator() {
            return new NotificationOriginatorImpl(this.snmpSession, this.vacm(), this.snmpv2MIB.getSysUpTime(), this.targetMIB, this.notificationMIB);
        }

        protected ProxyForwarder createProxyForwarder(CommandProcessor agent) {
            this.proxyMIB = new SnmpProxyMIB();
            ProxyForwarderImpl pf = new ProxyForwarderImpl(this.snmpSession, this.proxyMIB, this.targetMIB);
            agent.addProxyForwarder((ProxyForwarder)pf, null, 0);
            pf.addCounterListener((CounterListener)this.snmpv2MIB);
            return this.proxyForwarder;
        }

        protected CommandProcessor createCommandProcessor(OctetString engineID) {
            KaazingCommandProcessor cp = new KaazingCommandProcessor(engineID);
            return cp;
        }

        protected Session createSnmpSession(MessageDispatcher dispatcher) {
            return new Snmp(dispatcher);
        }

        public void setPersistenceImportMode(int importMode) {
            this.persistenceImportMode = importMode;
        }

        public int getPersistenceImportMode() {
            return this.persistenceImportMode;
        }

        public OID addGatewayBean(GatewayManagementBean gatewayBean) {
            OID gatewayOID = this.gatewayManagementMIB.addGatewayBean(gatewayBean);
            this.gatewayConfigurationMIB.addVersionInfo(gatewayBean);
            return gatewayOID;
        }

        public void removeGatewayBean(OID gatewayOID) {
            this.gatewayManagementMIB.removeGatewayBean(gatewayOID);
        }

        public OID addServiceBean(ServiceManagementBean serviceBean) {
            return this.serviceManagementMIB.addServiceBean(serviceBean);
        }

        public void removeServiceBean(OID oid) {
            this.serviceManagementMIB.removeServiceBean(oid);
        }

        public OID addSessionBean(SessionManagementBean sessionBean) {
            OID sessionOID = this.sessionManagementMIB.addSessionBean(sessionBean);
            return sessionOID;
        }

        public void removeSessionBean(OID oid) {
            this.sessionManagementMIB.removeSessionBean(oid);
        }

        public void addClusterConfigurationBean(ClusterConfigurationBean clusterConfigurationBean) {
            this.gatewayConfigurationMIB.addClusterConfiguration(clusterConfigurationBean);
        }

        public void addNetworkConfigurationBean(NetworkConfigurationBean networkConfigurationBean) {
            this.gatewayConfigurationMIB.addNetworkConfiguration(networkConfigurationBean);
        }

        public void addSecurityBean(SecurityConfigurationBean securityBean) {
            this.gatewayConfigurationMIB.addSecurityConfiguration(securityBean);
        }

        public void addRealmBean(RealmConfigurationBean realmBean) {
            this.gatewayConfigurationMIB.addRealmConfiguration(realmBean);
        }

        public void addServiceConfigurationBean(ServiceConfigurationBean serviceConfigurationBean) {
            this.gatewayConfigurationMIB.addServiceConfiguration(serviceConfigurationBean);
        }

        public void addServiceDefaultsConfigurationBean(ServiceDefaultsConfigurationBean serviceDefaultsConfigurationBean) {
            this.gatewayConfigurationMIB.addServiceDefaultsConfiguration(serviceDefaultsConfigurationBean);
        }

        public void addVersionInfo(GatewayManagementBean gatewayManagementBean) {
            this.gatewayConfigurationMIB.addVersionInfo(gatewayManagementBean);
        }

        public void addSystemManagementBean(HostManagementBean systemManagementBean) {
            this.systemManagementMIB.addSystemManagementBean(systemManagementBean);
        }

        public void addCpuListManagementBean(CpuListManagementBean cpuListManagementBean) {
            this.cpuManagementMIB.addCpuListManagementBean(cpuListManagementBean);
        }

        public void addNicListManagementBean(NicListManagementBean nicListManagementBean) {
            this.nicManagementMIB.addNicListManagementBean(nicListManagementBean);
        }

        public void addCpuManagementBean(CpuManagementBean cpuManagementBean) {
            this.cpuManagementMIB.addCpuManagementBean(cpuManagementBean);
        }

        public void addNicManagementBean(NicManagementBean nicManagementBean) {
            this.nicManagementMIB.addNicManagementBean(nicManagementBean);
        }

        public void addJvmManagementBean(JvmManagementBean jvmManagementBean) {
            this.jvmManagementMIB.addJvmManagementBean(jvmManagementBean);
        }

        class KaazingCommandProcessor
        extends CommandProcessor {
            private final KaazingSubscribeNotifHandler notifHandler;
            private final GetSubtreeHandler getSubtreeHandler;

            public KaazingCommandProcessor(OctetString contextEngineID) {
                super(contextEngineID);
                this.notifHandler = new KaazingSubscribeNotifHandler();
                this.getSubtreeHandler = new GetSubtreeHandler();
                this.addPduHandler(this.getSubtreeHandler);
                this.addPduHandler(this.notifHandler);
            }

            class GetSubtreeHandler
            implements RequestHandler {
                GetSubtreeHandler() {
                }

                public void processPdu(Request request, MOServer server) {
                    block6: {
                        if (request.getPhase() == -1) {
                            request.nextPhase();
                        }
                        OctetString context = request.getContext();
                        SnmpRequest req = (SnmpRequest)request;
                        try {
                            SubRequestIterator it = (SubRequestIterator)request.iterator();
                            while (it.hasNext()) {
                                SubRequest sreq = it.nextSubRequest();
                                if (sreq.isComplete()) continue;
                                DefaultMOContextScope scope = (DefaultMOContextScope)sreq.getScope();
                                OID lowerBound = (OID)scope.getLowerBound().clone();
                                scope.setLowerIncluded(false);
                                OID upperBound = lowerBound.nextPeer();
                                scope.setUpperBound(upperBound);
                                scope.setUpperIncluded(false);
                                KaazingCommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                                if (sreq.getStatus().getErrorStatus() != 0) continue;
                                VariableBinding initialVB = (VariableBinding)sreq.getVariableBinding().clone();
                                scope.setLowerIncluded(false);
                                boolean first = true;
                                while (!sreq.getVariableBinding().getVariable().equals((Object)Null.endOfMibView)) {
                                    sreq.getStatus().setPhaseComplete(false);
                                    sreq.getStatus().setProcessed(false);
                                    sreq.setQuery(null);
                                    scope.setLowerBound(sreq.getVariableBinding().getOid());
                                    if (!first) {
                                        VariableBinding vb = (VariableBinding)sreq.getVariableBinding().clone();
                                        ((KaazingPDU)((Object)req.getResponse())).add(vb);
                                    }
                                    first = false;
                                    KaazingCommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                                    if (sreq.getStatus().getErrorStatus() == 0) continue;
                                }
                                sreq.getVariableBinding().setOid(initialVB.getOid());
                                sreq.getVariableBinding().setVariable(initialVB.getVariable());
                                sreq.getStatus().setPhaseComplete(true);
                                sreq.getStatus().setProcessed(true);
                            }
                        }
                        catch (NoSuchElementException nsex) {
                            if (!logger.isDebugEnabled()) break block6;
                            logger.debug("GETSUBTREE request response PDU size limit reached");
                        }
                    }
                }

                public boolean isSupported(int pduType) {
                    return pduType == -85;
                }
            }

            class KaazingSubscribeNotifHandler
            implements RequestHandler {
                KaazingSubscribeNotifHandler() {
                }

                public void processPdu(Request request, MOServer server) {
                    CommandResponderEvent commandEvent;
                    Address addr;
                    Object source = request.getSource();
                    if (source instanceof CommandResponderEvent && (addr = (commandEvent = (CommandResponderEvent)source).getPeerAddress()) instanceof ManagementAddress) {
                        ManagementAddress managementAddress = (ManagementAddress)addr;
                        IoSessionEx session = managementAddress.getSession();
                        OctetString name = SnmpManagementServiceHandler.this.generateNotificationTargetAddressName(session.getId());
                        OID transportDomain = ManagementTDomainAddressFactory.KaazingTransportDomain;
                        OctetString address = new OctetString(Long.toString(session.getId()));
                        OctetString tagList = new OctetString("notify");
                        OctetString params = new OctetString(SnmpManagementServiceHandler.NOTIF_TARGET_PARAM_NAME);
                        int storageType = 4;
                        SnmpManagementServiceHandler.this.agent.getSnmpTargetMIB().addTargetAddress(name, transportDomain, address, 250, 1, tagList, params, storageType);
                    }
                }

                public boolean isSupported(int pduType) {
                    return pduType == -86;
                }
            }
        }
    }
}

