/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.transport;

import org.kaazing.gateway.management.snmp.transport.ManagementAddress;
import org.kaazing.gateway.server.context.resolve.DefaultServiceContext;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class ManagementTDomainAddressFactory
implements TDomainAddressFactory {
    private static final Logger logger = LoggerFactory.getLogger(ManagementTDomainAddressFactory.class);
    public static final OID KaazingTransportDomain = new OID("1.3.6.1.2.1.100.1.'kaazing'");
    private final DefaultServiceContext serviceContext;

    public ManagementTDomainAddressFactory(DefaultServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public Address createAddress(OID transportDomain, OctetString address) {
        String sessionIdString = new String(address.getValue());
        try {
            long sessionId = Long.parseLong(sessionIdString);
            IoSessionEx session = this.serviceContext.getActiveSession(Long.valueOf(sessionId));
            if (session != null) {
                return new ManagementAddress(session);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Attempting to create a ManagementAddress for a non-existent session: " + sessionIdString);
            }
        }
        catch (NumberFormatException ex) {
            logger.warn("Received an invalid address: " + sessionIdString + " for creating a ManagementAddress.");
        }
        return null;
    }

    public OctetString getAddress(Address address) {
        if (address == null || !(address instanceof ManagementAddress)) {
            return null;
        }
        ManagementAddress managementAddress = (ManagementAddress)address;
        long sessionId = managementAddress.getSession().getId();
        return new OctetString(Long.toString(sessionId));
    }

    public OID getTransportDomain(Address address) {
        if (address instanceof ManagementAddress) {
            return KaazingTransportDomain;
        }
        return null;
    }

    public boolean isValidAddress(OID transportDomain, OctetString address) {
        if (KaazingTransportDomain.equals((Object)transportDomain)) {
            String sessionIdString = address.toString();
            try {
                long sessionId = Long.parseLong(sessionIdString);
                if (this.serviceContext.getActiveSession(Long.valueOf(sessionId)) != null) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

