/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.Uptime;
import org.kaazing.gateway.management.ManagementService;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.jmx.JmxManagementServiceHandler;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.server.Launcher;
import org.kaazing.gateway.server.context.resolve.DefaultSecurityContext;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxManagementService
implements ManagementService,
NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(JmxManagementService.class);
    private DefaultSecurityContext securityContext;
    private ManagementContext managementContext;
    private JMXConnectorServer connectorServer;
    private MBeanServer mbeanServer;
    private Properties configuration;
    private boolean systemStatsSupported = true;
    private static Registry sRMIRegistry;
    private JmxManagementServiceHandler handler;
    private ServiceContext serviceContext;

    public void destroy() throws Exception {
    }

    @Override
    public void init() {
    }

    public String getType() {
        return "management.jmx";
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    @Resource(name="securityContext")
    public void setSecurityContext(DefaultSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Resource(name="mbeanServer")
    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Resource(name="managementContext")
    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    private MBeanServer getMBeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbeanServer;
    }

    public void init(ServiceContext serviceContext) throws Exception {
        try {
            Sigar sigar = new Sigar();
            Uptime uptime = sigar.getUptime();
        }
        catch (Throwable t) {
            logger.info("JMX management service: Unable to access system-level management statistics");
            logger.info("   (CPU, NIC, System data). Management will continue without them.");
            this.systemStatsSupported = false;
        }
        this.serviceContext = serviceContext;
        this.handler = new JmxManagementServiceHandler(serviceContext, this.managementContext, this.getMBeanServer());
        this.managementContext.setManagementSessionThreshold(InternalSystemProperty.MANAGEMENT_SESSION_THRESHOLD.getIntProperty(this.configuration));
        this.managementContext.addManagementServiceHandler(this.handler);
        this.managementContext.setActive(true);
    }

    public void start() throws Exception {
        this.managementContext.updateManagementContext((SecurityContext)this.securityContext);
        if (this.connectorServer != null) {
            throw new IllegalStateException("Already started");
        }
        URI uri = null;
        ServiceProperties properties = this.serviceContext.getProperties();
        String connectorServerAddress = properties.get("connector.server.address");
        uri = connectorServerAddress != null ? new URI(connectorServerAddress) : new URI("jmx://localhost:2020");
        int port = uri.getPort();
        if (port == -1) {
            port = 2020;
        }
        if (sRMIRegistry == null) {
            sRMIRegistry = LocateRegistry.createRegistry(port);
        }
        RealmContext serviceRealmContext = this.serviceContext.getServiceRealm();
        KeyStore keyStore = this.securityContext.getKeyStore();
        if (keyStore != null) {
            System.setProperty("javax.net.ssl.keyStore", this.securityContext.getKeyStoreFilePath());
            System.setProperty("javax.net.ssl.keyStoreType", keyStore.getType());
            char[] keyStorePassword = this.securityContext.getKeyStorePassword();
            if (keyStorePassword != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", new String(keyStorePassword));
            }
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
        SslRMIServerSocketFactory ssf = new SslRMIServerSocketFactory();
        env.put("jmx.remote.rmi.client.socket.factory", csf);
        env.put("jmx.remote.rmi.server.socket.factory", ssf);
        env.put("jmx.remote.authenticator", new RealmJMXAuthenticator(serviceRealmContext));
        JMXServiceURL serviceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + uri.getHost() + ":" + port + "/jmxrmi");
        MBeanServer mbeanServer = this.getMBeanServer();
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, env, mbeanServer);
        List<String> requiredRoles = Arrays.asList(this.serviceContext.getRequireRoles());
        this.connectorServer.setMBeanServerForwarder(MBSFInvocationHandler.newProxyInstance(requiredRoles));
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("jmx.remote.connection.opened");
        filter.enableType("jmx.remote.connection.closed");
        this.connectorServer.addNotificationListener(this, filter, null);
        this.connectorServer.start();
        Logger startupLogger = Launcher.getGatewayStartupLogger();
        startupLogger.info(String.format("JMX Management service started with URI %s with service URI %s", uri, serviceURL.toString()));
    }

    public void quiesce() throws Exception {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String notificationType = notification.getType();
        if (notificationType.equals("jmx.remote.connection.opened")) {
            this.managementContext.incrementManagementSessionCount();
        } else if (notificationType.equals("jmx.remote.connection.closed")) {
            this.managementContext.decrementManagementSessionCount();
        }
    }

    public void stop() throws Exception {
        this.quiesce();
        ServiceProperties properties = this.serviceContext.getProperties();
        String connectorServerAddress = properties.get("connector.server.address");
        if (connectorServerAddress == null) {
            connectorServerAddress = "jmx://localhost:2020";
        }
        Logger startupLogger = Launcher.getGatewayStartupLogger();
        startupLogger.info(String.format("Stopping JMX Management service with URI %s", connectorServerAddress));
        this.handler.cleanupRegisteredBeans();
        if (this.connectorServer != null) {
            this.connectorServer.stop();
            this.connectorServer = null;
        }
        if (sRMIRegistry != null) {
            UnicastRemoteObject.unexportObject(sRMIRegistry, true);
            sRMIRegistry = null;
        }
    }

    private static class MBSFInvocationHandler
    implements InvocationHandler {
        private MBeanServer mbs;
        private final Collection<String> requiredRoles;

        public MBSFInvocationHandler(Collection<String> requiredRoles) {
            this.requiredRoles = requiredRoles;
        }

        public static MBeanServerForwarder newProxyInstance(Collection<String> requiredRoles) {
            MBSFInvocationHandler handler = new MBSFInvocationHandler(requiredRoles);
            Class[] interfaces = new Class[]{MBeanServerForwarder.class};
            Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, (InvocationHandler)handler);
            return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getMBeanServer")) {
                return this.mbs;
            }
            if (methodName.equals("setMBeanServer")) {
                if (args[0] == null) {
                    throw new IllegalArgumentException("Null MBeanServer");
                }
                if (this.mbs != null) {
                    throw new IllegalArgumentException("MBeanServer object already initialized");
                }
                this.mbs = (MBeanServer)args[0];
                return null;
            }
            AccessControlContext acc = AccessController.getContext();
            Subject subject = Subject.getSubject(acc);
            if (subject == null) {
                return method.invoke((Object)this.mbs, args);
            }
            if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
                throw new SecurityException("Access denied");
            }
            if (this.requiredRoles.contains("*")) {
                return method.invoke((Object)this.mbs, args);
            }
            Set<Principal> principals = subject.getPrincipals();
            if (principals == null || principals.isEmpty()) {
                throw new SecurityException("Access denied");
            }
            HashSet<String> authorizedRoles = new HashSet<String>();
            for (Principal principal : principals) {
                authorizedRoles.add(principal.getName());
            }
            if (authorizedRoles.containsAll(this.requiredRoles)) {
                return method.invoke((Object)this.mbs, args);
            }
            throw new SecurityException("Access denied");
        }
    }

    private static class RealmJMXAuthenticator
    implements JMXAuthenticator {
        private final RealmContext realm;

        public RealmJMXAuthenticator(RealmContext realm) {
            this.realm = realm;
        }

        @Override
        public Subject authenticate(Object credentialsAsObject) {
            if (!(credentialsAsObject instanceof String[])) {
                if (credentialsAsObject == null) {
                    throw new SecurityException("Credentials required");
                }
                throw new SecurityException("Credentials should be String[]");
            }
            String[] credentials = (String[])credentialsAsObject;
            if (credentials.length != 2) {
                throw new SecurityException("Credentials should have 2 elements");
            }
            String username = credentials[0];
            String password = credentials[1];
            try {
                Subject subject = new Subject();
                LoginContext loginContext = this.realm.getLoginContextFactory().createLoginContext(subject, username, password.toCharArray());
                loginContext.login();
                return subject;
            }
            catch (LoginException e) {
                throw new SecurityException("Invalid credentials");
            }
        }
    }
}

