/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.transport.ManagementTransport;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public class ManagementUdpTransport
extends ManagementTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementUdpTransport.class);
    private final ServiceContext serviceContext;
    private final UdpConnectHandler connectHandler;

    public ManagementUdpTransport(ServiceContext serviceContext, ManagementContext managementContext) {
        super(managementContext);
        this.serviceContext = serviceContext;
        this.connectHandler = new UdpConnectHandler();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Class getSupportedAddressClass() {
        return UdpAddress.class;
    }

    @Override
    public void sendMessage(final Address address, final byte[] message) throws IOException {
        if (address instanceof UdpAddress) {
            UdpAddress udpAddress = (UdpAddress)address;
            try {
                URI connectURI = new URI("udp://" + udpAddress.getInetAddress().getHostAddress() + ":" + udpAddress.getPort());
                ConnectFuture future = this.serviceContext.connect(connectURI, (IoHandler)this.connectHandler, null);
                future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                    public void operationComplete(ConnectFuture future) {
                        if (future.isConnected()) {
                            final IoSessionEx session = (IoSessionEx)future.getSession();
                            ByteBuffer b = ByteBuffer.wrap(message);
                            IoBufferEx buf = session.getBufferAllocator().wrap(b);
                            WriteFuture writeFuture = session.write((Object)buf);
                            writeFuture.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                                public void operationComplete(WriteFuture writeFuture) {
                                    if (writeFuture.isWritten()) {
                                        if (LOGGER.isTraceEnabled()) {
                                            LOGGER.trace("SNMP write operation completed, bytes written: " + message.length);
                                        }
                                    } else if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug("SNMP write failure to address: " + address.toString());
                                    }
                                    session.close(false);
                                }
                            });
                        }
                    }
                });
            }
            catch (URISyntaxException ex) {
                throw new IOException("Unable to send message to address: " + udpAddress, ex);
            }
        }
    }

    private class UdpConnectHandler
    extends IoHandlerAdapter {
        private UdpConnectHandler() {
        }
    }
}

