/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.snmp.transport.ManagementTransport;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;

public class ManagementTcpTransport
extends ManagementTransport {
    private final ServiceContext serviceContext;
    private final TcpConnectHandler tcpConnectHandler;

    public ManagementTcpTransport(ServiceContext serviceContext, ManagementContext managementContext) {
        super(managementContext);
        this.serviceContext = serviceContext;
        this.tcpConnectHandler = new TcpConnectHandler();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Class getSupportedAddressClass() {
        return TcpAddress.class;
    }

    @Override
    public void sendMessage(Address address, final byte[] message) throws IOException {
        if (address instanceof TcpAddress) {
            TcpAddress tcpAddress = (TcpAddress)address;
            try {
                URI connectURI = new URI("tcp://" + tcpAddress.getInetAddress().getHostAddress() + ":" + tcpAddress.getPort());
                ConnectFuture future = this.serviceContext.connect(connectURI, (IoHandler)this.tcpConnectHandler, null);
                future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                    public void operationComplete(ConnectFuture future) {
                        if (future.isConnected()) {
                            IoSessionEx session = (IoSessionEx)future.getSession();
                            ByteBuffer b = ByteBuffer.wrap(message);
                            IoBufferEx buf = session.getBufferAllocator().wrap(b);
                            WriteFuture writeFuture = session.write((Object)buf);
                            writeFuture.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                                public void operationComplete(WriteFuture writeFuture) {
                                    if (writeFuture.isWritten()) {
                                        // empty if block
                                    }
                                }
                            });
                        }
                    }
                });
            }
            catch (URISyntaxException ex) {
                throw new IOException("Unable to send message to address: " + tcpAddress, ex);
            }
        }
    }

    private class TcpConnectHandler
    extends IoHandlerAdapter {
        private TcpConnectHandler() {
        }
    }
}

