/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.config;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.server.context.ServiceDefaultsContext;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.service.ConnectOptionsContext;
import org.kaazing.gateway.util.Utils;

public class ServiceDefaultsConfigurationBeanImpl
implements ServiceDefaultsConfigurationBean {
    private static final AtomicInteger serviceDefaultsIds = new AtomicInteger(0);
    private final ServiceDefaultsContext serviceDefaultsContext;
    private final GatewayManagementBean gatewayBean;
    private final int id;

    public ServiceDefaultsConfigurationBeanImpl(ServiceDefaultsContext serviceDefaultsContext, GatewayManagementBean gatewayBean) {
        this.serviceDefaultsContext = serviceDefaultsContext;
        this.gatewayBean = gatewayBean;
        this.id = serviceDefaultsIds.incrementAndGet();
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayBean;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getAcceptOptions() {
        JSONObject jsonOptions = new JSONObject();
        AcceptOptionsContext context = this.serviceDefaultsContext.getAcceptOptionsContext();
        try {
            if (context != null) {
                URI httpTransport;
                URI sslTransport;
                URI tcpTransport;
                URI pipeTransport;
                boolean isSslEncryptionEnabled;
                String[] sslCiphers;
                Map acceptOptions = context.asOptionsMap();
                Map binds = context.getBinds();
                if (binds != null && !binds.isEmpty()) {
                    JSONObject jsonObj = new JSONObject();
                    for (String key : binds.keySet()) {
                        jsonObj.put(key, binds.get(key));
                    }
                    jsonOptions.put("binds", (Object)jsonObj);
                }
                if ((sslCiphers = (String[])acceptOptions.remove("ssl.ciphers")) != null && sslCiphers.length > 0) {
                    jsonOptions.put("ssl.ciphers", (Object)Utils.asCommaSeparatedString(Arrays.asList(sslCiphers)));
                }
                jsonOptions.put("ssl.encryption", (Object)((isSslEncryptionEnabled = ((Boolean)acceptOptions.remove("ssl.encryptionEnabled")).booleanValue()) ? "enabled" : "disabled"));
                boolean wantClientAuth = (Boolean)acceptOptions.remove("ssl.wantClientAuth");
                boolean needClientAuth = (Boolean)acceptOptions.remove("ssl.needClientAuth");
                if (needClientAuth) {
                    jsonOptions.put("ssl.verify-client", (Object)"required");
                } else if (wantClientAuth) {
                    jsonOptions.put("ssl.verify-client", (Object)"optional");
                } else {
                    jsonOptions.put("ssl.verify-client", (Object)"none");
                }
                jsonOptions.put("ws.maximum.message.size", acceptOptions.remove("ws.maxMessageSize"));
                Integer httpKeepAlive = (Integer)acceptOptions.remove("http[http/1.1].keepAliveTimeout");
                if (httpKeepAlive != null) {
                    jsonOptions.put("http.keepalive.timeout", (Object)httpKeepAlive);
                }
                if ((pipeTransport = (URI)acceptOptions.remove("pipe.transport")) != null) {
                    jsonOptions.put("pipe.transport", (Object)pipeTransport.toString());
                }
                if ((tcpTransport = (URI)acceptOptions.remove("tcp.transport")) != null) {
                    jsonOptions.put("tcp.transport", (Object)tcpTransport.toString());
                }
                if ((sslTransport = (URI)acceptOptions.remove("ssl.transport")) != null) {
                    jsonOptions.put("ssl.transport", (Object)sslTransport.toString());
                }
                if ((httpTransport = (URI)acceptOptions.remove("http.transport")) != null) {
                    jsonOptions.put("http.transport", (Object)httpTransport.toString());
                }
                long tcpMaxOutboundRate = (Long)acceptOptions.remove("tcp.maximumOutboundRate");
                jsonOptions.put("tcp.maximum.outbound.rate", tcpMaxOutboundRate);
                for (Map.Entry entry : acceptOptions.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.startsWith("ws") && (key.endsWith("maxMessageSize") || key.endsWith("inactivityTimeout") || key.endsWith("extensions"))) continue;
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        jsonOptions.put(key, (Object)Utils.asCommaSeparatedString(Arrays.asList((String[])value)));
                        continue;
                    }
                    jsonOptions.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonOptions.toString();
    }

    @Override
    public String getConnectOptions() {
        ConnectOptionsContext context = this.serviceDefaultsContext.getConnectOptionsContext();
        JSONObject jsonOptions = new JSONObject();
        try {
            if (context != null) {
                URI httpTransport;
                URI sslTransport;
                URI tcpTransport;
                URI pipeTransport;
                String wsVersion;
                List<String> sslCiphers;
                Map connectOptions = context.asOptionsMap();
                String[] sslCiphersArray = (String[])connectOptions.remove("ssl.ciphers");
                if (sslCiphersArray != null && (sslCiphers = Arrays.asList(sslCiphersArray)).size() > 0) {
                    jsonOptions.put("ssl.ciphers", sslCiphers);
                }
                if ((wsVersion = (String)connectOptions.remove("ws.version")) != null) {
                    jsonOptions.put("ws.version", (Object)wsVersion);
                }
                if ((pipeTransport = (URI)connectOptions.remove("pipe.transport")) != null) {
                    jsonOptions.put("pipe.transport", (Object)pipeTransport.toString());
                }
                if ((tcpTransport = (URI)connectOptions.remove("tcp.transport")) != null) {
                    jsonOptions.put("tcp.transport", (Object)tcpTransport.toString());
                }
                if ((sslTransport = (URI)connectOptions.remove("ssl.transport")) != null) {
                    jsonOptions.put("ssl.transport", (Object)sslTransport.toString());
                }
                if ((httpTransport = (URI)connectOptions.remove("http.transport")) != null) {
                    jsonOptions.put("http.transport", (Object)httpTransport.toString());
                }
                for (Map.Entry entry : connectOptions.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        jsonOptions.put(key, (Object)Utils.asCommaSeparatedString(Arrays.asList((String[])value)));
                        continue;
                    }
                    jsonOptions.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonOptions.toString();
    }

    @Override
    public String getMimeMappings() {
        JSONObject jsonObj = new JSONObject();
        try {
            Map mimeMappings = this.serviceDefaultsContext.getMimeMappings();
            if (mimeMappings != null) {
                for (String extension : mimeMappings.keySet()) {
                    jsonObj.put(extension, mimeMappings.get(extension));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObj.toString();
    }
}

