/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import org.hyperic.sigar.SigarException;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.system.AbstractSystemManagementBean;
import org.kaazing.gateway.management.system.HostManagementBean;
import org.kaazing.gateway.management.system.SystemDataProvider;

public class HostManagementBeanImpl
extends AbstractSystemManagementBean
implements HostManagementBean {
    private final GatewayManagementBean gatewayManagementBean;
    private boolean errorShown;
    private String osName = "Unknown";
    private double uptimeSeconds;
    private long totalFreeMemory;
    private long totalUsedMemory;
    private long totalMemory;
    private long totalFreeSwap;
    private long totalUsedSwap;
    private long totalSwap;
    private double cpuPercentage;

    public HostManagementBeanImpl(GatewayManagementBean gatewayManagementBean) {
        super(gatewayManagementBean.getManagementContext(), gatewayManagementBean.getManagementContext().getSystemSummaryDataNotificationInterval(), HostManagementBean.SUMMARY_DATA_FIELD_LIST, gatewayManagementBean.getManagementContext().getSystemSummaryDataGatherInterval(), "system stats", "SNMPHostSummaryData");
        this.gatewayManagementBean = gatewayManagementBean;
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayManagementBean;
    }

    @Override
    public String getOSName() {
        return this.osName;
    }

    @Override
    public double getUptimeSeconds() {
        return this.uptimeSeconds;
    }

    @Override
    public long getTotalFreeMemory() {
        return this.totalFreeMemory;
    }

    @Override
    public long getTotalUsedMemory() {
        return this.totalUsedMemory;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemory;
    }

    @Override
    public long getTotalFreeSwap() {
        return this.totalFreeSwap;
    }

    @Override
    public long getTotalUsedSwap() {
        return this.totalUsedSwap;
    }

    @Override
    public long getTotalSwap() {
        return this.totalSwap;
    }

    @Override
    public double getCpuPercentage() {
        return this.cpuPercentage;
    }

    @Override
    public void doGatherStats(JSONObject jsonObj, long readTime) throws SigarException, JSONException {
        SystemDataProvider systemDataProvider = this.managementContext.getSystemDataProvider();
        this.uptimeSeconds = systemDataProvider.getUptimeSeconds();
        this.totalFreeMemory = systemDataProvider.getTotalFreeMemory();
        this.totalUsedMemory = systemDataProvider.getTotalUsedMemory();
        this.totalMemory = systemDataProvider.getTotalMemory();
        this.totalFreeSwap = systemDataProvider.getTotalFreeSwap();
        this.totalUsedSwap = systemDataProvider.getTotalUsedSwap();
        this.totalSwap = systemDataProvider.getTotalSwap();
        this.cpuPercentage = systemDataProvider.getCombinedCpuPercentage();
        Object[] vals = new Object[this.summaryDataFieldList.length];
        vals[0] = this.osName;
        vals[1] = this.uptimeSeconds;
        vals[2] = this.totalFreeMemory;
        vals[3] = this.totalUsedMemory;
        vals[4] = this.totalMemory;
        vals[5] = this.totalFreeSwap;
        vals[6] = this.totalUsedSwap;
        vals[7] = this.totalSwap;
        vals[8] = this.cpuPercentage;
        jsonObj.put("systemData", (Object)vals);
    }
}

