/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Future;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.AbstractBridgeAcceptor;
import org.kaazing.gateway.transport.AbstractBridgeConnector;
import org.kaazing.gateway.transport.wseb.WsebSession;
import org.kaazing.gateway.transport.wsn.WsnSession;
import org.kaazing.mina.core.service.IoAcceptorEx;
import org.kaazing.mina.core.service.IoConnectorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OctetString;

public class Utils {
    public static final String QUOTE = "\"";
    public static final String COMMA = ",";
    public static final String ACCEPT_DIRECTION = "ACCEPT";
    public static final String CONNECT_DIRECTION = "CONNECT";
    public static final String UNKNOWN_DIRECTION = "<unknown>";

    protected Utils() {
    }

    public static String getSessionTypeName(ResourceAddress address) {
        URI externalURI = address.getExternalURI();
        return externalURI.getScheme();
    }

    public static String getSessionDirection(IoSessionEx session) {
        IoServiceEx service = session.getService();
        String connectionDirection = service instanceof IoAcceptorEx || service instanceof AbstractBridgeAcceptor ? ACCEPT_DIRECTION : (service instanceof IoConnectorEx || service instanceof AbstractBridgeConnector ? CONNECT_DIRECTION : UNKNOWN_DIRECTION);
        return connectionDirection;
    }

    public static String getCauseString(Throwable cause) {
        StringBuffer sb = new StringBuffer();
        for (Throwable t = cause; t != null; t = t.getCause()) {
            String className = t.getClass().getName();
            String message = t.getMessage();
            sb.append(className + (message == null ? "" : "=" + message));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void assertIOThread(Thread t, boolean flag) {
        if (flag) {
            assert (t.equals(Thread.currentThread())) : "Management NOT on IO thread when expected";
        } else assert (!t.equals(Thread.currentThread())) : "Management on IO thread when not expected";
    }

    public static long sumFutures(List<Future<Object>> futures) {
        long total = 0L;
        for (Future<Object> f : futures) {
            try {
                total += ((Long)f.get()).longValue();
            }
            catch (Exception ignore) {
                System.out.println("### sumFutures got exception!");
            }
        }
        return total;
    }

    public static ManagementSessionType getManagementSessionType(IoSessionEx session) {
        if (session instanceof WsnSession) {
            return ManagementSessionType.NATIVE;
        }
        if (session instanceof WsebSession) {
            return ManagementSessionType.EMULATED;
        }
        return ManagementSessionType.OTHER;
    }

    public static String makeJSONArrayString(Object[] values) {
        StringBuilder buf = new StringBuilder();
        int numVals = values.length;
        buf.append("[");
        for (int i = 0; i < numVals; ++i) {
            buf.append(QUOTE);
            buf.append(values[i].toString());
            buf.append(QUOTE);
            if (i >= numVals - 1) continue;
            buf.append(COMMA);
        }
        buf.append("]");
        return buf.toString();
    }

    public static AbstractVariable stringToVariable(String s) {
        return s == null ? Null.instance : new OctetString(s);
    }

    public static AbstractVariable byteArrayToVariable(byte[] b) {
        return b == null ? Null.instance : new OctetString(b);
    }

    public static String getClassName(Object obj) {
        String className = obj.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className;
    }

    public static enum ManagementSessionType {
        NATIVE,
        EMULATED,
        OTHER;

    }
}

