/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.snmp.SummaryDataIntervalMO;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class ServiceManagementMIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOP_REQUESTED = 2;
    private static final int STATE_START_REQUESTED = 3;
    private static final int STATE_RESTART_REQUESTED = 4;
    private final ManagementContext managementContext;
    private DefaultMOTable sysOREntry;
    private DefaultMOMutableTableModel sysOREntryModel;
    private MOTableSubIndex[] serviceEntryIndexes;
    private MOTableIndex serviceEntryIndex;
    private MOTable serviceEntry;
    private MOTableModel serviceEntryModel;
    private MOScalar summaryDataFields;
    private MOScalar summaryDataNotificationInterval;

    public ServiceManagementMIB(ManagementContext managementContext, MOFactory factory) {
        this.managementContext = managementContext;
        this.createMO(factory);
    }

    private void createMO(MOFactory moFactory) {
        OID serviceConfigEntryIndexOID = ((OID)MIBConstants.oidServiceEntry.clone()).append(1);
        this.serviceEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(serviceConfigEntryIndexOID, 2, 1, 1)};
        this.serviceEntryIndex = moFactory.createIndex(this.serviceEntryIndexes, true);
        MOColumn[] serviceEntryColumns = new MOColumn[]{new MOMutableColumn(1, 2, moFactory.createAccess(1)), new MOMutableColumn(2, 2, moFactory.createAccess(11)), new MOMutableColumn(3, 2, moFactory.createAccess(1)), new MOMutableColumn(4, 70, moFactory.createAccess(1)), new MOMutableColumn(5, 70, moFactory.createAccess(1)), new MOMutableColumn(6, 70, moFactory.createAccess(1)), new MOMutableColumn(7, 2, moFactory.createAccess(11)), new MOMutableColumn(8, 2, moFactory.createAccess(11)), new MOMutableColumn(9, 70, moFactory.createAccess(1)), new MOMutableColumn(10, 2, moFactory.createAccess(11)), new MOMutableColumn(11, 2, moFactory.createAccess(11)), new MOMutableColumn(12, 2, moFactory.createAccess(11)), new MOMutableColumn(13, 4, moFactory.createAccess(1)), new MOMutableColumn(14, 70, moFactory.createAccess(1)), new MOMutableColumn(15, 70, moFactory.createAccess(1)), new MOMutableColumn(16, 70, moFactory.createAccess(1)), new MOMutableColumn(17, 4, moFactory.createAccess(1)), new MOMutableColumn(18, 70, moFactory.createAccess(1)), new MOMutableColumn(19, 2, moFactory.createAccess(1)), new MOMutableColumn(20, 2, moFactory.createAccess(1)), new MOMutableColumn(21, 2, moFactory.createAccess(1)), new MOMutableColumn(22, 2, moFactory.createAccess(1)), new MOMutableColumn(23, 2, moFactory.createAccess(11)), new MOMutableColumn(24, 4, moFactory.createAccess(1)), new MOMutableColumn(25, 4, moFactory.createAccess(1))};
        this.serviceEntryModel = new ServiceBeanTableModel();
        this.serviceEntry = moFactory.createTable(MIBConstants.oidServiceEntry, this.serviceEntryIndex, serviceEntryColumns, this.serviceEntryModel);
        try {
            JSONArray jsonArray = new JSONArray((Object)ServiceManagementBean.SUMMARY_DATA_FIELD_LIST);
            this.summaryDataFields = new MOScalar(MIBConstants.oidServiceSummaryDataFields, moFactory.createAccess(1), (Variable)new OctetString(jsonArray.toString()));
        }
        catch (JSONException ex) {
            // empty catch block
        }
        this.summaryDataNotificationInterval = new SummaryDataIntervalMO(moFactory, this.managementContext.getServiceSummaryDataNotificationInterval(), MIBConstants.oidServiceSummaryDataNotificationInterval);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.serviceEntry, context);
        server.register((ManagedObject)this.summaryDataFields, context);
        server.register((ManagedObject)this.summaryDataNotificationInterval, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.serviceEntry, context);
        server.unregister((ManagedObject)this.summaryDataFields, context);
        server.unregister((ManagedObject)this.summaryDataNotificationInterval, context);
    }

    public void incrementCounter(CounterEvent event) {
    }

    public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
        OID index = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] values = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        values[n++] = sysORID;
        values[n++] = sysORDescr;
        DefaultMOTableRow row = new DefaultMOTableRow(index, values);
        this.sysOREntry.addRow((MOTableRow)row);
        return index;
    }

    public MOTableRow removeSysOREntry(OID index) {
        return this.sysOREntry.removeRow(index);
    }

    public OID addServiceBean(ServiceManagementBean bean) {
        GatewayManagementBean gatewayBean = bean.getGatewayManagementBean();
        OID serviceIndexOID = new OID(new int[]{gatewayBean.getId(), bean.getId()});
        this.serviceEntry.addRow((MOTableRow)new ServiceEntryRow(serviceIndexOID, bean));
        return serviceIndexOID;
    }

    public void removeServiceBean(OID oid) {
        this.serviceEntry.removeRow(oid);
    }

    private class ServiceEntryRow
    extends DefaultMOMutableRow2PC {
        private ServiceManagementBean bean;
        private int status;

        private ServiceEntryRow(OID index, ServiceManagementBean bean) {
            super(index, null);
            this.bean = bean;
            this.status = 1;
        }

        public int size() {
            return 25;
        }

        public Variable getValue(int column) {
            long scalarValue = 0L;
            try {
                switch (column) {
                    case 0: {
                        return new Integer32(this.getIndex().last());
                    }
                    case 1: {
                        return new Integer32(this.status);
                    }
                    case 2: {
                        return new Integer32(this.bean.isServiceConnected() ? 1 : 0);
                    }
                    case 3: {
                        scalarValue = this.bean.getTotalBytesReceivedCount();
                        break;
                    }
                    case 4: {
                        scalarValue = this.bean.getTotalBytesSentCount();
                        break;
                    }
                    case 5: {
                        scalarValue = this.bean.getCurrentSessionCount();
                        break;
                    }
                    case 6: {
                        scalarValue = this.bean.getCurrentNativeSessionCount();
                        break;
                    }
                    case 7: {
                        scalarValue = this.bean.getCurrentEmulatedSessionCount();
                        break;
                    }
                    case 8: {
                        scalarValue = this.bean.getCumulativeSessionCount();
                        break;
                    }
                    case 9: {
                        scalarValue = this.bean.getCumulativeNativeSessionCount();
                        break;
                    }
                    case 10: {
                        scalarValue = this.bean.getCumulativeEmulatedSessionCount();
                        break;
                    }
                    case 11: {
                        scalarValue = this.bean.getExceptionCount();
                        break;
                    }
                    case 12: {
                        return Utils.stringToVariable(this.bean.getLatestException());
                    }
                    case 13: {
                        scalarValue = this.bean.getLatestExceptionTime();
                        break;
                    }
                    case 14: {
                        scalarValue = this.bean.getLastSuccessfulConnectTime();
                        break;
                    }
                    case 15: {
                        scalarValue = this.bean.getLastFailedConnectTime();
                        break;
                    }
                    case 16: {
                        return this.bean.getLastHeartbeatPingResult() ? new OctetString("Successfully pinged service connects") : new OctetString("Failed to ping service connects");
                    }
                    case 17: {
                        scalarValue = this.bean.getLastHeartbeatPingTimestamp();
                        break;
                    }
                    case 18: {
                        return new Integer32(this.bean.getHeartbeatPingCount());
                    }
                    case 19: {
                        return new Integer32(this.bean.getHeartbeatPingSuccessesCount());
                    }
                    case 20: {
                        return new Integer32(this.bean.getHeartbeatPingFailuresCount());
                    }
                    case 21: {
                        return new Integer32(this.bean.isHeartbeatRunning() ? 1 : 0);
                    }
                    case 22: {
                        return new Integer32(this.bean.areNotificationsEnabled() ? 1 : 0);
                    }
                    case 23: {
                        return Utils.stringToVariable(this.getLoggedInSessionsData());
                    }
                    case 24: {
                        return Utils.stringToVariable(this.bean.getSummaryData());
                    }
                    default: {
                        return super.getValue(column);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new Counter64(Long.valueOf(scalarValue).longValue());
        }

        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            this.setValue(column, (Variable)subRequest.getVariableBinding().getVariable().clone());
            subRequest.completed();
        }

        public void setValue(int column, Variable newValue) {
            switch (column) {
                case 1: {
                    if (!(newValue instanceof Integer32)) break;
                    int newState = ((Integer32)newValue).getValue();
                    try {
                        switch (newState) {
                            case 3: {
                                this.bean.start();
                                this.status = 1;
                                break;
                            }
                            case 2: {
                                this.bean.stop();
                                this.status = 0;
                                break;
                            }
                            case 4: {
                                this.bean.restart();
                                this.status = 1;
                            }
                        }
                        break;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                case 22: {
                    if (!(newValue instanceof Integer32)) break;
                    this.bean.enableNotifications(((Integer32)newValue).getValue() == 1);
                    break;
                }
                default: {
                    super.setValue(column, newValue);
                }
            }
        }

        private String getLoggedInSessionsData() {
            Map<Long, Map<String, String>> loggedInSessionMap = this.bean.getLoggedInSessions();
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (Long sessionId : loggedInSessionMap.keySet()) {
                sb.append(sessionId.toString());
                sb.append(" : [ ");
                Map<String, String> principalMap = loggedInSessionMap.get(sessionId);
                for (String principalName : principalMap.keySet()) {
                    String principalClass = principalMap.get(principalName);
                    sb.append(principalName + " : " + principalClass + ", ");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
                sb.append(" ], ");
            }
            if (sb.length() > 2) {
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    private class ServiceBeanTableModel
    extends DefaultMOMutableTableModel {
        private ServiceBeanTableModel() {
        }
    }
}

