/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.snmp.mib;

import java.util.List;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.config.ClusterConfigurationBean;
import org.kaazing.gateway.management.config.NetworkConfigurationBean;
import org.kaazing.gateway.management.config.RealmConfigurationBean;
import org.kaazing.gateway.management.config.SecurityConfigurationBean;
import org.kaazing.gateway.management.config.ServiceConfigurationBean;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.snmp.mib.MIBConstants;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class GatewayConfigurationMIB
implements MOGroup {
    private MOScalar clusterName;
    private MOScalar clusterAccepts;
    private MOScalar clusterConnects;
    private MOScalar clusterConnectOptions;
    private MOScalar networkAddressMapping;
    private MOScalar keyStoreType;
    private MOScalar keystoreCertificateInfo;
    private MOScalar trustStoreType;
    private MOScalar truststoreCertificateInfo;
    private MOTable realmTable;
    private MOTable serviceTable;
    private MOScalar serviceDefaultsAcceptOptions;
    private MOScalar serviceDefaultsMimeMappings;
    private MOScalar versionInfoProductTitle;
    private MOScalar versionInfoProductBuild;
    private MOScalar versionInfoProductEdition;

    public GatewayConfigurationMIB(MOFactory factory) {
        this.createClusterConfig(factory);
        this.createNetworkConfig(factory);
        this.createSecurityConfig(factory);
        this.createServiceTable(factory);
        this.createServiceDefaults(factory);
        this.createVersionInfo(factory);
    }

    private void createClusterConfig(MOFactory moFactory) {
        this.clusterName = new MOScalar(MIBConstants.oidClusterName, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.clusterAccepts = new MOScalar(MIBConstants.oidClusterAccepts, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.clusterConnects = new MOScalar(MIBConstants.oidClusterConnects, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.clusterConnectOptions = new MOScalar(MIBConstants.oidClusterConnectOptions, moFactory.createAccess(1), (Variable)new OctetString(""));
    }

    private void createNetworkConfig(MOFactory moFactory) {
        this.networkAddressMapping = new MOScalar(MIBConstants.oidNetworkConfigAddressMappings, moFactory.createAccess(1), (Variable)new OctetString(""));
    }

    private void createSecurityConfig(MOFactory moFactory) {
        this.keyStoreType = new MOScalar(MIBConstants.oidSecurityKeystoreType, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.keystoreCertificateInfo = new MOScalar(MIBConstants.oidSecurityKeystoreCertificateInfo, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.trustStoreType = new MOScalar(MIBConstants.oidSecurityTruststoreType, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.truststoreCertificateInfo = new MOScalar(MIBConstants.oidSecurityTruststoreCertificateInfo, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.createRealmTable(moFactory);
    }

    private void createRealmTable(MOFactory moFactory) {
        OID realmConfigEntryOID = ((OID)MIBConstants.oidRealmConfig.clone()).append(1);
        OID realmConfigEntryIndexOID = ((OID)realmConfigEntryOID.clone()).append(1);
        MOTableSubIndex[] realmConfigEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(realmConfigEntryIndexOID, 2, 1, 1)};
        MOTableIndex realmConfigEntryIndex = moFactory.createIndex(realmConfigEntryIndexes, true);
        MOColumn[] realmConfigColumns = new MOColumn[]{new MOMutableColumn(1, 4, moFactory.createAccess(1)), new MOMutableColumn(2, 4, moFactory.createAccess(1)), new MOMutableColumn(3, 4, moFactory.createAccess(1)), new MOMutableColumn(4, 4, moFactory.createAccess(1)), new MOMutableColumn(5, 4, moFactory.createAccess(1)), new MOMutableColumn(6, 4, moFactory.createAccess(1)), new MOMutableColumn(7, 4, moFactory.createAccess(1)), new MOMutableColumn(8, 4, moFactory.createAccess(1)), new MOMutableColumn(9, 4, moFactory.createAccess(1)), new MOMutableColumn(10, 4, moFactory.createAccess(1))};
        this.realmTable = moFactory.createTable(realmConfigEntryOID, realmConfigEntryIndex, realmConfigColumns, (MOTableModel)new RealmConfigurationTableModel());
    }

    private void createServiceTable(MOFactory moFactory) {
        OID serviceConfigEntryOID = ((OID)MIBConstants.oidServiceConfig.clone()).append(1);
        OID serviceConfigEntryIndexOID = ((OID)serviceConfigEntryOID.clone()).append(1);
        MOTableSubIndex[] serviceConfigEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(serviceConfigEntryIndexOID, 2, 1, 1)};
        MOTableIndex serviceConfigEntryIndex = moFactory.createIndex(serviceConfigEntryIndexes, true);
        MOColumn[] serviceConfigColumns = new MOColumn[]{new MOMutableColumn(1, 4, moFactory.createAccess(1)), new MOMutableColumn(2, 4, moFactory.createAccess(1)), new MOMutableColumn(3, 4, moFactory.createAccess(1)), new MOMutableColumn(4, 4, moFactory.createAccess(1)), new MOMutableColumn(5, 4, moFactory.createAccess(1)), new MOMutableColumn(6, 4, moFactory.createAccess(1)), new MOMutableColumn(7, 4, moFactory.createAccess(1)), new MOMutableColumn(8, 4, moFactory.createAccess(1)), new MOMutableColumn(9, 4, moFactory.createAccess(1)), new MOMutableColumn(10, 4, moFactory.createAccess(1)), new MOMutableColumn(11, 4, moFactory.createAccess(1)), new MOMutableColumn(12, 4, moFactory.createAccess(1)), new MOMutableColumn(13, 4, moFactory.createAccess(1))};
        this.serviceTable = moFactory.createTable(serviceConfigEntryOID, serviceConfigEntryIndex, serviceConfigColumns, (MOTableModel)new ServiceConfigurationTableModel());
    }

    private void createServiceDefaults(MOFactory moFactory) {
        this.serviceDefaultsAcceptOptions = new MOScalar(MIBConstants.oidServiceDefaultsAcceptOptions, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.serviceDefaultsMimeMappings = new MOScalar(MIBConstants.oidServiceDefaultsMimeMappings, moFactory.createAccess(1), (Variable)new OctetString(""));
    }

    private void createVersionInfo(MOFactory moFactory) {
        this.versionInfoProductTitle = new MOScalar(MIBConstants.oidVersionInfoProductTitle, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.versionInfoProductBuild = new MOScalar(MIBConstants.oidVersionInfoProductBuild, moFactory.createAccess(1), (Variable)new OctetString(""));
        this.versionInfoProductEdition = new MOScalar(MIBConstants.oidVersionInfoProductEdition, moFactory.createAccess(1), (Variable)new OctetString(""));
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.clusterName, context);
        server.register((ManagedObject)this.clusterAccepts, context);
        server.register((ManagedObject)this.clusterConnects, context);
        server.register((ManagedObject)this.clusterConnectOptions, context);
        server.register((ManagedObject)this.networkAddressMapping, context);
        server.register((ManagedObject)this.keyStoreType, context);
        server.register((ManagedObject)this.keystoreCertificateInfo, context);
        server.register((ManagedObject)this.trustStoreType, context);
        server.register((ManagedObject)this.truststoreCertificateInfo, context);
        server.register((ManagedObject)this.realmTable, context);
        server.register((ManagedObject)this.serviceTable, context);
        server.register((ManagedObject)this.serviceDefaultsAcceptOptions, context);
        server.register((ManagedObject)this.serviceDefaultsMimeMappings, context);
        server.register((ManagedObject)this.versionInfoProductTitle, context);
        server.register((ManagedObject)this.versionInfoProductBuild, context);
        server.register((ManagedObject)this.versionInfoProductEdition, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.clusterName, context);
        server.unregister((ManagedObject)this.clusterAccepts, context);
        server.unregister((ManagedObject)this.clusterConnects, context);
        server.unregister((ManagedObject)this.clusterConnectOptions, context);
        server.unregister((ManagedObject)this.networkAddressMapping, context);
        server.unregister((ManagedObject)this.keyStoreType, context);
        server.unregister((ManagedObject)this.keystoreCertificateInfo, context);
        server.unregister((ManagedObject)this.trustStoreType, context);
        server.unregister((ManagedObject)this.truststoreCertificateInfo, context);
        server.unregister((ManagedObject)this.realmTable, context);
        server.unregister((ManagedObject)this.serviceTable, context);
        server.unregister((ManagedObject)this.serviceDefaultsAcceptOptions, context);
        server.unregister((ManagedObject)this.serviceDefaultsMimeMappings, context);
        server.unregister((ManagedObject)this.versionInfoProductTitle, context);
        server.unregister((ManagedObject)this.versionInfoProductBuild, context);
        server.unregister((ManagedObject)this.versionInfoProductEdition, context);
    }

    public OID addClusterConfiguration(ClusterConfigurationBean bean) {
        this.clusterName.setValue((Variable)Utils.stringToVariable(bean.getName()));
        StringBuffer sb = new StringBuffer();
        List<String> accepts = bean.getAccepts();
        if (accepts != null) {
            for (String accept : accepts) {
                sb.append(accept + '\n');
            }
        }
        this.clusterAccepts.setValue((Variable)Utils.stringToVariable(sb.toString().trim()));
        sb = new StringBuffer();
        List<String> connects = bean.getConnects();
        if (connects != null) {
            for (String connect : connects) {
                sb.append(connect + '\n');
            }
        }
        this.clusterConnects.setValue((Variable)Utils.stringToVariable(sb.toString().trim()));
        this.clusterConnectOptions.setValue((Variable)Utils.stringToVariable(bean.getConnectOptions()));
        return MIBConstants.oidClusterConfig;
    }

    public OID addNetworkConfiguration(NetworkConfigurationBean bean) {
        this.networkAddressMapping.setValue((Variable)Utils.stringToVariable(bean.getAddressMappings()));
        return MIBConstants.oidNetworkConfigAddressMappings;
    }

    public OID addSecurityConfiguration(SecurityConfigurationBean securityBean) {
        this.keyStoreType.setValue((Variable)new OctetString(securityBean.getKeystoreType()));
        this.keystoreCertificateInfo.setValue((Variable)new OctetString(securityBean.getKeystoreCertificateInfo()));
        this.trustStoreType.setValue((Variable)new OctetString(securityBean.getTruststoreType()));
        this.truststoreCertificateInfo.setValue((Variable)new OctetString(securityBean.getTruststoreCertificateInfo()));
        return MIBConstants.oidSecurityConfig;
    }

    public OID addRealmConfiguration(RealmConfigurationBean bean) {
        GatewayManagementBean gatewayBean = bean.getGatewayManagementBean();
        OID realmConfigurationIndexOID = new OID(new int[]{gatewayBean.getId(), bean.getId()});
        this.realmTable.addRow((MOTableRow)new RealmConfigurationEntryRow(realmConfigurationIndexOID, bean));
        return realmConfigurationIndexOID;
    }

    public void removeRealmConfigurationBean(OID oid) {
        this.realmTable.removeRow(oid);
    }

    public OID addServiceConfiguration(ServiceConfigurationBean bean) {
        GatewayManagementBean gatewayBean = bean.getGatewayManagementBean();
        OID serviceConfigurationIndexOID = new OID(new int[]{gatewayBean.getId(), bean.getId()});
        this.serviceTable.addRow((MOTableRow)new ServiceConfigurationEntryRow(serviceConfigurationIndexOID, bean));
        return serviceConfigurationIndexOID;
    }

    public void removeServiceConfigurationBean(OID oid) {
        this.serviceTable.removeRow(oid);
    }

    public OID addServiceDefaultsConfiguration(ServiceDefaultsConfigurationBean bean) {
        this.serviceDefaultsAcceptOptions.setValue((Variable)Utils.stringToVariable(bean.getAcceptOptions()));
        this.serviceDefaultsMimeMappings.setValue((Variable)Utils.stringToVariable(bean.getMimeMappings()));
        return MIBConstants.oidServiceDefaults;
    }

    public void addVersionInfo(GatewayManagementBean gatewayBean) {
        this.versionInfoProductTitle.setValue((Variable)Utils.stringToVariable(gatewayBean.getProductTitle()));
        this.versionInfoProductBuild.setValue((Variable)Utils.stringToVariable(gatewayBean.getProductBuild()));
        this.versionInfoProductEdition.setValue((Variable)Utils.stringToVariable(gatewayBean.getProductEdition()));
    }

    private class ServiceConfigurationEntryRow
    extends DefaultMOMutableRow2PC {
        private ServiceConfigurationBean bean;

        private ServiceConfigurationEntryRow(OID index, ServiceConfigurationBean bean) {
            super(index, null);
            this.bean = bean;
        }

        public int size() {
            return 13;
        }

        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return Utils.stringToVariable(this.bean.getType());
                }
                case 1: {
                    return Utils.stringToVariable(this.bean.getServiceName());
                }
                case 2: {
                    return Utils.stringToVariable(this.bean.getServiceDescription());
                }
                case 3: {
                    return Utils.stringToVariable(this.bean.getAccepts());
                }
                case 4: {
                    return Utils.stringToVariable(this.bean.getAcceptOptions());
                }
                case 5: {
                    return Utils.stringToVariable(this.bean.getBalances());
                }
                case 6: {
                    return Utils.stringToVariable(this.bean.getConnects());
                }
                case 7: {
                    return Utils.stringToVariable(this.bean.getConnectOptions());
                }
                case 8: {
                    return Utils.stringToVariable(this.bean.getCrossSiteConstraints());
                }
                case 9: {
                    return Utils.stringToVariable(this.bean.getProperties());
                }
                case 10: {
                    return Utils.stringToVariable(this.bean.getRequiredRoles());
                }
                case 11: {
                    return Utils.stringToVariable(this.bean.getServiceRealm());
                }
                case 12: {
                    String mimeMappings = this.bean.getMimeMappings();
                    return Utils.stringToVariable(mimeMappings);
                }
            }
            throw new RuntimeException("Unknown service table column: " + column);
        }
    }

    private class ServiceConfigurationTableModel
    extends DefaultMOMutableTableModel {
        private ServiceConfigurationTableModel() {
        }
    }

    private class RealmConfigurationEntryRow
    extends DefaultMOMutableRow2PC {
        private RealmConfigurationBean bean;

        private RealmConfigurationEntryRow(OID index, RealmConfigurationBean bean) {
            super(index, null);
            this.bean = bean;
        }

        public int size() {
            return 10;
        }

        public Variable getValue(int column) {
            switch (column) {
                case 0: {
                    return Utils.stringToVariable(this.bean.getName());
                }
                case 1: {
                    return Utils.stringToVariable(this.bean.getDescription());
                }
                case 2: {
                    return Utils.stringToVariable(this.bean.getUserPrincipalClasses());
                }
                case 3: {
                    return Utils.stringToVariable(this.bean.getHTTPChallengeScheme());
                }
                case 4: {
                    return Utils.stringToVariable(this.bean.getHTTPHeaders());
                }
                case 5: {
                    return Utils.stringToVariable(this.bean.getHTTPQueryParameters());
                }
                case 6: {
                    return Utils.stringToVariable(this.bean.getHTTPCookieNames());
                }
                case 7: {
                    return Utils.stringToVariable(this.bean.getAuthorizationMode());
                }
                case 8: {
                    return Utils.stringToVariable(this.bean.getSessionTimeout());
                }
                case 9: {
                    return Utils.stringToVariable(this.bean.getLoginModules());
                }
            }
            throw new RuntimeException("Unknown realm table column: " + column);
        }
    }

    private class RealmConfigurationTableModel
    extends DefaultMOMutableTableModel {
        private RealmConfigurationTableModel() {
        }
    }
}

