/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.service;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.util.CopyOnWriteMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.kaazing.gateway.management.AbstractManagementBean;
import org.kaazing.gateway.management.ManagementBean;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.DefaultManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementListener;
import org.kaazing.gateway.management.session.SessionManagementBean;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.proxy.ProxyService;
import org.kaazing.gateway.service.proxy.ServiceConnectManager;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ServiceManagementBean
extends ManagementBean {
    public static final String[] SUMMARY_DATA_FIELD_LIST = new String[]{"serviceConnected", "totalBytesReceived", "totalBytesSent", "totalCurrentSessions", "totalCurrentNativeSessions", "totalCurrentEmulatedSessions", "totalCumulativeSessions", "totalCumulativeNativeSessions", "totalCumulativeEmulatedSessions", "totalExceptionCount", "latestException", "latestExceptionTime", "lastSuccessfulConnectTime", "lastFailedConnectTime", "lastHeartbeatPingResult", "lastHeartbeatPingTimestamp", "heartbeatPingCount", "heartbeatPingSuccesses", "heartbeatPingFailures", "heartbeatRunning", "notificationsEnabled"};
    public static final int SUMMARY_DATA_SERVICE_CONNECTED_INDEX = 0;
    public static final int SUMMARY_DATA_TOTAL_BYTES_RECEIVED_INDEX = 1;
    public static final int SUMMARY_DATA_TOTAL_BYTES_SENT_INDEX = 2;
    public static final int SUMMARY_DATA_TOTAL_CURRENT_SESSIONS_INDEX = 3;
    public static final int SUMMARY_DATA_TOTAL_CURRENT_NATIVE_SESSIONS_INDEX = 4;
    public static final int SUMMARY_DATA_TOTAL_CURRENT_EMULATED_SESSIONS_INDEX = 5;
    public static final int SUMMARY_DATA_TOTAL_CUMULATIVE_SESSIONS_INDEX = 6;
    public static final int SUMMARY_DATA_TOTAL_CUMULATIVE_NATIVE_SESSIONS_INDEX = 7;
    public static final int SUMMARY_DATA_TOTAL_CUMULATIVE_EMULATED_SESSIONS_INDEX = 8;
    public static final int SUMMARY_DATA_TOTAL_EXCEPTION_COUNT_INDEX = 9;
    public static final int SUMMARY_DATA_LATEST_EXCEPTION_INDEX = 10;
    public static final int SUMMARY_DATA_LATEST_EXCEPTION_TIME_INDEX = 11;
    public static final int SUMMARY_DATA_LAST_SUCCCESSFUL_CONNECT_TIME_INDEX = 12;
    public static final int SUMMARY_DATA_LAST_FAILED_CONNECT_TIME_INDEX = 13;
    public static final int SUMMARY_DATA_LAST_HEARTBEAT_PING_RESULT_INDEX = 14;
    public static final int SUMMARY_DATA_LAST_HEARTBEAT_PING_TIMESTAMP_INDEX = 15;
    public static final int SUMMARY_DATA_HEARTBEAT_PING_COUNT_INDEX = 16;
    public static final int SUMMARY_DATA_HEARTBEAT_PING_SUCCESSES_INDEX = 17;
    public static final int SUMMARY_DATA_HEARTBEAT_PING_FAILURES_INDEX = 18;
    public static final int SUMMARY_DATA_HEARTBEAT_RUNNING_INDEX = 19;
    public static final int SUMMARY_DATA_NOTIFICATIONS_ENABLED_INDEX = 20;

    public GatewayManagementBean getGatewayManagementBean();

    public int getId();

    public String getServiceType();

    public long getCumulativeSessionCount();

    public long getCumulativeNativeSessionCount();

    public long getCumulativeEmulatedSessionCount();

    public long getCurrentSessionCount();

    public long getCurrentNativeSessionCount();

    public long getCurrentEmulatedSessionCount();

    public long getExceptionCount();

    public String getLatestException();

    public long getLatestExceptionTime();

    public void clearCumulativeSessionsCount();

    public long getTotalBytesReceivedCount();

    public long getTotalBytesSentCount();

    public long[] collectCurrentSessionCounts();

    public Map<Long, Map<String, String>> getLoggedInSessions();

    public Map<String, String> getUserPrincipals(Long var1);

    public IoSessionEx getSession(long var1);

    public ServiceContext getServiceContext();

    public Set<String> getUserPrincipalClasses();

    public String getServiceName();

    public String getSessionRemoteAddress(IoSessionEx var1);

    public long getLastSuccessfulConnectTime();

    public long getLastFailedConnectTime();

    public boolean getLastHeartbeatPingResult();

    public long getLastHeartbeatPingTimestamp();

    public int getHeartbeatPingCount();

    public int getHeartbeatPingSuccessesCount();

    public int getHeartbeatPingFailuresCount();

    public boolean isServiceConnected();

    public boolean isHeartbeatRunning();

    public void start() throws Exception;

    public void stop() throws Exception;

    public void restart() throws Exception;

    public void doSessionCreated(long var1, Utils.ManagementSessionType var3) throws Exception;

    public void doSessionCreatedListeners(long var1, Utils.ManagementSessionType var3);

    public void doSessionClosed(long var1, Utils.ManagementSessionType var3) throws Exception;

    public void doSessionClosedListeners(long var1, Utils.ManagementSessionType var3);

    public void doMessageReceived(long var1, long var3, Object var5) throws Exception;

    public void doMessageReceivedListeners(long var1, long var3, Object var5);

    public void doFilterWrite(long var1, long var3, WriteRequest var5) throws Exception;

    public void doFilterWriteListeners(long var1, long var3, WriteRequest var5);

    public String doExceptionCaught(long var1, Throwable var3) throws Exception;

    public void doExceptionCaughtListeners(long var1, Throwable var3);

    public void storeSessionManagementBean(SessionManagementBean var1);

    public SessionManagementBean getSessionManagementBean(long var1);

    public SessionManagementBean removeSessionManagementBean(long var1);

    public void enableNotifications(boolean var1);

    public boolean areNotificationsEnabled();

    public void addUserPrincipals(IoSessionEx var1, Map<String, String> var2);

    public void removeUserPrincipals(IoSessionEx var1);

    public static class DefaultServiceManagementBean
    extends AbstractManagementBean
    implements ServiceManagementBean {
        private final ThreadLocal<ThreadServiceStats> serviceStats = new VicariousThreadLocal<ThreadServiceStats>(){

            protected ThreadServiceStats initialValue() {
                ThreadServiceStats stats = new ThreadServiceStats();
                DefaultServiceManagementBean.this.serviceStatsMap.put((Object)Thread.currentThread(), (Object)stats);
                return stats;
            }
        };
        private static final Logger logger = LoggerFactory.getLogger(DefaultServiceManagementBean.class);
        private final CopyOnWriteMap<Thread, ThreadServiceStats> serviceStatsMap = new CopyOnWriteMap();
        private final int index;
        private boolean notificationsEnabled = false;
        private final GatewayManagementBean gatewayManagementBean;
        private final ServiceContext serviceContext;
        private final ServiceConnectManager serviceConnectManager;
        private final Set<String> userPrincipalClasses;
        private Set<Long> sessionCreatedFlag = new HashSet<Long>();

        public DefaultServiceManagementBean(GatewayManagementBean gatewayManagementBean, ServiceContext serviceContext) {
            super(gatewayManagementBean.getManagementContext(), gatewayManagementBean.getManagementContext().getServiceSummaryDataNotificationInterval(), SUMMARY_DATA_FIELD_LIST);
            String[] upc;
            this.index = DefaultManagementContext.getNextServiceIndex(serviceContext);
            this.gatewayManagementBean = gatewayManagementBean;
            this.serviceContext = serviceContext;
            Service service = serviceContext.getService();
            if (service instanceof ProxyService) {
                ProxyService proxyService = (ProxyService)service;
                this.serviceConnectManager = proxyService.getServiceConnectManager();
            } else {
                this.serviceConnectManager = null;
            }
            this.userPrincipalClasses = new HashSet<String>();
            RealmContext realmContext = serviceContext.getServiceRealm();
            if (realmContext != null && (upc = realmContext.getUserPrincipalClasses()) != null) {
                this.userPrincipalClasses.addAll(Arrays.asList(upc));
            }
        }

        @Override
        public GatewayManagementBean getGatewayManagementBean() {
            return this.gatewayManagementBean;
        }

        private List<ServiceManagementListener> getManagementListeners() {
            return this.managementContext.getServiceManagementListeners();
        }

        @Override
        public String getServiceType() {
            return this.serviceContext.getServiceType();
        }

        @Override
        public int getId() {
            return this.index;
        }

        @Override
        public Set<String> getUserPrincipalClasses() {
            return this.userPrincipalClasses;
        }

        @Override
        public void enableNotifications(boolean notificationsEnabled) {
            this.notificationsEnabled = notificationsEnabled;
        }

        @Override
        public boolean areNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Override
        public void clearCumulativeSessionsCount() {
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                stats.clearCumulativeSessionCount();
            }
        }

        @Override
        public long getCurrentSessionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getCurrentSessionCount();
            }
            return total;
        }

        @Override
        public long getCurrentNativeSessionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getCurrentNativeSessionCount();
            }
            return total;
        }

        @Override
        public long getCurrentEmulatedSessionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getCurrentEmulatedSessionCount();
            }
            return total;
        }

        @Override
        public long getCumulativeSessionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getCumulativeSessionCount();
            }
            return total;
        }

        @Override
        public long getCumulativeNativeSessionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getCumulativeNativeSessionCount();
            }
            return total;
        }

        @Override
        public long getCumulativeEmulatedSessionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getCumulativeEmulatedSessionCount();
            }
            return total;
        }

        @Override
        public long getExceptionCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getExceptionCount();
            }
            return total;
        }

        @Override
        public String getLatestException() {
            Object[] exceptionData = new Object[]{-1, null};
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                stats.collectLatestException(exceptionData);
            }
            return (String)exceptionData[1];
        }

        @Override
        public long getLatestExceptionTime() {
            Object[] exceptionData = new Object[]{-1, null};
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                stats.collectLatestException(exceptionData);
            }
            return (Long)exceptionData[0];
        }

        @Override
        public long getTotalBytesReceivedCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getTotalBytesReceivedCount();
            }
            return total;
        }

        @Override
        public long getTotalBytesSentCount() {
            long total = 0L;
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                total += stats.getTotalBytesSentCount();
            }
            return total;
        }

        @Override
        public long[] collectCurrentSessionCounts() {
            long[] counts = new long[]{0L, 0L};
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                counts[0] = counts[0] + stats.getCurrentSessionCount();
                counts[1] = counts[1] + stats.getCumulativeSessionCount();
            }
            return counts;
        }

        @Override
        public String getSummaryData() {
            long start = System.nanoTime();
            JSONArray jsonArray = null;
            try {
                Object[] vals = new Object[SUMMARY_DATA_FIELD_LIST.length];
                vals[0] = this.isServiceConnected();
                vals[1] = 0L;
                vals[2] = 0L;
                vals[3] = 0L;
                vals[4] = 0L;
                vals[5] = 0L;
                vals[6] = 0L;
                vals[7] = 0L;
                vals[8] = 0L;
                vals[9] = 0L;
                vals[10] = null;
                vals[11] = 0L;
                vals[12] = this.getLastSuccessfulConnectTime();
                vals[13] = this.getLastFailedConnectTime();
                vals[14] = this.getLastHeartbeatPingResult();
                vals[15] = this.getLastHeartbeatPingTimestamp();
                vals[16] = this.getHeartbeatPingCount();
                vals[17] = this.getHeartbeatPingSuccessesCount();
                vals[18] = this.getHeartbeatPingFailuresCount();
                vals[19] = this.isHeartbeatRunning();
                vals[20] = this.areNotificationsEnabled();
                for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                    stats.collectSummaryValues(vals);
                }
                jsonArray = new JSONArray((Object)vals);
            }
            catch (JSONException ex) {
                // empty catch block
            }
            long stop = System.nanoTime();
            String val = jsonArray.toString();
            return val;
        }

        @Override
        public Map<Long, Map<String, String>> getLoggedInSessions() {
            HashMap<Long, Map<String, String>> sessions = new HashMap<Long, Map<String, String>>();
            for (ThreadServiceStats stats : this.serviceStatsMap.values()) {
                stats.collectLoggedInSessions(sessions);
            }
            return sessions;
        }

        @Override
        public Map<String, String> getUserPrincipals(Long sessionId) {
            return null;
        }

        @Override
        public long getLastSuccessfulConnectTime() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getLastSuccessfulConnectTime() : 0L;
        }

        @Override
        public long getLastFailedConnectTime() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getLastFailedConnectTime() : 0L;
        }

        @Override
        public boolean getLastHeartbeatPingResult() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getLastHeartbeatPingResult() : false;
        }

        @Override
        public long getLastHeartbeatPingTimestamp() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getLastHeartbeatPingTimestamp() : 0L;
        }

        @Override
        public int getHeartbeatPingCount() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getHeartbeatPingCount() : 0;
        }

        @Override
        public int getHeartbeatPingSuccessesCount() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getHeartbeatPingSuccessesCount() : 0;
        }

        @Override
        public int getHeartbeatPingFailuresCount() {
            return this.serviceConnectManager != null ? this.serviceConnectManager.getHeartbeatPingFailuresCount() : 0;
        }

        @Override
        public boolean isServiceConnected() {
            return this.serviceConnectManager != null && this.serviceConnectManager.isServiceConnected();
        }

        @Override
        public boolean isHeartbeatRunning() {
            return this.serviceConnectManager != null && this.serviceConnectManager.isHeartbeatRunning();
        }

        @Override
        public IoSessionEx getSession(long sessionId) {
            return this.serviceContext.getActiveSession(Long.valueOf(sessionId));
        }

        @Override
        public String getSessionRemoteAddress(IoSessionEx session) {
            IoSessionEx parentSession;
            while (session instanceof AbstractBridgeSession && (parentSession = ((AbstractBridgeSession)session).getParent()) != null) {
                session = parentSession;
            }
            SocketAddress remoteAddress = session.getRemoteAddress();
            if (remoteAddress != null) {
                if (remoteAddress instanceof InetSocketAddress) {
                    return ((InetSocketAddress)remoteAddress).getAddress().toString();
                }
                return remoteAddress.toString();
            }
            return "";
        }

        @Override
        public void start() throws Exception {
            this.serviceContext.start();
        }

        @Override
        public void stop() throws Exception {
            this.serviceContext.stop();
        }

        @Override
        public void restart() throws Exception {
            this.serviceContext.stop();
            this.serviceContext.start();
        }

        @Override
        public ServiceContext getServiceContext() {
            return this.serviceContext;
        }

        @Override
        public void doSessionCreated(long sessionId, Utils.ManagementSessionType managementSessionType) throws Exception {
            ThreadServiceStats stats = this.serviceStats.get();
            stats.doSessionCreated(sessionId, managementSessionType);
            this.sessionCreatedFlag.add(sessionId);
        }

        @Override
        public void doSessionCreatedListeners(long sessionId, Utils.ManagementSessionType managementSessionType) {
            this.runManagementTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        long[] counts = DefaultServiceManagementBean.this.collectCurrentSessionCounts();
                        List serviceListeners = DefaultServiceManagementBean.this.getManagementListeners();
                        for (ServiceManagementListener listener : serviceListeners) {
                            listener.doSessionCreated(DefaultServiceManagementBean.this, counts[0], counts[1]);
                        }
                        DefaultServiceManagementBean.this.markChanged();
                    }
                    catch (Exception ex) {
                        logger.warn("Error during doSessionCreated service listener notifications:", (Throwable)ex);
                    }
                }
            });
        }

        @Override
        public void doSessionClosed(long sessionId, Utils.ManagementSessionType managementSessionType) throws Exception {
            if (this.sessionCreatedFlag.remove(sessionId)) {
                ThreadServiceStats stats = this.serviceStats.get();
                stats.doSessionClosed(sessionId, managementSessionType);
            }
        }

        @Override
        public void doSessionClosedListeners(final long sessionId, Utils.ManagementSessionType managementSessionType) {
            this.runManagementTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        long[] counts = DefaultServiceManagementBean.this.collectCurrentSessionCounts();
                        List serviceListeners = DefaultServiceManagementBean.this.getManagementListeners();
                        for (ServiceManagementListener listener : serviceListeners) {
                            listener.doSessionClosed(DefaultServiceManagementBean.this, sessionId, counts[0]);
                        }
                        DefaultServiceManagementBean.this.markChanged();
                    }
                    catch (Exception ex) {
                        logger.warn("Error during doSessionClosed service listener notifications:", (Throwable)ex);
                    }
                }
            });
        }

        @Override
        public void doMessageReceived(long sessionId, long sessionReadBytes, Object message) throws Exception {
            ThreadServiceStats stats = this.serviceStats.get();
            stats.addToBytesReceived(sessionId, sessionReadBytes);
        }

        @Override
        public void doMessageReceivedListeners(final long sessionId, long sessionReadBytes, final Object message) {
            this.runManagementTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (message instanceof IoBuffer) {
                            IoBuffer buf = (IoBuffer)message;
                            ByteBuffer byteBuffer = buf.buf();
                            List serviceListeners = DefaultServiceManagementBean.this.getManagementListeners();
                            for (ServiceManagementListener listener : serviceListeners) {
                                listener.doMessageReceived(DefaultServiceManagementBean.this, sessionId, byteBuffer);
                            }
                        }
                        DefaultServiceManagementBean.this.markChanged();
                    }
                    catch (Exception ex) {
                        logger.warn("Error during doMessageReceived service listener notifications:", (Throwable)ex);
                    }
                }
            });
        }

        @Override
        public void doFilterWrite(long sessionId, long sessionWrittenBytes, WriteRequest writeRequest) throws Exception {
            ThreadServiceStats stats = this.serviceStats.get();
            stats.addToBytesSent(sessionId, sessionWrittenBytes);
        }

        @Override
        public void doFilterWriteListeners(final long sessionId, long sessionWrittenBytes, WriteRequest writeRequest) {
            final Object message = writeRequest.getMessage();
            this.runManagementTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (message instanceof IoBuffer) {
                            IoBuffer buf = (IoBuffer)message;
                            ByteBuffer byteBuffer = buf.buf();
                            List serviceListeners = DefaultServiceManagementBean.this.getManagementListeners();
                            for (ServiceManagementListener listener : serviceListeners) {
                                listener.doFilterWrite(DefaultServiceManagementBean.this, sessionId, byteBuffer);
                            }
                        }
                        DefaultServiceManagementBean.this.markChanged();
                    }
                    catch (Exception ex) {
                        logger.warn("Error during doFilterWrite service listener notifications:", (Throwable)ex);
                    }
                }
            });
        }

        @Override
        public String doExceptionCaught(long sessionId, Throwable cause) throws Exception {
            long time = System.currentTimeMillis();
            String exceptionMessage = Utils.getCauseString(cause);
            ThreadServiceStats stats = this.serviceStats.get();
            stats.setLatestException(exceptionMessage, time);
            return exceptionMessage;
        }

        @Override
        public void doExceptionCaughtListeners(final long sessionId, final Throwable cause) {
            this.runManagementTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        String exceptionMessage = Utils.getCauseString(cause);
                        List serviceListeners = DefaultServiceManagementBean.this.getManagementListeners();
                        for (ServiceManagementListener listener : serviceListeners) {
                            listener.doExceptionCaught(DefaultServiceManagementBean.this, sessionId, exceptionMessage);
                        }
                        DefaultServiceManagementBean.this.markChanged();
                    }
                    catch (Exception ex) {
                        logger.warn("Error during doExceptionCaught service listener notifications:", (Throwable)ex);
                    }
                }
            });
        }

        @Override
        public void storeSessionManagementBean(SessionManagementBean sessionBean) {
            ThreadServiceStats stats = this.serviceStats.get();
            stats.storeSessionManagementBean(sessionBean);
        }

        @Override
        public SessionManagementBean getSessionManagementBean(long sessionId) {
            ThreadServiceStats stats = this.serviceStats.get();
            return stats.getSessionManagementBean(sessionId);
        }

        @Override
        public SessionManagementBean removeSessionManagementBean(long sessionId) {
            ThreadServiceStats stats = this.serviceStats.get();
            return stats.removeSessionManagementBean(sessionId);
        }

        @Override
        public void addUserPrincipals(IoSessionEx session, Map<String, String> userPrincipals) {
            ThreadServiceStats stats = this.serviceStats.get();
            stats.addLoggedInSession(session, userPrincipals);
        }

        @Override
        public void removeUserPrincipals(IoSessionEx session) {
            ThreadServiceStats stats = this.serviceStats.get();
            stats.removeLoggedInSession(session);
        }

        @Override
        public String getServiceName() {
            return this.serviceContext.getServiceName();
        }

        private class ByteCountMapEntry {
            private long id;
            private long byteCount;
            private ByteCountMapEntry next;

            private ByteCountMapEntry(long id, long byteCount) {
                this.id = id;
                this.byteCount = byteCount;
                this.next = null;
            }

            private void setByteCount(long byteCount) {
                this.byteCount = byteCount;
            }
        }

        private class ByteCountMap {
            private int arraySize = 64;
            private int mapSize = 0;
            private ByteCountMapEntry[] data = new ByteCountMapEntry[this.arraySize];

            private ByteCountMap() {
            }

            private void put(long id, long byteCount) {
                int index = (int)(id % (long)this.arraySize);
                ByteCountMapEntry entry = this.data[index];
                if (entry != null) {
                    ByteCountMapEntry prevEntry = null;
                    while (entry != null) {
                        if (entry.id == id) {
                            entry.setByteCount(byteCount);
                            return;
                        }
                        prevEntry = entry;
                        entry = entry.next;
                    }
                    prevEntry.next = new ByteCountMapEntry(id, byteCount);
                } else {
                    this.data[index] = new ByteCountMapEntry(id, byteCount);
                }
                ++this.mapSize;
                if (this.mapSize > this.arraySize) {
                    this.resize();
                }
            }

            private void resize() {
                ByteCountMapEntry[] oldData = this.data;
                this.arraySize *= 2;
                this.data = new ByteCountMapEntry[this.arraySize];
                for (int i = 0; i < oldData.length; ++i) {
                    ByteCountMapEntry entry = oldData[i];
                    while (entry != null) {
                        int index = (int)(entry.id % (long)this.arraySize);
                        ByteCountMapEntry newEntry = this.data[index];
                        if (newEntry != null) {
                            while (newEntry.next != null) {
                                newEntry = newEntry.next;
                            }
                            newEntry.next = entry;
                        } else {
                            this.data[index] = entry;
                        }
                        ByteCountMapEntry prevEntry = entry;
                        entry = entry.next;
                        prevEntry.next = null;
                    }
                }
            }

            private ByteCountMapEntry get(long id) {
                int index = (int)(id % (long)this.arraySize);
                ByteCountMapEntry entry = this.data[index];
                while (entry != null) {
                    if (entry.id == id) {
                        return entry;
                    }
                    entry = entry.next;
                }
                return null;
            }

            private ByteCountMapEntry remove(long id) {
                int index = (int)(id % (long)this.arraySize);
                ByteCountMapEntry entry = this.data[index];
                if (entry != null) {
                    if (entry.id == id) {
                        this.data[index] = entry.next;
                        entry.next = null;
                    } else {
                        ByteCountMapEntry prevEntry = entry;
                        while (entry != null && entry.id != id) {
                            prevEntry = entry;
                            entry = entry.next;
                        }
                        if (entry != null) {
                            prevEntry.next = entry.next;
                            entry.next = null;
                        }
                    }
                    if (entry != null) {
                        --this.mapSize;
                    }
                    return entry;
                }
                return null;
            }
        }

        private class SessionMapEntry {
            private long id;
            private SessionManagementBean bean;
            private SessionMapEntry next;

            private SessionMapEntry(long id, SessionManagementBean bean) {
                this.id = id;
                this.bean = bean;
                this.next = null;
            }

            private void setBean(SessionManagementBean bean) {
                this.bean = bean;
            }
        }

        private class SessionMap {
            private int arraySize = 64;
            private int mapSize = 0;
            private SessionMapEntry[] data = new SessionMapEntry[this.arraySize];

            private SessionMap() {
            }

            private void put(long id, SessionManagementBean bean) {
                int index = (int)(id % (long)this.arraySize);
                SessionMapEntry entry = this.data[index];
                if (entry != null) {
                    SessionMapEntry prevEntry = null;
                    while (entry != null) {
                        if (entry.id == id) {
                            entry.setBean(bean);
                            return;
                        }
                        prevEntry = entry;
                        entry = entry.next;
                    }
                    prevEntry.next = new SessionMapEntry(id, bean);
                } else {
                    this.data[index] = new SessionMapEntry(id, bean);
                }
                ++this.mapSize;
                if (this.mapSize > this.arraySize) {
                    this.resize();
                }
            }

            private void resize() {
                SessionMapEntry[] oldData = this.data;
                this.arraySize *= 2;
                this.data = new SessionMapEntry[this.arraySize];
                for (int i = 0; i < oldData.length; ++i) {
                    SessionMapEntry entry = oldData[i];
                    while (entry != null) {
                        int index = (int)(entry.id % (long)this.arraySize);
                        SessionMapEntry newEntry = this.data[index];
                        if (newEntry != null) {
                            while (newEntry.next != null) {
                                newEntry = newEntry.next;
                            }
                            newEntry.next = entry;
                        } else {
                            this.data[index] = entry;
                        }
                        SessionMapEntry prevEntry = entry;
                        entry = entry.next;
                        prevEntry.next = null;
                    }
                }
            }

            private SessionMapEntry get(long id) {
                int index = (int)(id % (long)this.arraySize);
                SessionMapEntry entry = this.data[index];
                while (entry != null) {
                    if (entry.id == id) {
                        return entry;
                    }
                    entry = entry.next;
                }
                return null;
            }

            private SessionMapEntry remove(long id) {
                int index = (int)(id % (long)this.arraySize);
                SessionMapEntry entry = this.data[index];
                if (entry != null) {
                    if (entry.id == id) {
                        this.data[index] = entry.next;
                        entry.next = null;
                    } else {
                        SessionMapEntry prevEntry = entry;
                        while (entry != null && entry.id != id) {
                            prevEntry = entry;
                            entry = entry.next;
                        }
                        if (entry != null) {
                            prevEntry.next = entry.next;
                            entry.next = null;
                        }
                    }
                    if (entry != null) {
                        --this.mapSize;
                    }
                    return entry;
                }
                return null;
            }
        }

        private class ThreadServiceStats {
            private SessionMap sessionBeans;
            private long currentSessionCount;
            private long currentNativeSessionCount;
            private long currentEmulatedSessionCount;
            private long cumulativeSessionCount;
            private long cumulativeNativeSessionCount;
            private long cumulativeEmulatedSessionCount;
            private long exceptionCount;
            private String latestException;
            private long latestExceptionTime;
            private long totalBytesSentCount;
            private long totalBytesReceivedCount;
            private final Map<Long, Map<String, String>> loggedInSessions;
            private final ByteCountMap bytesSentCountBySession;
            private final ByteCountMap bytesReceivedCountBySession;

            private ThreadServiceStats() {
                this.sessionBeans = new SessionMap();
                this.totalBytesSentCount = 0L;
                this.totalBytesReceivedCount = 0L;
                this.loggedInSessions = new HashMap<Long, Map<String, String>>();
                this.bytesSentCountBySession = new ByteCountMap();
                this.bytesReceivedCountBySession = new ByteCountMap();
            }

            public void doSessionCreated(long sessionId, Utils.ManagementSessionType managementSessionType) {
                ++this.currentSessionCount;
                ++this.cumulativeSessionCount;
                if (managementSessionType.equals((Object)Utils.ManagementSessionType.NATIVE)) {
                    ++this.currentNativeSessionCount;
                    ++this.cumulativeNativeSessionCount;
                } else if (managementSessionType.equals((Object)Utils.ManagementSessionType.EMULATED)) {
                    ++this.currentEmulatedSessionCount;
                    ++this.cumulativeEmulatedSessionCount;
                }
            }

            public void doSessionClosed(long sessionId, Utils.ManagementSessionType managementSessionType) {
                --this.currentSessionCount;
                if (managementSessionType.equals((Object)Utils.ManagementSessionType.NATIVE)) {
                    --this.currentNativeSessionCount;
                } else if (managementSessionType.equals((Object)Utils.ManagementSessionType.EMULATED)) {
                    --this.currentEmulatedSessionCount;
                }
                this.bytesSentCountBySession.remove(sessionId);
                this.bytesReceivedCountBySession.remove(sessionId);
                this.loggedInSessions.remove(sessionId);
            }

            public void storeSessionManagementBean(SessionManagementBean sessionBean) {
                this.sessionBeans.put(sessionBean.getId(), sessionBean);
            }

            public SessionManagementBean getSessionManagementBean(long sessionId) {
                SessionMapEntry entry = this.sessionBeans.get(sessionId);
                if (entry != null) {
                    return entry.bean;
                }
                return null;
            }

            public SessionManagementBean removeSessionManagementBean(long sessionId) {
                SessionMapEntry entry = this.sessionBeans.remove(sessionId);
                if (entry != null) {
                    return entry.bean;
                }
                return null;
            }

            public long getCurrentSessionCount() {
                return this.currentSessionCount;
            }

            public long getCurrentNativeSessionCount() {
                return this.currentNativeSessionCount;
            }

            public long getCurrentEmulatedSessionCount() {
                return this.currentEmulatedSessionCount;
            }

            public long getCumulativeSessionCount() {
                return this.cumulativeSessionCount;
            }

            public long getCumulativeNativeSessionCount() {
                return this.cumulativeNativeSessionCount;
            }

            public long getCumulativeEmulatedSessionCount() {
                return this.cumulativeEmulatedSessionCount;
            }

            public void clearCumulativeSessionCount() {
                this.cumulativeSessionCount = 0L;
                this.cumulativeNativeSessionCount = 0L;
                this.cumulativeEmulatedSessionCount = 0L;
            }

            public long getExceptionCount() {
                return this.exceptionCount;
            }

            public void setLatestException(String exception, long exceptionTime) {
                ++this.exceptionCount;
                this.latestException = exception;
                this.latestExceptionTime = exceptionTime;
            }

            public void collectLatestException(Object[] exceptionData) {
                if (this.latestExceptionTime > (Long)exceptionData[0]) {
                    exceptionData[0] = this.latestExceptionTime;
                    exceptionData[1] = this.latestException;
                }
            }

            public long getTotalBytesSentCount() {
                return this.totalBytesSentCount;
            }

            public long getTotalBytesReceivedCount() {
                return this.totalBytesReceivedCount;
            }

            public void collectLoggedInSessions(Map<Long, Map<String, String>> vals) {
                vals.putAll(this.loggedInSessions);
            }

            public void collectSummaryValues(Object[] vals) {
                vals[1] = (Long)vals[1] + this.totalBytesReceivedCount;
                vals[2] = (Long)vals[2] + this.totalBytesSentCount;
                vals[3] = (Long)vals[3] + this.currentSessionCount;
                vals[4] = (Long)vals[4] + this.currentNativeSessionCount;
                vals[5] = (Long)vals[5] + this.currentEmulatedSessionCount;
                vals[6] = (Long)vals[6] + this.cumulativeSessionCount;
                vals[7] = (Long)vals[7] + this.cumulativeNativeSessionCount;
                vals[8] = (Long)vals[8] + this.cumulativeEmulatedSessionCount;
                vals[9] = (Long)vals[9] + this.exceptionCount;
                Long exceptionTime = (Long)vals[11];
                if (exceptionTime == null || this.latestExceptionTime > exceptionTime) {
                    vals[10] = this.latestException;
                    vals[11] = this.latestExceptionTime;
                }
            }

            public void addToBytesSent(long sessionId, long sessionWrittenBytes) {
                ByteCountMapEntry prevByteCount = this.bytesSentCountBySession.get(sessionId);
                long delta = prevByteCount == null ? sessionWrittenBytes : sessionWrittenBytes - prevByteCount.byteCount;
                this.bytesSentCountBySession.put(sessionId, sessionWrittenBytes);
                this.totalBytesSentCount += delta;
            }

            public void addToBytesReceived(long sessionId, long sessionReadBytes) {
                ByteCountMapEntry prevByteCount = this.bytesReceivedCountBySession.get(sessionId);
                long delta = prevByteCount == null ? sessionReadBytes : sessionReadBytes - prevByteCount.byteCount;
                this.bytesReceivedCountBySession.put(sessionId, sessionReadBytes);
                this.totalBytesReceivedCount += delta;
            }

            public void addLoggedInSession(IoSessionEx session, Map<String, String> userPrincipals) {
                this.loggedInSessions.put(session.getId(), userPrincipals);
            }

            public void removeLoggedInSession(IoSessionEx session) {
                this.loggedInSessions.remove(session.getId());
            }
        }
    }
}

