/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.filter;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.transport.IoFilterAdapter;
import org.kaazing.mina.core.session.IoSessionEx;

public class ManagementFilter
extends IoFilterAdapter<IoSessionEx> {
    protected ServiceManagementBean serviceBean;
    protected ManagementContext managementContext;
    protected ServiceContext serviceContext;

    public ManagementFilter(ServiceManagementBean serviceBean) {
        this.serviceBean = serviceBean;
        this.managementContext = serviceBean.getGatewayManagementBean().getManagementContext();
        this.serviceContext = serviceBean.getServiceContext();
    }

    public ServiceManagementBean getServiceBean() {
        return this.serviceBean;
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    protected void doSessionClosed(IoFilter.NextFilter nextFilter, IoSessionEx session) throws Exception {
        this.managementContext.getManagementFilterStrategy().doSessionClosed(this.managementContext, this.serviceBean, session.getId(), Utils.getManagementSessionType(session));
        this.managementContext.decrementOverallSessionCount();
        super.doSessionClosed(nextFilter, (IoSession)session);
    }

    protected void doMessageReceived(IoFilter.NextFilter nextFilter, IoSessionEx session, Object message) throws Exception {
        this.managementContext.getManagementFilterStrategy().doMessageReceived(this.managementContext, this.serviceBean, session.getId(), session.getReadBytes(), message);
        super.doMessageReceived(nextFilter, (IoSession)session, message);
    }

    protected void doFilterWrite(IoFilter.NextFilter nextFilter, IoSessionEx session, WriteRequest writeRequest) throws Exception {
        this.managementContext.getManagementFilterStrategy().doFilterWrite(this.managementContext, this.serviceBean, session.getId(), session.getWrittenBytes(), writeRequest);
        super.doFilterWrite(nextFilter, (IoSession)session, writeRequest);
    }

    protected void doExceptionCaught(IoFilter.NextFilter nextFilter, IoSessionEx session, Throwable cause) throws Exception {
        this.managementContext.getManagementFilterStrategy().doExceptionCaught(this.managementContext, this.serviceBean, session.getId(), cause);
        super.doExceptionCaught(nextFilter, (IoSession)session, cause);
    }

    public void newManagementSession(IoSessionEx session) throws Exception {
        this.managementContext.incrementOverallSessionCount();
        this.managementContext.getManagementFilterStrategy().doSessionCreated(this.managementContext, this.serviceBean, session, Utils.getManagementSessionType(session));
    }
}

