/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.config;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.kaazing.gateway.management.config.ServiceDefaultsConfigurationBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.server.context.ServiceDefaultsContext;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.util.Utils;

public class ServiceDefaultsConfigurationBeanImpl
implements ServiceDefaultsConfigurationBean {
    private static final AtomicInteger serviceDefaultsIds = new AtomicInteger(0);
    private final ServiceDefaultsContext serviceDefaultsContext;
    private final GatewayManagementBean gatewayBean;
    private final int id;

    public ServiceDefaultsConfigurationBeanImpl(ServiceDefaultsContext serviceDefaultsContext, GatewayManagementBean gatewayBean) {
        this.serviceDefaultsContext = serviceDefaultsContext;
        this.gatewayBean = gatewayBean;
        this.id = serviceDefaultsIds.incrementAndGet();
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayBean;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getAcceptOptions() {
        JSONObject jsonOptions = new JSONObject();
        AcceptOptionsContext context = this.serviceDefaultsContext.getAcceptOptionsContext();
        try {
            if (context != null) {
                URI httpTransport;
                URI sslTransport;
                URI tcpTransport;
                URI pipeTransport;
                String[] sslCiphers;
                Map binds = context.getBinds();
                if (binds != null && !binds.isEmpty()) {
                    JSONObject jsonObj = new JSONObject();
                    for (String key : binds.keySet()) {
                        jsonObj.put(key, binds.get(key));
                    }
                    jsonOptions.put("binds", (Object)jsonObj);
                }
                if ((sslCiphers = context.getSslCiphers()) != null && sslCiphers.length > 0) {
                    jsonOptions.put("ssl.ciphers", (Object)Utils.asCommaSeparatedString(Arrays.asList(sslCiphers)));
                }
                jsonOptions.put("ssl.encryption", (Object)(context.isSslEncryptionEnabled() ? "enabled" : "disabled"));
                if (context.getSslNeedClientAuth()) {
                    jsonOptions.put("ssl.verify-client", (Object)"required");
                } else if (context.getSslWantClientAuth()) {
                    jsonOptions.put("ssl.verify-client", (Object)"optional");
                } else {
                    jsonOptions.put("ssl.verify-client", (Object)"none");
                }
                jsonOptions.put("ws.maximum.message.size", context.getWsMaxMessageSize());
                Integer httpKeepAlive = context.getSessionIdleTimeout("http");
                if (httpKeepAlive != null) {
                    jsonOptions.put("http.keepalive.timeout", (Object)httpKeepAlive);
                }
                if ((pipeTransport = context.getPipeTransport()) != null) {
                    jsonOptions.put("pipe.transport", (Object)pipeTransport.toString());
                }
                if ((tcpTransport = context.getTcpTransport()) != null) {
                    jsonOptions.put("tcp.transport", (Object)tcpTransport.toString());
                }
                if ((sslTransport = context.getSslTransport()) != null) {
                    jsonOptions.put("ssl.transport", (Object)sslTransport.toString());
                }
                if ((httpTransport = context.getHttpTransport()) != null) {
                    jsonOptions.put("http.transport", (Object)httpTransport.toString());
                }
                long tcpMaxOutboundRate = context.getTcpMaximumOutboundRate();
                jsonOptions.put("tcp.maximum.outbound.rate", tcpMaxOutboundRate);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return jsonOptions.toString();
    }

    @Override
    public String getMimeMappings() {
        JSONObject jsonObj = new JSONObject();
        try {
            Map mimeMappings = this.serviceDefaultsContext.getMimeMappings();
            if (mimeMappings != null) {
                for (String extension : mimeMappings.keySet()) {
                    jsonObj.put(extension, mimeMappings.get(extension));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObj.toString();
    }
}

