/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.config;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.config.ServiceConfigurationBean;
import org.kaazing.gateway.management.context.DefaultManagementContext;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.security.CrossSiteConstraintContext;
import org.kaazing.gateway.security.RealmContext;
import org.kaazing.gateway.service.AcceptOptionsContext;
import org.kaazing.gateway.service.ConnectOptionsContext;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.gateway.service.ServiceProperties;
import org.kaazing.gateway.util.Utils;

public class ServiceConfigurationBeanImpl
implements ServiceConfigurationBean {
    private final ServiceContext serviceContext;
    private final GatewayManagementBean gatewayBean;
    private final int id;

    public ServiceConfigurationBeanImpl(ServiceContext serviceContext, GatewayManagementBean gatewayBean) {
        this.serviceContext = serviceContext;
        this.gatewayBean = gatewayBean;
        this.id = DefaultManagementContext.getNextServiceIndex(serviceContext);
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayBean;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.serviceContext.getServiceType();
    }

    @Override
    public String getServiceName() {
        String name = this.serviceContext.getServiceName();
        return name == null ? "" : name;
    }

    @Override
    public String getServiceDescription() {
        String desc = this.serviceContext.getServiceDescription();
        return desc == null ? "" : desc;
    }

    @Override
    public String getAccepts() {
        if (this.serviceContext.supportsAccepts()) {
            Collection accepts = this.serviceContext.getAccepts();
            return accepts == null ? "" : new JSONArray(accepts).toString();
        }
        return null;
    }

    @Override
    public String getAcceptOptions() {
        if (this.serviceContext.supportsAccepts()) {
            AcceptOptionsContext context = this.serviceContext.getAcceptOptionsContext();
            JSONObject jsonOptions = new JSONObject();
            try {
                if (context != null) {
                    URI httpTransport;
                    URI sslTransport;
                    URI tcpTransport;
                    URI pipeTransport;
                    Integer httpKeepAlive;
                    String cipherString;
                    String[] sslCiphers;
                    Map binds = context.getBinds();
                    if (binds != null && !binds.isEmpty()) {
                        JSONObject jsonObj = new JSONObject();
                        for (String key : binds.keySet()) {
                            jsonObj.put(key, binds.get(key));
                        }
                        jsonOptions.put("binds", (Object)jsonObj);
                    }
                    if ((sslCiphers = context.getSslCiphers()) != null && (cipherString = Utils.asCommaSeparatedString(Arrays.asList(sslCiphers))) != null && cipherString.length() > 0) {
                        jsonOptions.put("ssl.ciphers", (Object)cipherString);
                    }
                    jsonOptions.put("ssl.encryption", (Object)(context.isSslEncryptionEnabled() ? "enabled" : "disabled"));
                    if (context.getSslNeedClientAuth()) {
                        jsonOptions.put("ssl.verify-client", (Object)"required");
                    } else if (context.getSslWantClientAuth()) {
                        jsonOptions.put("ssl.verify-client", (Object)"optional");
                    } else {
                        jsonOptions.put("ssl.verify-client", (Object)"none");
                    }
                    jsonOptions.put("ws.maximum.message.size", context.getWsMaxMessageSize());
                    Long wsInactivityTimeout = context.getWsInactivityTimeout();
                    if (wsInactivityTimeout != null) {
                        jsonOptions.put("ws.inactivity.timeout", (Object)wsInactivityTimeout);
                    }
                    if ((httpKeepAlive = context.getSessionIdleTimeout("http")) != null) {
                        jsonOptions.put("http.keepalive.timeout", (Object)httpKeepAlive);
                    }
                    if ((pipeTransport = context.getPipeTransport()) != null) {
                        jsonOptions.put("pipe.transport", (Object)pipeTransport.toString());
                    }
                    if ((tcpTransport = context.getTcpTransport()) != null) {
                        jsonOptions.put("tcp.transport", (Object)tcpTransport.toString());
                    }
                    if ((sslTransport = context.getSslTransport()) != null) {
                        jsonOptions.put("ssl.transport", (Object)sslTransport.toString());
                    }
                    if ((httpTransport = context.getHttpTransport()) != null) {
                        jsonOptions.put("http.transport", (Object)httpTransport.toString());
                    }
                    long tcpMaxOutboundRate = context.getTcpMaximumOutboundRate();
                    jsonOptions.put("tcp.maximum.outbound.rate", tcpMaxOutboundRate);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return jsonOptions.toString();
        }
        return null;
    }

    @Override
    public String getBalances() {
        Collection balances = this.serviceContext.getBalances();
        return balances == null ? "" : new JSONArray(balances).toString();
    }

    @Override
    public String getConnects() {
        if (this.serviceContext.supportsConnects()) {
            Collection connects = this.serviceContext.getConnects();
            return connects == null ? "" : new JSONArray(connects).toString();
        }
        return null;
    }

    @Override
    public String getConnectOptions() {
        if (this.serviceContext.supportsConnects()) {
            ConnectOptionsContext context = this.serviceContext.getConnectOptionsContext();
            JSONObject jsonOptions = new JSONObject();
            try {
                if (context != null) {
                    URI httpTransport;
                    URI sslTransport;
                    URI tcpTransport;
                    URI pipeTransport;
                    String wsVersion;
                    List<String> sslCiphers;
                    if (context.getSslCiphers() != null && (sslCiphers = Arrays.asList(context.getSslCiphers())).size() > 0) {
                        jsonOptions.put("ssl.ciphers", sslCiphers);
                    }
                    if ((wsVersion = context.getWsVersion()) != null) {
                        jsonOptions.put("ws.version", (Object)wsVersion);
                    }
                    if ((pipeTransport = context.getPipeTransport()) != null) {
                        jsonOptions.put("pipe.transport", (Object)pipeTransport.toString());
                    }
                    if ((tcpTransport = context.getTcpTransport()) != null) {
                        jsonOptions.put("tcp.transport", (Object)tcpTransport.toString());
                    }
                    if ((sslTransport = context.getSslTransport()) != null) {
                        jsonOptions.put("ssl.transport", (Object)sslTransport.toString());
                    }
                    if ((httpTransport = context.getHttpTransport()) != null) {
                        jsonOptions.put("http.transport", (Object)httpTransport.toString());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return jsonOptions.toString();
        }
        return null;
    }

    @Override
    public String getCrossSiteConstraints() {
        Collection crossSiteConstraintsValues;
        Map crossSiteConstraints = this.serviceContext.getCrossSiteConstraints();
        JSONArray jsonConstraints = new JSONArray();
        if (crossSiteConstraints != null && !crossSiteConstraints.isEmpty() && (crossSiteConstraintsValues = crossSiteConstraints.values()) != null && !crossSiteConstraintsValues.isEmpty()) {
            Map constraintMap = (Map)crossSiteConstraintsValues.iterator().next();
            Collection constraints = constraintMap.values();
            for (CrossSiteConstraintContext constraint : constraints) {
                JSONObject jsonObj = new JSONObject();
                String allowHeaders = constraint.getAllowHeaders();
                String allowMethods = constraint.getAllowMethods();
                String allowOrigin = constraint.getAllowOrigin();
                Integer maxAge = constraint.getMaximumAge();
                try {
                    jsonObj.put("allow-origin", (Object)allowOrigin);
                    jsonObj.put("allow-methods", (Object)allowMethods);
                    if (allowHeaders != null) {
                        jsonObj.put("allow-headers", (Object)allowHeaders);
                    }
                    if (maxAge != null) {
                        jsonObj.put("maximum-age", (Object)maxAge);
                    }
                    jsonConstraints.put((Object)jsonObj);
                }
                catch (Exception ex) {}
            }
        }
        return jsonConstraints.toString();
    }

    @Override
    public String getMimeMappings() {
        if (this.serviceContext.supportsMimeMappings()) {
            Map mimeMappings = this.serviceContext.getMimeMappings();
            return mimeMappings == null ? "" : new JSONObject(mimeMappings).toString();
        }
        return null;
    }

    @Override
    public String getProperties() {
        ServiceProperties properties = this.serviceContext.getProperties();
        return properties == null ? "" : ServiceConfigurationBeanImpl.asJSONObject(properties).toString();
    }

    @Override
    public String getRequiredRoles() {
        List<String> roles = Arrays.asList(this.serviceContext.getRequireRoles());
        return roles == null ? "" : new JSONArray(roles).toString();
    }

    @Override
    public String getServiceRealm() {
        RealmContext realm = this.serviceContext.getServiceRealm();
        if (realm != null) {
            return realm.getName();
        }
        return "";
    }

    private static JSONObject asJSONObject(ServiceProperties properties) {
        JSONObject result = new JSONObject();
        try {
            for (String name : properties.simplePropertyNames()) {
                result.put(name, (Object)properties.get(name));
            }
            for (String name : properties.nestedPropertyNames()) {
                for (ServiceProperties nested : properties.getNested(name)) {
                    result.append(name, (Object)ServiceConfigurationBeanImpl.asJSONObject(nested));
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

