/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.update.check;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.kaazing.gateway.update.check.GatewayVersion;
import org.kaazing.gateway.update.check.UpdateCheckGatewayObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(UpdateCheckTask.class);
    private final UpdateCheckGatewayObserver updateCheckGatewayObserver;
    private static final String protocolVersion = "1.0";
    private final String versionServiceUrl;

    public UpdateCheckTask(UpdateCheckGatewayObserver updateCheckGatewayObserver, String webServiceUrl, String productName) {
        this.updateCheckGatewayObserver = updateCheckGatewayObserver;
        this.versionServiceUrl = webServiceUrl.endsWith("/") ? String.format("%s%s/%s/latest", webServiceUrl, productName, protocolVersion) : String.format("%s/%s/%s/latest", webServiceUrl, productName, protocolVersion);
    }

    @Override
    public void run() {
        GatewayVersion latestVersion = this.fetchLatestVersion();
        if (latestVersion != null) {
            this.updateCheckGatewayObserver.setLatestGatewayVersion(latestVersion);
        }
    }

    private GatewayVersion fetchLatestVersion() {
        GatewayVersion latestVersion = null;
        String updateVersionUrl = this.getVersionServiceUrl();
        try {
            URL url = new URL(updateVersionUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Kaazing Update Property");
            connection.setRequestProperty("Connection", "close");
            connection.setRequestProperty("Accept", "text/plain");
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode > 300) {
                this.logger.warn(String.format("Unexpected %d response code from versioning property", responseCode));
                return null;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));){
                JSONTokener tokener = new JSONTokener((Reader)br);
                JSONObject root = new JSONObject(tokener);
                String version = root.getString("version");
                latestVersion = GatewayVersion.parseGatewayVersion(version);
            }
        }
        catch (Exception e) {
            this.logger.warn(String.format("Update Check: Could not contact Kaazing versioning property at %s to find latest version of product: %s", updateVersionUrl, e));
        }
        return latestVersion;
    }

    protected String getVersionServiceUrl() {
        return this.versionServiceUrl;
    }
}

