/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.update.check;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.kaazing.gateway.server.GatewayObserverFactorySpi;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.server.impl.VersionUtils;
import org.kaazing.gateway.update.check.GatewayVersion;
import org.kaazing.gateway.update.check.UpdateCheckListener;
import org.kaazing.gateway.update.check.UpdateCheckLoggingListener;
import org.kaazing.gateway.update.check.UpdateCheckTask;
import org.kaazing.gateway.util.InternalSystemProperty;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;

public class UpdateCheckGatewayObserver
implements GatewayObserverFactorySpi {
    private static final String ENTERPRISE_URL = "https://version.kaazing.com";
    private static final String COMMUNITY_URL = "https://version.kaazing.org";
    private GatewayVersion currentVersion;
    private String productName;
    private String versionServiceUrl;
    private Set<UpdateCheckListener> listeners = new HashSet<UpdateCheckListener>();
    private GatewayVersion latestVersion;

    public UpdateCheckGatewayObserver() {
        this.addListener(new UpdateCheckLoggingListener());
    }

    private synchronized GatewayVersion getLatestGatewayVersion() {
        return this.latestVersion;
    }

    protected void setLatestGatewayVersion(GatewayVersion newlatestVersion) {
        if (this.latestVersion != null && this.latestVersion.compareTo(newlatestVersion) >= 0) {
            return;
        }
        this.latestVersion = newlatestVersion;
        if (newlatestVersion.compareTo(this.currentVersion) <= 0) {
            return;
        }
        for (UpdateCheckListener listener : this.listeners) {
            listener.newVersionAvailable(this.currentVersion, this.getLatestGatewayVersion());
        }
    }

    public void addListener(UpdateCheckListener newListener) {
        if (newListener == null) {
            throw new IllegalArgumentException("newListener");
        }
        GatewayVersion latestGatewayVersion = this.getLatestGatewayVersion();
        if (latestGatewayVersion != null && latestGatewayVersion.compareTo(this.currentVersion) > 0) {
            newListener.newVersionAvailable(this.currentVersion, latestGatewayVersion);
        }
        this.listeners.add(newListener);
    }

    public void startingGateway(GatewayContext gatewayContext) {
        Map injectables = gatewayContext.getInjectables();
        Properties properties = (Properties)injectables.get("configuration");
        if (!InternalSystemProperty.UPDATE_CHECK.getBooleanProperty(properties)) {
            return;
        }
        this.productName = VersionUtils.getGatewayProductTitle().replaceAll("\\s+", "");
        this.currentVersion = GatewayVersion.parseGatewayVersion(VersionUtils.getGatewayProductVersionPatch());
        String serviceUrl = InternalSystemProperty.UPDATE_CHECK_SERVICE_URL.getProperty(properties);
        this.versionServiceUrl = serviceUrl != null ? serviceUrl : (VersionUtils.getGatewayProductEdition().toLowerCase().contains("enterprise") ? ENTERPRISE_URL : COMMUNITY_URL);
        SchedulerProvider provider = (SchedulerProvider)injectables.get("schedulerProvider");
        ScheduledExecutorService scheduler = provider.getScheduler("update_check", false);
        UpdateCheckTask updateCheckTask = new UpdateCheckTask(this, this.versionServiceUrl, this.productName);
        scheduler.scheduleAtFixedRate(updateCheckTask, 0L, 7L, TimeUnit.DAYS);
    }
}

